/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server;

import com.google.common.base.Preconditions;
import com.netflix.config.CachedDynamicIntProperty;
import com.netflix.netty.common.CloseOnIdleStateHandler;
import com.netflix.netty.common.Http1ConnectionCloseHandler;
import com.netflix.netty.common.Http1ConnectionExpiryHandler;
import com.netflix.netty.common.HttpRequestReadTimeoutHandler;
import com.netflix.netty.common.HttpServerLifecycleChannelHandler;
import com.netflix.netty.common.SourceAddressChannelHandler;
import com.netflix.netty.common.accesslog.AccessLogChannelHandler;
import com.netflix.netty.common.accesslog.AccessLogPublisher;
import com.netflix.netty.common.channel.config.ChannelConfig;
import com.netflix.netty.common.channel.config.CommonChannelConfigKeys;
import com.netflix.netty.common.metrics.EventLoopGroupMetrics;
import com.netflix.netty.common.metrics.HttpBodySizeRecordingChannelHandler;
import com.netflix.netty.common.metrics.HttpMetricsChannelHandler;
import com.netflix.netty.common.metrics.PerEventLoopMetricsChannelHandler;
import com.netflix.netty.common.proxyprotocol.ElbProxyProtocolChannelHandler;
import com.netflix.netty.common.proxyprotocol.StripUntrustedProxyHeadersHandler;
import com.netflix.netty.common.throttle.MaxInboundConnectionsHandler;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.zuul.FilterLoader;
import com.netflix.zuul.FilterUsageNotifier;
import com.netflix.zuul.RequestCompleteHandler;
import com.netflix.zuul.context.SessionContextDecorator;
import com.netflix.zuul.filters.ZuulFilter;
import com.netflix.zuul.filters.passport.InboundPassportStampingFilter;
import com.netflix.zuul.filters.passport.OutboundPassportStampingFilter;
import com.netflix.zuul.message.ZuulMessage;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.netty.filter.FilterRunner;
import com.netflix.zuul.netty.filter.ZuulEndPointRunner;
import com.netflix.zuul.netty.filter.ZuulFilterChainHandler;
import com.netflix.zuul.netty.filter.ZuulFilterChainRunner;
import com.netflix.zuul.netty.insights.PassportLoggingHandler;
import com.netflix.zuul.netty.insights.PassportStateHttpServerHandler;
import com.netflix.zuul.netty.insights.ServerStateHandler;
import com.netflix.zuul.netty.server.ClientRequestReceiver;
import com.netflix.zuul.netty.server.ClientResponseWriter;
import com.netflix.zuul.netty.server.ZuulDependencyKeys;
import com.netflix.zuul.netty.server.ssl.SslHandshakeInfoHandler;
import com.netflix.zuul.passport.PassportState;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AttributeKey;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;

public abstract class BaseZuulChannelInitializer
extends ChannelInitializer<Channel> {
    public static final String HTTP_CODEC_HANDLER_NAME = "codec";
    public static final AttributeKey<ChannelConfig> ATTR_CHANNEL_CONFIG = AttributeKey.newInstance((String)"channel_config");
    protected static final LoggingHandler nettyLogger = new LoggingHandler("zuul.server.nettylog", LogLevel.INFO);
    public static final CachedDynamicIntProperty MAX_INITIAL_LINE_LENGTH = new CachedDynamicIntProperty("server.http.decoder.maxInitialLineLength", 16384);
    public static final CachedDynamicIntProperty MAX_HEADER_SIZE = new CachedDynamicIntProperty("server.http.decoder.maxHeaderSize", 32768);
    public static final CachedDynamicIntProperty MAX_CHUNK_SIZE = new CachedDynamicIntProperty("server.http.decoder.maxChunkSize", 32768);
    @Deprecated
    protected final int port;
    protected final String metricId;
    protected final ChannelConfig channelConfig;
    protected final ChannelConfig channelDependencies;
    protected final int idleTimeout;
    protected final int httpRequestReadTimeout;
    protected final int maxRequestsPerConnection;
    protected final int maxRequestsPerConnectionInBrownout;
    protected final int connectionExpiry;
    protected final int maxConnections;
    private final int connCloseDelay;
    protected final Registry registry;
    protected final HttpMetricsChannelHandler httpMetricsHandler;
    protected final PerEventLoopMetricsChannelHandler.Connections perEventLoopConnectionMetricsHandler;
    protected final PerEventLoopMetricsChannelHandler.HttpRequests perEventLoopRequestsMetricsHandler;
    protected final MaxInboundConnectionsHandler maxConnectionsHandler;
    protected final AccessLogPublisher accessLogPublisher;
    protected final PassportLoggingHandler passportLoggingHandler;
    protected final boolean withProxyProtocol;
    protected final StripUntrustedProxyHeadersHandler stripInboundProxyHeadersHandler;
    protected final ChannelHandler rateLimitingChannelHandler;
    protected final ChannelHandler sslClientCertCheckChannelHandler;
    protected final SessionContextDecorator sessionContextDecorator;
    protected final RequestCompleteHandler requestCompleteHandler;
    protected final Counter httpRequestReadTimeoutCounter;
    protected final FilterLoader filterLoader;
    protected final FilterUsageNotifier filterUsageNotifier;
    protected final SourceAddressChannelHandler sourceAddressChannelHandler;
    protected final ChannelGroup channels;

    protected BaseZuulChannelInitializer(String metricId, ChannelConfig channelConfig, ChannelConfig channelDependencies, ChannelGroup channels) {
        this(-1, metricId, channelConfig, channelDependencies, channels);
    }

    @Deprecated
    protected BaseZuulChannelInitializer(int port, ChannelConfig channelConfig, ChannelConfig channelDependencies, ChannelGroup channels) {
        this(port, String.valueOf(port), channelConfig, channelDependencies, channels);
    }

    private BaseZuulChannelInitializer(int port, String metricId, ChannelConfig channelConfig, ChannelConfig channelDependencies, ChannelGroup channels) {
        this.port = port;
        Preconditions.checkNotNull((Object)metricId, (Object)"metricId");
        this.metricId = metricId;
        this.channelConfig = channelConfig;
        this.channelDependencies = channelDependencies;
        this.channels = channels;
        this.accessLogPublisher = channelDependencies.get(ZuulDependencyKeys.accessLogPublisher);
        this.withProxyProtocol = channelConfig.get(CommonChannelConfigKeys.withProxyProtocol);
        this.idleTimeout = channelConfig.get(CommonChannelConfigKeys.idleTimeout);
        this.httpRequestReadTimeout = channelConfig.get(CommonChannelConfigKeys.httpRequestReadTimeout);
        this.registry = channelDependencies.get(ZuulDependencyKeys.registry);
        this.httpMetricsHandler = new HttpMetricsChannelHandler(this.registry, "server", "http-" + metricId);
        EventLoopGroupMetrics eventLoopGroupMetrics = channelDependencies.get(ZuulDependencyKeys.eventLoopGroupMetrics);
        PerEventLoopMetricsChannelHandler perEventLoopMetricsHandler = new PerEventLoopMetricsChannelHandler(eventLoopGroupMetrics);
        this.perEventLoopConnectionMetricsHandler = new PerEventLoopMetricsChannelHandler.Connections(perEventLoopMetricsHandler);
        this.perEventLoopRequestsMetricsHandler = new PerEventLoopMetricsChannelHandler.HttpRequests(perEventLoopMetricsHandler);
        this.maxConnections = channelConfig.get(CommonChannelConfigKeys.maxConnections);
        this.maxConnectionsHandler = new MaxInboundConnectionsHandler(this.registry, metricId, this.maxConnections);
        this.maxRequestsPerConnection = channelConfig.get(CommonChannelConfigKeys.maxRequestsPerConnection);
        this.maxRequestsPerConnectionInBrownout = channelConfig.get(CommonChannelConfigKeys.maxRequestsPerConnectionInBrownout);
        this.connectionExpiry = channelConfig.get(CommonChannelConfigKeys.connectionExpiry);
        this.connCloseDelay = channelConfig.get(CommonChannelConfigKeys.connCloseDelay);
        StripUntrustedProxyHeadersHandler.AllowWhen allowProxyHeadersWhen = channelConfig.get(CommonChannelConfigKeys.allowProxyHeadersWhen);
        this.stripInboundProxyHeadersHandler = new StripUntrustedProxyHeadersHandler(allowProxyHeadersWhen);
        this.rateLimitingChannelHandler = (ChannelHandler)channelDependencies.get(ZuulDependencyKeys.rateLimitingChannelHandlerProvider).get();
        this.sslClientCertCheckChannelHandler = (ChannelHandler)channelDependencies.get(ZuulDependencyKeys.sslClientCertCheckChannelHandlerProvider).get();
        this.passportLoggingHandler = new PassportLoggingHandler(this.registry);
        this.sessionContextDecorator = channelDependencies.get(ZuulDependencyKeys.sessionCtxDecorator);
        this.requestCompleteHandler = channelDependencies.get(ZuulDependencyKeys.requestCompleteHandler);
        this.httpRequestReadTimeoutCounter = channelDependencies.get(ZuulDependencyKeys.httpRequestReadTimeoutCounter);
        this.filterLoader = channelDependencies.get(ZuulDependencyKeys.filterLoader);
        this.filterUsageNotifier = channelDependencies.get(ZuulDependencyKeys.filterUsageNotifier);
        this.sourceAddressChannelHandler = new SourceAddressChannelHandler();
    }

    protected void storeChannel(Channel ch) {
        this.channels.add((Object)ch);
        ch.attr(ATTR_CHANNEL_CONFIG).set((Object)this.channelConfig);
    }

    protected void addPassportHandler(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new ServerStateHandler.InboundHandler(this.registry, "http-" + this.metricId)});
        pipeline.addLast(new ChannelHandler[]{new ServerStateHandler.OutboundHandler(this.registry)});
    }

    protected void addTcpRelatedHandlers(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{this.sourceAddressChannelHandler});
        pipeline.addLast(new ChannelHandler[]{this.perEventLoopConnectionMetricsHandler});
        new ElbProxyProtocolChannelHandler(this.registry, this.withProxyProtocol).addProxyProtocol(pipeline);
        pipeline.addLast(new ChannelHandler[]{this.maxConnectionsHandler});
    }

    protected void addHttp1Handlers(ChannelPipeline pipeline) {
        pipeline.addLast(HTTP_CODEC_HANDLER_NAME, (ChannelHandler)this.createHttpServerCodec());
        pipeline.addLast(new ChannelHandler[]{new Http1ConnectionCloseHandler()});
        pipeline.addLast("conn_expiry_handler", (ChannelHandler)new Http1ConnectionExpiryHandler(this.maxRequestsPerConnection, this.maxRequestsPerConnectionInBrownout, this.connectionExpiry));
    }

    protected HttpServerCodec createHttpServerCodec() {
        return new HttpServerCodec(MAX_INITIAL_LINE_LENGTH.get(), MAX_HEADER_SIZE.get(), MAX_CHUNK_SIZE.get(), false);
    }

    protected void addHttpRelatedHandlers(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new PassportStateHttpServerHandler.InboundHandler()});
        pipeline.addLast(new ChannelHandler[]{new PassportStateHttpServerHandler.OutboundHandler()});
        if (this.httpRequestReadTimeout > -1) {
            HttpRequestReadTimeoutHandler.addLast(pipeline, this.httpRequestReadTimeout, TimeUnit.MILLISECONDS, this.httpRequestReadTimeoutCounter);
        }
        pipeline.addLast(new ChannelHandler[]{new HttpServerLifecycleChannelHandler.HttpServerLifecycleInboundChannelHandler()});
        pipeline.addLast(new ChannelHandler[]{new HttpServerLifecycleChannelHandler.HttpServerLifecycleOutboundChannelHandler()});
        pipeline.addLast(new ChannelHandler[]{new HttpBodySizeRecordingChannelHandler.InboundChannelHandler()});
        pipeline.addLast(new ChannelHandler[]{new HttpBodySizeRecordingChannelHandler.OutboundChannelHandler()});
        pipeline.addLast(new ChannelHandler[]{this.httpMetricsHandler});
        pipeline.addLast(new ChannelHandler[]{this.perEventLoopRequestsMetricsHandler});
        if (this.accessLogPublisher != null) {
            pipeline.addLast(new ChannelHandler[]{new AccessLogChannelHandler.AccessLogInboundChannelHandler(this.accessLogPublisher)});
            pipeline.addLast(new ChannelHandler[]{new AccessLogChannelHandler.AccessLogOutboundChannelHandler()});
        }
        pipeline.addLast(new ChannelHandler[]{this.stripInboundProxyHeadersHandler});
        if (this.rateLimitingChannelHandler != null) {
            pipeline.addLast(new ChannelHandler[]{this.rateLimitingChannelHandler});
        }
    }

    protected void addTimeoutHandlers(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(0L, 0L, (long)this.idleTimeout, TimeUnit.MILLISECONDS)});
        pipeline.addLast(new ChannelHandler[]{new CloseOnIdleStateHandler(this.registry, this.metricId)});
    }

    protected void addSslInfoHandlers(ChannelPipeline pipeline, boolean isSSlFromIntermediary) {
        pipeline.addLast("ssl_info", (ChannelHandler)new SslHandshakeInfoHandler(this.registry, isSSlFromIntermediary));
    }

    protected void addSslClientCertChecks(ChannelPipeline pipeline) {
        if (this.channelConfig.get(ZuulDependencyKeys.SSL_CLIENT_CERT_CHECK_REQUIRED).booleanValue()) {
            if (this.sslClientCertCheckChannelHandler == null) {
                throw new IllegalArgumentException("A sslClientCertCheckChannelHandler is required!");
            }
            pipeline.addLast(new ChannelHandler[]{this.sslClientCertCheckChannelHandler});
        }
    }

    protected void addZuulHandlers(ChannelPipeline pipeline) {
        pipeline.addLast("logger", (ChannelHandler)nettyLogger);
        pipeline.addLast(new ChannelHandler[]{new ClientRequestReceiver(this.sessionContextDecorator)});
        pipeline.addLast(new ChannelHandler[]{this.passportLoggingHandler});
        this.addZuulFilterChainHandler(pipeline);
        pipeline.addLast(new ChannelHandler[]{new ClientResponseWriter(this.requestCompleteHandler, this.registry)});
    }

    protected void addZuulFilterChainHandler(ChannelPipeline pipeline) {
        ZuulFilter<HttpResponseMessage, HttpResponseMessage>[] responseFilters = this.getFilters(new OutboundPassportStampingFilter(PassportState.FILTERS_OUTBOUND_START), new OutboundPassportStampingFilter(PassportState.FILTERS_OUTBOUND_END));
        ZuulFilterChainRunner<HttpResponseMessage> responseFilterChain = this.getFilterChainRunner(responseFilters, this.filterUsageNotifier);
        ZuulEndPointRunner endPoint = this.getEndpointRunner(responseFilterChain, this.filterUsageNotifier, this.filterLoader);
        ZuulFilter<HttpRequestMessage, HttpRequestMessage>[] requestFilters = this.getFilters(new InboundPassportStampingFilter(PassportState.FILTERS_INBOUND_START), new InboundPassportStampingFilter(PassportState.FILTERS_INBOUND_END));
        ZuulFilterChainRunner<HttpRequestMessage> requestFilterChain = this.getFilterChainRunner(requestFilters, this.filterUsageNotifier, endPoint);
        pipeline.addLast(new ChannelHandler[]{new ZuulFilterChainHandler(requestFilterChain, responseFilterChain)});
    }

    protected ZuulEndPointRunner getEndpointRunner(ZuulFilterChainRunner<HttpResponseMessage> responseFilterChain, FilterUsageNotifier filterUsageNotifier, FilterLoader filterLoader) {
        return new ZuulEndPointRunner(filterUsageNotifier, filterLoader, responseFilterChain);
    }

    protected <T extends ZuulMessage> ZuulFilterChainRunner<T> getFilterChainRunner(ZuulFilter<T, T>[] filters, FilterUsageNotifier filterUsageNotifier) {
        return new ZuulFilterChainRunner<T>(filters, filterUsageNotifier);
    }

    protected <T extends ZuulMessage, R extends ZuulMessage> ZuulFilterChainRunner<T> getFilterChainRunner(ZuulFilter<T, T>[] filters, FilterUsageNotifier filterUsageNotifier, FilterRunner<T, R> filterRunner) {
        return new ZuulFilterChainRunner<T>(filters, filterUsageNotifier, filterRunner);
    }

    public <T extends ZuulMessage> ZuulFilter<T, T>[] getFilters(ZuulFilter<T, T> start, ZuulFilter<T, T> stop) {
        SortedSet<ZuulFilter<?, ?>> zuulFilters = this.filterLoader.getFiltersByType(start.filterType());
        ZuulFilter[] filters = new ZuulFilter[zuulFilters.size() + 2];
        filters[0] = start;
        int i = 1;
        for (ZuulFilter zuulFilter : zuulFilters) {
            filters[i++] = zuulFilter;
        }
        filters[filters.length - 1] = stop;
        return filters;
    }
}

