/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server;

import com.google.errorprone.annotations.ForOverride;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.config.ChainedDynamicProperty;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.discovery.EurekaClient;
import com.netflix.netty.common.accesslog.AccessLogPublisher;
import com.netflix.netty.common.channel.config.ChannelConfig;
import com.netflix.netty.common.channel.config.ChannelConfigValue;
import com.netflix.netty.common.channel.config.CommonChannelConfigKeys;
import com.netflix.netty.common.metrics.EventLoopGroupMetrics;
import com.netflix.netty.common.proxyprotocol.StripUntrustedProxyHeadersHandler;
import com.netflix.netty.common.ssl.ServerSslConfig;
import com.netflix.netty.common.status.ServerStatusManager;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.zuul.FilterLoader;
import com.netflix.zuul.FilterUsageNotifier;
import com.netflix.zuul.RequestCompleteHandler;
import com.netflix.zuul.context.SessionContextDecorator;
import com.netflix.zuul.netty.ratelimiting.NullChannelHandlerProvider;
import com.netflix.zuul.netty.server.ClientConnectionsShutdown;
import com.netflix.zuul.netty.server.DefaultEventLoopConfig;
import com.netflix.zuul.netty.server.DirectMemoryMonitor;
import com.netflix.zuul.netty.server.NamedSocketAddress;
import com.netflix.zuul.netty.server.Server;
import com.netflix.zuul.netty.server.ServerTimeout;
import com.netflix.zuul.netty.server.ZuulDependencyKeys;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.util.AsyncMapping;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseServerStartup {
    protected static final Logger LOG = LoggerFactory.getLogger(BaseServerStartup.class);
    protected final ServerStatusManager serverStatusManager;
    protected final Registry registry;
    protected final DirectMemoryMonitor directMemoryMonitor;
    protected final EventLoopGroupMetrics eventLoopGroupMetrics;
    protected final EurekaClient discoveryClient;
    protected final ApplicationInfoManager applicationInfoManager;
    protected final AccessLogPublisher accessLogPublisher;
    protected final SessionContextDecorator sessionCtxDecorator;
    protected final RequestCompleteHandler reqCompleteHandler;
    protected final FilterLoader filterLoader;
    protected final FilterUsageNotifier usageNotifier;
    private Map<NamedSocketAddress, ? extends ChannelInitializer<?>> addrsToChannelInitializers;
    private ClientConnectionsShutdown clientConnectionsShutdown;
    private Server server;

    @Inject
    public BaseServerStartup(ServerStatusManager serverStatusManager, FilterLoader filterLoader, SessionContextDecorator sessionCtxDecorator, FilterUsageNotifier usageNotifier, RequestCompleteHandler reqCompleteHandler, Registry registry, DirectMemoryMonitor directMemoryMonitor, EventLoopGroupMetrics eventLoopGroupMetrics, EurekaClient discoveryClient, ApplicationInfoManager applicationInfoManager, AccessLogPublisher accessLogPublisher) {
        this.serverStatusManager = serverStatusManager;
        this.registry = registry;
        this.directMemoryMonitor = directMemoryMonitor;
        this.eventLoopGroupMetrics = eventLoopGroupMetrics;
        this.discoveryClient = discoveryClient;
        this.applicationInfoManager = applicationInfoManager;
        this.accessLogPublisher = accessLogPublisher;
        this.sessionCtxDecorator = sessionCtxDecorator;
        this.reqCompleteHandler = reqCompleteHandler;
        this.filterLoader = filterLoader;
        this.usageNotifier = usageNotifier;
    }

    public Server server() {
        return this.server;
    }

    @Inject
    public void init() throws Exception {
        DefaultChannelGroup clientChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.clientConnectionsShutdown = new ClientConnectionsShutdown((ChannelGroup)clientChannels, (EventExecutor)GlobalEventExecutor.INSTANCE, this.discoveryClient);
        this.addrsToChannelInitializers = this.chooseAddrsAndChannels((ChannelGroup)clientChannels);
        this.server = new Server(this.registry, this.serverStatusManager, this.addrsToChannelInitializers, this.clientConnectionsShutdown, this.eventLoopGroupMetrics, new DefaultEventLoopConfig());
    }

    @Deprecated
    protected Map<Integer, ChannelInitializer> choosePortsAndChannels(ChannelGroup clientChannels) {
        throw new UnsupportedOperationException("unimplemented");
    }

    @ForOverride
    protected Map<NamedSocketAddress, ChannelInitializer<?>> chooseAddrsAndChannels(ChannelGroup clientChannels) {
        Map<Integer, ChannelInitializer<?>> portMap = this.choosePortsAndChannels(clientChannels);
        return Server.convertPortMap(portMap);
    }

    protected ChannelConfig defaultChannelDependencies(String listenAddressName) {
        ChannelConfig channelDependencies = new ChannelConfig();
        this.addChannelDependencies(channelDependencies, listenAddressName);
        return channelDependencies;
    }

    protected void addChannelDependencies(ChannelConfig channelDeps, String listenAddressName) {
        channelDeps.set(ZuulDependencyKeys.registry, this.registry);
        channelDeps.set(ZuulDependencyKeys.applicationInfoManager, this.applicationInfoManager);
        channelDeps.set(ZuulDependencyKeys.serverStatusManager, this.serverStatusManager);
        channelDeps.set(ZuulDependencyKeys.accessLogPublisher, this.accessLogPublisher);
        channelDeps.set(ZuulDependencyKeys.sessionCtxDecorator, this.sessionCtxDecorator);
        channelDeps.set(ZuulDependencyKeys.requestCompleteHandler, this.reqCompleteHandler);
        Counter httpRequestReadTimeoutCounter = this.registry.counter("server.http.request.read.timeout");
        channelDeps.set(ZuulDependencyKeys.httpRequestReadTimeoutCounter, httpRequestReadTimeoutCounter);
        channelDeps.set(ZuulDependencyKeys.filterLoader, this.filterLoader);
        channelDeps.set(ZuulDependencyKeys.filterUsageNotifier, this.usageNotifier);
        channelDeps.set(ZuulDependencyKeys.eventLoopGroupMetrics, this.eventLoopGroupMetrics);
        channelDeps.set(ZuulDependencyKeys.sslClientCertCheckChannelHandlerProvider, new NullChannelHandlerProvider());
        channelDeps.set(ZuulDependencyKeys.rateLimitingChannelHandlerProvider, new NullChannelHandlerProvider());
    }

    public static int chooseIntChannelProperty(String listenAddressName, String propertySuffix, int defaultValue) {
        String globalPropertyName = "server." + propertySuffix;
        String listenAddressPropertyName = "server." + listenAddressName + "." + propertySuffix;
        Integer value = new DynamicIntProperty(listenAddressPropertyName, -999).get();
        if (value == -999 && (value = Integer.valueOf(new DynamicIntProperty(globalPropertyName, -999).get())) == -999) {
            value = defaultValue;
        }
        return value;
    }

    public static boolean chooseBooleanChannelProperty(String listenAddressName, String propertySuffix, boolean defaultValue) {
        String globalPropertyName = "server." + propertySuffix;
        String listenAddressPropertyName = "server." + listenAddressName + "." + propertySuffix;
        Boolean value = new ChainedDynamicProperty.DynamicBooleanPropertyThatSupportsNull(listenAddressPropertyName, null).get();
        if (value == null && (value = new DynamicBooleanProperty(globalPropertyName, defaultValue).getDynamicProperty().getBoolean()) == null) {
            value = defaultValue;
        }
        return value;
    }

    public static ChannelConfig defaultChannelConfig(String listenAddressName) {
        ChannelConfig config = new ChannelConfig();
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxConnections, BaseServerStartup.chooseIntChannelProperty(listenAddressName, "connection.max", CommonChannelConfigKeys.maxConnections.defaultValue())));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxRequestsPerConnection, BaseServerStartup.chooseIntChannelProperty(listenAddressName, "connection.max.requests", 20000)));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxRequestsPerConnectionInBrownout, BaseServerStartup.chooseIntChannelProperty(listenAddressName, "connection.max.requests.brownout", CommonChannelConfigKeys.maxRequestsPerConnectionInBrownout.defaultValue())));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.connectionExpiry, BaseServerStartup.chooseIntChannelProperty(listenAddressName, "connection.expiry", CommonChannelConfigKeys.connectionExpiry.defaultValue())));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.httpRequestReadTimeout, BaseServerStartup.chooseIntChannelProperty(listenAddressName, "http.request.read.timeout", CommonChannelConfigKeys.httpRequestReadTimeout.defaultValue())));
        int connectionIdleTimeout = BaseServerStartup.chooseIntChannelProperty(listenAddressName, "connection.idle.timeout", CommonChannelConfigKeys.idleTimeout.defaultValue());
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.idleTimeout, connectionIdleTimeout));
        config.add(new ChannelConfigValue<ServerTimeout>(CommonChannelConfigKeys.serverTimeout, new ServerTimeout(connectionIdleTimeout)));
        config.add(new ChannelConfigValue<StripUntrustedProxyHeadersHandler.AllowWhen>(CommonChannelConfigKeys.allowProxyHeadersWhen, StripUntrustedProxyHeadersHandler.AllowWhen.NEVER));
        config.set(CommonChannelConfigKeys.withProxyProtocol, true);
        config.set(CommonChannelConfigKeys.preferProxyProtocolForClientIp, true);
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.connCloseDelay, BaseServerStartup.chooseIntChannelProperty(listenAddressName, "connection.close.delay", CommonChannelConfigKeys.connCloseDelay.defaultValue())));
        return config;
    }

    public static void addHttp2DefaultConfig(ChannelConfig config, String listenAddressName) {
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxConcurrentStreams, BaseServerStartup.chooseIntChannelProperty(listenAddressName, "http2.max.concurrent.streams", CommonChannelConfigKeys.maxConcurrentStreams.defaultValue())));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.initialWindowSize, BaseServerStartup.chooseIntChannelProperty(listenAddressName, "http2.initialwindowsize", CommonChannelConfigKeys.initialWindowSize.defaultValue())));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxHttp2HeaderTableSize, BaseServerStartup.chooseIntChannelProperty(listenAddressName, "http2.maxheadertablesize", 65536)));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxHttp2HeaderListSize, BaseServerStartup.chooseIntChannelProperty(listenAddressName, "http2.maxheaderlistsize", 32768)));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxRequestsPerConnection, BaseServerStartup.chooseIntChannelProperty(listenAddressName, "connection.max.requests", 4000)));
        config.add(new ChannelConfigValue<Boolean>(CommonChannelConfigKeys.http2AllowGracefulDelayed, BaseServerStartup.chooseBooleanChannelProperty(listenAddressName, "connection.close.graceful.delayed.allow", true)));
        config.add(new ChannelConfigValue<Boolean>(CommonChannelConfigKeys.http2SwallowUnknownExceptionsOnConnClose, BaseServerStartup.chooseBooleanChannelProperty(listenAddressName, "connection.close.swallow.unknown.exceptions", false)));
    }

    @Deprecated
    protected void logPortConfigured(int port) {
        this.logAddrConfigured(new InetSocketAddress(port));
    }

    @Deprecated
    protected void logPortConfigured(int port, ServerSslConfig serverSslConfig) {
        this.logAddrConfigured((SocketAddress)new InetSocketAddress(port), serverSslConfig);
    }

    @Deprecated
    protected void logPortConfigured(int port, AsyncMapping<String, SslContext> sniMapping) {
        this.logAddrConfigured((SocketAddress)new InetSocketAddress(port), sniMapping);
    }

    protected final void logAddrConfigured(SocketAddress socketAddress) {
        LOG.info("Configured address: {}", (Object)socketAddress);
    }

    protected final void logAddrConfigured(SocketAddress socketAddress, @Nullable ServerSslConfig serverSslConfig) {
        String msg = "Configured address: " + socketAddress;
        if (serverSslConfig != null) {
            msg = msg + " with SSL config: " + serverSslConfig;
        }
        LOG.info(msg);
    }

    protected final void logAddrConfigured(SocketAddress socketAddress, @Nullable AsyncMapping<String, SslContext> sniMapping) {
        String msg = "Configured address: " + socketAddress;
        if (sniMapping != null) {
            msg = msg + " with SNI config: " + sniMapping;
        }
        LOG.info(msg);
    }

    protected final void logSecureAddrConfigured(SocketAddress socketAddress, @Nullable Object securityConfig) {
        LOG.info("Configured address: {} with security config {}", (Object)socketAddress, securityConfig);
    }
}

