/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.insights;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.zuul.passport.CurrentPassport;
import com.netflix.zuul.passport.PassportState;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.unix.Errors;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerStateHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServerStateHandler.class);

    private static CurrentPassport passport(ChannelHandlerContext ctx) {
        return CurrentPassport.fromChannel(ctx.channel());
    }

    public static final class OutboundHandler
    extends ChannelOutboundHandlerAdapter {
        private final Registry registry;

        public OutboundHandler(Registry registry) {
            this.registry = registry;
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            ServerStateHandler.passport(ctx).add(PassportState.SERVER_CH_CLOSE);
            super.close(ctx, promise);
        }

        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            ServerStateHandler.passport(ctx).add(PassportState.SERVER_CH_DISCONNECT);
            super.disconnect(ctx, promise);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ServerStateHandler.passport(ctx).add(PassportState.SERVER_CH_EXCEPTION);
            if (cause instanceof Errors.NativeIoException) {
                logger.debug("PassportStateServerHandler Outbound NativeIoException " + cause);
                this.registry.counter("server.connection.exception.outbound", new String[]{"handler", "ServerStateHandler.OutboundHandler", "id", cause.getClass().getSimpleName()}).increment();
            } else {
                super.exceptionCaught(ctx, cause);
            }
        }
    }

    public static final class InboundHandler
    extends ChannelInboundHandlerAdapter {
        private final Registry registry;
        private final Counter totalConnections;
        private final Counter connectionClosed;
        private final Counter connectionErrors;

        public InboundHandler(Registry registry, String metricId) {
            this.registry = registry;
            this.totalConnections = registry.counter("server.connections.connect", new String[]{"id", metricId});
            this.connectionClosed = registry.counter("server.connections.close", new String[]{"id", metricId});
            this.connectionErrors = registry.counter("server.connections.errors", new String[]{"id", metricId});
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.totalConnections.increment();
            ServerStateHandler.passport(ctx).add(PassportState.SERVER_CH_ACTIVE);
            super.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.connectionClosed.increment();
            ServerStateHandler.passport(ctx).add(PassportState.SERVER_CH_INACTIVE);
            super.channelInactive(ctx);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.connectionErrors.increment();
            this.registry.counter("server.connection.exception.inbound", new String[]{"handler", "ServerStateHandler.InboundHandler", "id", cause.getClass().getSimpleName()}).increment();
            ServerStateHandler.passport(ctx).add(PassportState.SERVER_CH_EXCEPTION);
            logger.info("Connection error on Inbound: {} ", cause);
            super.exceptionCaught(ctx, cause);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            CurrentPassport passport;
            if (evt instanceof IdleStateEvent && (passport = CurrentPassport.fromChannel(ctx.channel())) != null) {
                passport.add(PassportState.SERVER_CH_IDLE_TIMEOUT);
            }
            super.userEventTriggered(ctx, evt);
        }
    }
}

