/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.insights;

import com.netflix.zuul.passport.CurrentPassport;
import com.netflix.zuul.passport.PassportState;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.net.SocketAddress;

public final class PassportStateOriginHandler {
    private static CurrentPassport passport(ChannelHandlerContext ctx) {
        return CurrentPassport.fromChannel(ctx.channel());
    }

    public static final class OutboundHandler
    extends ChannelOutboundHandlerAdapter {
        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            PassportStateOriginHandler.passport(ctx).add(PassportState.ORIGIN_CH_DISCONNECT);
            super.disconnect(ctx, promise);
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            PassportStateOriginHandler.passport(ctx).add(PassportState.ORIGIN_CH_CLOSE);
            super.close(ctx, promise);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            PassportStateOriginHandler.passport(ctx).add(PassportState.ORIGIN_CH_EXCEPTION);
            super.exceptionCaught(ctx, cause);
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            super.connect(ctx, remoteAddress, localAddress, promise);
        }
    }

    public static final class InboundHandler
    extends ChannelInboundHandlerAdapter {
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            PassportStateOriginHandler.passport(ctx).add(PassportState.ORIGIN_CH_ACTIVE);
            super.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            PassportStateOriginHandler.passport(ctx).add(PassportState.ORIGIN_CH_INACTIVE);
            super.channelInactive(ctx);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            PassportStateOriginHandler.passport(ctx).add(PassportState.ORIGIN_CH_EXCEPTION);
            super.exceptionCaught(ctx, cause);
        }
    }
}

