/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.insights;

import com.netflix.netty.common.HttpLifecycleChannelHandler;
import com.netflix.zuul.netty.insights.PassportStateListener;
import com.netflix.zuul.passport.CurrentPassport;
import com.netflix.zuul.passport.PassportState;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;

public final class PassportStateHttpServerHandler {
    private static CurrentPassport passport(ChannelHandlerContext ctx) {
        return CurrentPassport.fromChannel(ctx.channel());
    }

    public static final class OutboundHandler
    extends ChannelOutboundHandlerAdapter {
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            CurrentPassport passport = PassportStateHttpServerHandler.passport(ctx);
            if (msg instanceof HttpResponse) {
                passport.add(PassportState.OUT_RESP_HEADERS_SENDING);
                promise.addListener((GenericFutureListener)new PassportStateListener(passport, PassportState.OUT_RESP_HEADERS_SENT, PassportState.OUT_RESP_HEADERS_ERROR_SENDING));
            }
            if (msg instanceof LastHttpContent) {
                passport.add(PassportState.OUT_RESP_LAST_CONTENT_SENDING);
                promise.addListener((GenericFutureListener)new PassportStateListener(passport, PassportState.OUT_RESP_LAST_CONTENT_SENT, PassportState.OUT_RESP_LAST_CONTENT_ERROR_SENDING));
            } else if (msg instanceof HttpContent) {
                passport.add(PassportState.OUT_RESP_CONTENT_SENDING);
                promise.addListener((GenericFutureListener)new PassportStateListener(passport, PassportState.OUT_RESP_CONTENT_SENT, PassportState.OUT_RESP_CONTENT_ERROR_SENDING));
            }
            super.write(ctx, msg, promise);
        }
    }

    public static final class InboundHandler
    extends ChannelInboundHandlerAdapter {
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            CurrentPassport passport = PassportStateHttpServerHandler.passport(ctx);
            if (msg instanceof HttpRequest) {
                if (passport.findState(PassportState.IN_REQ_HEADERS_RECEIVED) != null) {
                    passport = CurrentPassport.createForChannel(ctx.channel());
                }
                passport.add(PassportState.IN_REQ_HEADERS_RECEIVED);
            }
            if (msg instanceof LastHttpContent) {
                passport.add(PassportState.IN_REQ_LAST_CONTENT_RECEIVED);
            } else if (msg instanceof HttpContent) {
                passport.add(PassportState.IN_REQ_CONTENT_RECEIVED);
            }
            super.channelRead(ctx, msg);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            try {
                super.userEventTriggered(ctx, evt);
            }
            finally {
                if (evt instanceof HttpLifecycleChannelHandler.CompleteEvent) {
                    CurrentPassport.clearFromChannel(ctx.channel());
                }
            }
        }
    }
}

