/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.filter;

import com.netflix.spectator.impl.Preconditions;
import com.netflix.zuul.FilterUsageNotifier;
import com.netflix.zuul.filters.ZuulFilter;
import com.netflix.zuul.message.ZuulMessage;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.netty.filter.BaseZuulFilterRunner;
import com.netflix.zuul.netty.filter.FilterRunner;
import com.netflix.zuul.passport.CurrentPassport;
import com.netflix.zuul.passport.PassportState;
import io.netty.handler.codec.http.HttpContent;
import io.perfmark.PerfMark;
import io.perfmark.TaskCloseable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ZuulFilterChainRunner<T extends ZuulMessage>
extends BaseZuulFilterRunner<T, T> {
    private final ZuulFilter<T, T>[] filters;

    public ZuulFilterChainRunner(ZuulFilter<T, T>[] zuulFilters, FilterUsageNotifier usageNotifier, FilterRunner<T, ?> nextStage) {
        super(zuulFilters[0].filterType(), usageNotifier, nextStage);
        this.filters = zuulFilters;
    }

    public ZuulFilterChainRunner(ZuulFilter<T, T>[] zuulFilters, FilterUsageNotifier usageNotifier) {
        this(zuulFilters, usageNotifier, null);
    }

    @Override
    public void filter(T inMesg) {
        try (TaskCloseable ignored = PerfMark.traceTask((Object)this, s -> s.getClass().getSimpleName() + ".filter");){
            this.addPerfMarkTags((ZuulMessage)inMesg);
            this.runFilters(inMesg, this.initRunningFilterIndex(inMesg));
        }
    }

    @Override
    protected void resume(T inMesg) {
        try (TaskCloseable ignored = PerfMark.traceTask((Object)this, s -> s.getClass().getSimpleName() + ".resume");){
            AtomicInteger runningFilterIdx = this.getRunningFilterIndex(inMesg);
            runningFilterIdx.incrementAndGet();
            this.runFilters(inMesg, runningFilterIdx);
        }
    }

    private final void runFilters(T mesg, AtomicInteger runningFilterIdx) {
        T inMesg = mesg;
        String filterName = "-";
        try {
            Preconditions.checkNotNull(mesg, (String)"Input message");
            int i = runningFilterIdx.get();
            while (i < this.filters.length) {
                ZuulFilter<T, T> filter = this.filters[i];
                filterName = filter.filterName();
                T outMesg = this.filter(filter, inMesg);
                if (outMesg == null) {
                    return;
                }
                inMesg = outMesg;
                i = runningFilterIdx.incrementAndGet();
            }
            this.invokeNextStage(inMesg);
        }
        catch (Exception ex) {
            this.handleException((ZuulMessage)inMesg, filterName, ex);
        }
    }

    @Override
    public void filter(T inMesg, HttpContent chunk) {
        String filterName = "-";
        try (TaskCloseable ignored = PerfMark.traceTask((Object)this, s -> s.getClass().getSimpleName() + ".filterChunk");){
            this.addPerfMarkTags((ZuulMessage)inMesg);
            Preconditions.checkNotNull(inMesg, (String)"input message");
            AtomicInteger runningFilterIdx = this.getRunningFilterIndex(inMesg);
            int limit = runningFilterIdx.get();
            for (int i = 0; i < limit; ++i) {
                ZuulFilter<T, T> filter = this.filters[i];
                filterName = filter.filterName();
                if (filter.isDisabled() || this.shouldSkipFilter(inMesg, filter)) continue;
                HttpContent newChunk = filter.processContentChunk((ZuulMessage)inMesg, chunk);
                if (newChunk == null) {
                    return;
                }
                if (newChunk != chunk && chunk.refCnt() > 0) {
                    chunk.release(chunk.refCnt());
                }
                chunk = newChunk;
            }
            if (limit >= this.filters.length) {
                this.invokeNextStage(inMesg, chunk);
            } else {
                inMesg.bufferBodyContents(chunk);
                boolean isAwaitingBody = this.isFilterAwaitingBody(inMesg);
                if (isAwaitingBody) {
                    CurrentPassport passport = CurrentPassport.fromSessionContext(inMesg.getContext());
                    if (inMesg.hasCompleteBody()) {
                        if (inMesg instanceof HttpRequestMessage) {
                            passport.addIfNotAlready(PassportState.FILTERS_INBOUND_BUF_END);
                        } else if (inMesg instanceof HttpResponseMessage) {
                            passport.addIfNotAlready(PassportState.FILTERS_OUTBOUND_BUF_END);
                        }
                    } else if (inMesg instanceof HttpRequestMessage) {
                        passport.addIfNotAlready(PassportState.FILTERS_INBOUND_BUF_START);
                    } else if (inMesg instanceof HttpResponseMessage) {
                        passport.addIfNotAlready(PassportState.FILTERS_OUTBOUND_BUF_START);
                    }
                }
                if (isAwaitingBody && inMesg.hasCompleteBody()) {
                    this.runFilters(inMesg, runningFilterIdx);
                }
            }
        }
        catch (Exception ex) {
            this.handleException((ZuulMessage)inMesg, filterName, ex);
        }
    }
}

