/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.filter;

import com.google.common.base.Strings;
import com.netflix.config.DynamicStringProperty;
import com.netflix.spectator.impl.Preconditions;
import com.netflix.zuul.FilterLoader;
import com.netflix.zuul.FilterUsageNotifier;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.filters.Endpoint;
import com.netflix.zuul.filters.FilterType;
import com.netflix.zuul.filters.SyncZuulFilterAdapter;
import com.netflix.zuul.filters.ZuulFilter;
import com.netflix.zuul.filters.endpoint.MissingEndpointHandlingFilter;
import com.netflix.zuul.filters.endpoint.ProxyEndpoint;
import com.netflix.zuul.message.ZuulMessage;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.message.http.HttpResponseMessageImpl;
import com.netflix.zuul.netty.filter.BaseZuulFilterRunner;
import com.netflix.zuul.netty.filter.FilterRunner;
import com.netflix.zuul.netty.server.MethodBinding;
import io.netty.handler.codec.http.HttpContent;
import io.perfmark.PerfMark;
import io.perfmark.TaskCloseable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ZuulEndPointRunner
extends BaseZuulFilterRunner<HttpRequestMessage, HttpResponseMessage> {
    private final FilterLoader filterLoader;
    private static Logger logger = LoggerFactory.getLogger(ZuulEndPointRunner.class);
    public static final String PROXY_ENDPOINT_FILTER_NAME = ProxyEndpoint.class.getCanonicalName();
    public static final DynamicStringProperty DEFAULT_ERROR_ENDPOINT = new DynamicStringProperty("zuul.filters.error.default", "endpoint.ErrorResponse");
    protected static final ZuulFilter<HttpRequestMessage, HttpResponseMessage> STATIC_RESPONSE_ENDPOINT = new SyncZuulFilterAdapter<HttpRequestMessage, HttpResponseMessage>(){

        @Override
        public HttpResponseMessage apply(HttpRequestMessage request) {
            HttpResponseMessage resp = request.getContext().getStaticResponse();
            resp.finishBufferedBodyIfIncomplete();
            return resp;
        }

        @Override
        public String filterName() {
            return "StaticResponseEndpoint";
        }

        @Override
        public HttpResponseMessage getDefaultOutput(HttpRequestMessage input) {
            return HttpResponseMessageImpl.defaultErrorResponse(input);
        }
    };

    public ZuulEndPointRunner(FilterUsageNotifier usageNotifier, FilterLoader filterLoader, FilterRunner<HttpResponseMessage, HttpResponseMessage> respFilters) {
        super(FilterType.ENDPOINT, usageNotifier, respFilters);
        this.filterLoader = filterLoader;
    }

    public static ZuulFilter<HttpRequestMessage, HttpResponseMessage> getEndpoint(HttpRequestMessage zuulReq) {
        if (zuulReq != null) {
            return (ZuulFilter)zuulReq.getContext().get("_zuul_endpoint");
        }
        return null;
    }

    public static void setEndpoint(HttpRequestMessage zuulReq, ZuulFilter<HttpRequestMessage, HttpResponseMessage> endpoint) {
        zuulReq.getContext().set("_zuul_endpoint", endpoint);
    }

    @Override
    public void filter(HttpRequestMessage zuulReq) {
        if (zuulReq.getContext().isCancelled()) {
            PerfMark.event((String)this.getClass().getName(), (String)"filterCancelled");
            zuulReq.disposeBufferedBody();
            logger.debug("Request was cancelled, UUID {}", (Object)zuulReq.getContext().getUUID());
            return;
        }
        String endpointName = this.getEndPointName(zuulReq.getContext());
        try (TaskCloseable ignored = PerfMark.traceTask((Object)this, s -> s.getClass().getSimpleName() + ".filter");){
            Preconditions.checkNotNull((Object)zuulReq, (String)"input message");
            this.addPerfMarkTags(zuulReq);
            ZuulFilter<HttpRequestMessage, HttpResponseMessage> endpoint = this.getEndpoint(endpointName, zuulReq);
            logger.debug("Got endpoint {}, UUID {}", (Object)endpoint.filterName(), (Object)zuulReq.getContext().getUUID());
            ZuulEndPointRunner.setEndpoint(zuulReq, endpoint);
            HttpResponseMessage zuulResp = this.filter(endpoint, zuulReq);
            if (zuulResp != null && !(endpoint instanceof ProxyEndpoint)) {
                logger.debug("Endpoint calling invokeNextStage, UUID {}", (Object)zuulReq.getContext().getUUID());
                this.invokeNextStage(zuulResp);
            }
        }
        catch (Exception ex) {
            this.handleException(zuulReq, endpointName, ex);
        }
    }

    @Override
    protected void resume(HttpResponseMessage zuulMesg) {
        try (TaskCloseable ignored = PerfMark.traceTask((Object)this, s -> s.getClass().getSimpleName() + ".resume");){
            if (zuulMesg.getContext().isCancelled()) {
                return;
            }
            this.invokeNextStage(zuulMesg);
        }
    }

    @Override
    public void filter(HttpRequestMessage zuulReq, HttpContent chunk) {
        if (zuulReq.getContext().isCancelled()) {
            chunk.release();
            return;
        }
        String endpointName = "-";
        try (TaskCloseable ignored = PerfMark.traceTask((Object)this, s -> s.getClass().getSimpleName() + ".filterChunk");){
            this.addPerfMarkTags(zuulReq);
            ZuulFilter endpoint = (ZuulFilter)Preconditions.checkNotNull(ZuulEndPointRunner.getEndpoint(zuulReq), (String)"endpoint");
            endpointName = endpoint.filterName();
            HttpContent newChunk = endpoint.processContentChunk(zuulReq, chunk);
            if (newChunk != null) {
                zuulReq.bufferBodyContents(newChunk);
                if (newChunk != chunk) {
                    chunk.release();
                }
                if (this.isFilterAwaitingBody(zuulReq) && zuulReq.hasCompleteBody() && !(endpoint instanceof ProxyEndpoint)) {
                    this.invokeNextStage(this.filter(endpoint, zuulReq));
                }
            }
        }
        catch (Exception ex) {
            this.handleException(zuulReq, endpointName, ex);
        }
    }

    protected String getEndPointName(SessionContext zuulCtx) {
        if (zuulCtx.shouldSendErrorResponse()) {
            zuulCtx.setShouldSendErrorResponse(false);
            zuulCtx.setErrorResponseSent(true);
            String errEndPointName = zuulCtx.getErrorEndpoint();
            return Strings.isNullOrEmpty((String)errEndPointName) ? DEFAULT_ERROR_ENDPOINT.get() : errEndPointName;
        }
        return zuulCtx.getEndpoint();
    }

    protected ZuulFilter<HttpRequestMessage, HttpResponseMessage> getEndpoint(String endpointName, HttpRequestMessage zuulRequest) {
        SessionContext zuulCtx = zuulRequest.getContext();
        if (zuulCtx.getStaticResponse() != null) {
            return STATIC_RESPONSE_ENDPOINT;
        }
        if (endpointName == null) {
            return new MissingEndpointHandlingFilter("NO_ENDPOINT_NAME");
        }
        if (PROXY_ENDPOINT_FILTER_NAME.equals(endpointName)) {
            return this.newProxyEndpoint(zuulRequest);
        }
        Endpoint<HttpRequestMessage, HttpResponseMessage> filter = this.getEndpointFilter(endpointName);
        if (filter == null) {
            return new MissingEndpointHandlingFilter(endpointName);
        }
        return filter;
    }

    protected ZuulFilter<HttpRequestMessage, HttpResponseMessage> newProxyEndpoint(HttpRequestMessage zuulRequest) {
        return new ProxyEndpoint(zuulRequest, ZuulEndPointRunner.getChannelHandlerContext(zuulRequest), this.getNextStage(), MethodBinding.NO_OP_BINDING);
    }

    protected <I extends ZuulMessage, O extends ZuulMessage> Endpoint<I, O> getEndpointFilter(String endpointName) {
        return (Endpoint)this.filterLoader.getFilterByNameAndType(endpointName, FilterType.ENDPOINT);
    }
}

