/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.filter;

import com.netflix.config.CachedDynamicIntProperty;
import com.netflix.spectator.impl.Preconditions;
import com.netflix.zuul.ExecutionStatus;
import com.netflix.zuul.FilterUsageNotifier;
import com.netflix.zuul.context.Debug;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.exception.ZuulException;
import com.netflix.zuul.filters.FilterError;
import com.netflix.zuul.filters.FilterSyncType;
import com.netflix.zuul.filters.FilterType;
import com.netflix.zuul.filters.SyncZuulFilter;
import com.netflix.zuul.filters.ZuulFilter;
import com.netflix.zuul.message.ZuulMessage;
import com.netflix.zuul.message.http.HttpRequestInfo;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.netty.filter.FilterRunner;
import com.netflix.zuul.netty.server.MethodBinding;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.perfmark.Link;
import io.perfmark.PerfMark;
import io.perfmark.TaskCloseable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observer;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.schedulers.Schedulers;

@ThreadSafe
public abstract class BaseZuulFilterRunner<I extends ZuulMessage, O extends ZuulMessage>
implements FilterRunner<I, O> {
    private final FilterUsageNotifier usageNotifier;
    private final FilterRunner<O, ? extends ZuulMessage> nextStage;
    private final String RUNNING_FILTER_IDX_SESSION_CTX_KEY;
    private final String AWAITING_BODY_FLAG_SESSION_CTX_KEY;
    private static final Logger logger = LoggerFactory.getLogger(BaseZuulFilterRunner.class);
    private static final CachedDynamicIntProperty FILTER_EXCESSIVE_EXEC_TIME = new CachedDynamicIntProperty("zuul.filters.excessive.execTime", 500);

    protected BaseZuulFilterRunner(FilterType filterType, FilterUsageNotifier usageNotifier, FilterRunner<O, ?> nextStage) {
        this.usageNotifier = (FilterUsageNotifier)Preconditions.checkNotNull((Object)usageNotifier, (String)"filter usage notifier");
        this.nextStage = nextStage;
        this.RUNNING_FILTER_IDX_SESSION_CTX_KEY = (Object)((Object)filterType) + "RunningFilterIndex";
        this.AWAITING_BODY_FLAG_SESSION_CTX_KEY = (Object)((Object)filterType) + "IsAwaitingBody";
    }

    public static final ChannelHandlerContext getChannelHandlerContext(ZuulMessage mesg) {
        return (ChannelHandlerContext)com.google.common.base.Preconditions.checkNotNull(mesg.getContext().get("_netty_server_channel_handler_context"), (Object)"channel handler context");
    }

    public FilterRunner<O, ? extends ZuulMessage> getNextStage() {
        return this.nextStage;
    }

    protected final AtomicInteger initRunningFilterIndex(I zuulMesg) {
        AtomicInteger idx = new AtomicInteger(0);
        zuulMesg.getContext().put(this.RUNNING_FILTER_IDX_SESSION_CTX_KEY, idx);
        return idx;
    }

    protected final AtomicInteger getRunningFilterIndex(I zuulMesg) {
        SessionContext ctx = zuulMesg.getContext();
        return (AtomicInteger)Preconditions.checkNotNull(ctx.get(this.RUNNING_FILTER_IDX_SESSION_CTX_KEY), (String)"runningFilterIndex");
    }

    protected final boolean isFilterAwaitingBody(I zuulMesg) {
        return zuulMesg.getContext().containsKey(this.AWAITING_BODY_FLAG_SESSION_CTX_KEY);
    }

    protected final void setFilterAwaitingBody(I zuulMesg, boolean flag) {
        if (flag) {
            zuulMesg.getContext().put(this.AWAITING_BODY_FLAG_SESSION_CTX_KEY, Boolean.TRUE);
        } else {
            zuulMesg.getContext().remove(this.AWAITING_BODY_FLAG_SESSION_CTX_KEY);
        }
    }

    protected final void invokeNextStage(O zuulMesg, HttpContent chunk) {
        if (this.nextStage != null) {
            try (TaskCloseable ignored = PerfMark.traceTask((Object)this, s -> s.getClass().getSimpleName() + ".invokeNextStageChunk");){
                this.addPerfMarkTags((ZuulMessage)zuulMesg);
                this.nextStage.filter(zuulMesg, chunk);
            }
        }
        try (TaskCloseable ignored = PerfMark.traceTask((Object)this, s -> s.getClass().getSimpleName() + ".fireChannelReadChunk");){
            this.addPerfMarkTags((ZuulMessage)zuulMesg);
            BaseZuulFilterRunner.getChannelHandlerContext(zuulMesg).fireChannelRead((Object)chunk);
        }
    }

    protected final void invokeNextStage(O zuulMesg) {
        if (this.nextStage != null) {
            try (TaskCloseable ignored = PerfMark.traceTask((Object)this, s -> s.getClass().getSimpleName() + ".invokeNextStage");){
                this.addPerfMarkTags((ZuulMessage)zuulMesg);
                this.nextStage.filter(zuulMesg);
            }
        }
        try (TaskCloseable ignored = PerfMark.traceTask((Object)this, s -> s.getClass().getSimpleName() + ".fireChannelRead");){
            this.addPerfMarkTags((ZuulMessage)zuulMesg);
            BaseZuulFilterRunner.getChannelHandlerContext(zuulMesg).fireChannelRead(zuulMesg);
        }
    }

    protected final void addPerfMarkTags(ZuulMessage inMesg) {
        HttpRequestInfo req = null;
        if (inMesg instanceof HttpRequestInfo) {
            req = (HttpRequestInfo)inMesg;
        }
        if (inMesg instanceof HttpResponseMessage) {
            HttpResponseMessage msg = (HttpResponseMessage)inMesg;
            req = msg.getOutboundRequest();
            PerfMark.attachTag((String)"statuscode", (long)msg.getStatus());
        }
        if (req != null) {
            PerfMark.attachTag((String)"path", (Object)req, HttpRequestInfo::getPath);
            PerfMark.attachTag((String)"originalhost", (Object)req, HttpRequestInfo::getOriginalHost);
        }
        PerfMark.attachTag((String)"uuid", (Object)inMesg, m -> m.getContext().getUUID());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final O filter(ZuulFilter<I, O> filter, I inMesg) {
        long startTime = System.nanoTime();
        ZuulMessage snapshot = inMesg.getContext().debugRouting() ? inMesg.clone() : null;
        FilterChainResumer resumer = null;
        try (TaskCloseable ignored = PerfMark.traceTask(filter, f -> f.filterName() + ".filter");){
            this.addPerfMarkTags((ZuulMessage)inMesg);
            ExecutionStatus filterRunStatus = null;
            if (filter.filterType() == FilterType.INBOUND && inMesg.getContext().shouldSendErrorResponse()) {
                filterRunStatus = ExecutionStatus.SKIPPED;
            }
            try (Object ignored2 = PerfMark.traceTask(filter, f -> f.filterName() + ".shouldSkipFilter");){
                if (this.shouldSkipFilter(inMesg, filter)) {
                    filterRunStatus = ExecutionStatus.SKIPPED;
                }
            }
            if (filter.isDisabled()) {
                filterRunStatus = ExecutionStatus.DISABLED;
            }
            if (filterRunStatus != null) {
                this.recordFilterCompletion(filterRunStatus, filter, startTime, (ZuulMessage)inMesg, snapshot);
                ignored2 = filter.getDefaultOutput(inMesg);
                return (O)ignored2;
            }
            if (!this.isMessageBodyReadyForFilter(filter, inMesg)) {
                this.setFilterAwaitingBody(inMesg, true);
                logger.debug("Filter {} waiting for body, UUID {}", (Object)filter.filterName(), (Object)inMesg.getContext().getUUID());
                ignored2 = null;
                return (O)ignored2;
            }
            this.setFilterAwaitingBody(inMesg, false);
            if (snapshot != null) {
                Debug.addRoutingDebug(inMesg.getContext(), "Filter " + filter.filterType().toString() + " " + filter.filterOrder() + " " + filter.filterName());
            }
            inMesg.runBufferedBodyContentThroughFilter(filter);
            if (filter.getSyncType() == FilterSyncType.SYNC) {
                Object outMesg;
                SyncZuulFilter syncFilter = (SyncZuulFilter)filter;
                try (Object ignored2 = PerfMark.traceTask(filter, f -> f.filterName() + ".apply");){
                    this.addPerfMarkTags((ZuulMessage)inMesg);
                    outMesg = syncFilter.apply(inMesg);
                }
                this.recordFilterCompletion(ExecutionStatus.SUCCESS, filter, startTime, (ZuulMessage)inMesg, snapshot);
                ignored2 = outMesg != null ? outMesg : filter.getDefaultOutput(inMesg);
                return (O)ignored2;
            }
            ignored2 = PerfMark.traceTask(filter, f -> f.filterName() + ".applyAsync");
            var11_13 = null;
            try {
                Link nettyToSchedulerLink = PerfMark.linkOut();
                filter.incrementConcurrency();
                resumer = new FilterChainResumer(this, inMesg, filter, snapshot, startTime);
                filter.applyAsync(inMesg).doOnSubscribe(() -> {
                    try (TaskCloseable ignored3 = PerfMark.traceTask((Object)filter, f -> f.filterName() + ".onSubscribeAsync");){
                        PerfMark.linkIn((Link)nettyToSchedulerLink);
                    }
                }).doOnNext(resumer.onNextStarted(nettyToSchedulerLink)).doOnError(resumer.onErrorStarted(nettyToSchedulerLink)).doOnCompleted(resumer.onCompletedStarted(nettyToSchedulerLink)).observeOn(Schedulers.from((Executor)BaseZuulFilterRunner.getChannelHandlerContext(inMesg).executor())).doOnUnsubscribe(resumer::decrementConcurrency).subscribe((Observer)resumer);
            }
            catch (Throwable throwable) {
                var11_13 = throwable;
                throw throwable;
            }
            finally {
                if (ignored2 != null) {
                    if (var11_13 != null) {
                        try {
                            ignored2.close();
                        }
                        catch (Throwable throwable) {
                            var11_13.addSuppressed(throwable);
                        }
                    } else {
                        ignored2.close();
                    }
                }
            }
            O o = null;
            return o;
        }
        catch (Throwable t) {
            if (resumer != null) {
                resumer.decrementConcurrency();
            }
            O outMesg = this.handleFilterException(inMesg, filter, t);
            outMesg.finishBufferedBodyIfIncomplete();
            this.recordFilterCompletion(ExecutionStatus.FAILED, filter, startTime, (ZuulMessage)inMesg, snapshot);
            return outMesg;
        }
    }

    protected final boolean shouldSkipFilter(I inMesg, ZuulFilter<I, O> filter) {
        if (filter.filterType() == FilterType.ENDPOINT) {
            return false;
        }
        SessionContext zuulCtx = inMesg.getContext();
        if (zuulCtx.shouldStopFilterProcessing() && !filter.overrideStopFilterProcessing()) {
            return true;
        }
        if (zuulCtx.isCancelled()) {
            return true;
        }
        return !filter.shouldFilter(inMesg);
    }

    private boolean isMessageBodyReadyForFilter(ZuulFilter filter, I inMesg) {
        return !filter.needsBodyBuffered(inMesg) || inMesg.hasCompleteBody();
    }

    protected O handleFilterException(I inMesg, ZuulFilter<I, O> filter, Throwable ex) {
        inMesg.getContext().setError(ex);
        if (filter.filterType() == FilterType.ENDPOINT) {
            inMesg.getContext().setShouldSendErrorResponse(true);
        }
        this.recordFilterError(inMesg, filter, ex);
        return filter.getDefaultOutput(inMesg);
    }

    protected void recordFilterError(I inMesg, ZuulFilter<I, O> filter, Throwable t) {
        String errorMsg = "Filter Exception: filter=" + filter.filterName() + ", request-info=" + inMesg.getInfoForLogging() + ", msg=" + String.valueOf(t.getMessage());
        if (t instanceof ZuulException && !((ZuulException)t).shouldLogAsError()) {
            logger.warn(errorMsg);
        } else {
            logger.error(errorMsg, t);
        }
        SessionContext zuulCtx = inMesg.getContext();
        zuulCtx.getFilterErrors().add(new FilterError(filter.filterName(), filter.filterType().toString(), t));
        if (zuulCtx.debugRouting()) {
            Debug.addRoutingDebug(zuulCtx, "Running Filter failed " + filter.filterName() + " type:" + (Object)((Object)filter.filterType()) + " order:" + filter.filterOrder() + " " + t.getMessage());
        }
    }

    protected void recordFilterCompletion(ExecutionStatus status, ZuulFilter<I, O> filter, long startTime, ZuulMessage zuulMesg, ZuulMessage startSnapshot) {
        SessionContext zuulCtx = zuulMesg.getContext();
        long execTimeNs = System.nanoTime() - startTime;
        long execTimeMs = execTimeNs / 1000000L;
        if (execTimeMs >= (long)FILTER_EXCESSIVE_EXEC_TIME.get()) {
            logger.warn("Filter {} took {} ms to complete! status = {}", new Object[]{filter.filterName(), execTimeMs, status.name()});
        }
        switch (status) {
            case FAILED: {
                if (!logger.isDebugEnabled()) break;
                zuulCtx.addFilterExecutionSummary(filter.filterName(), ExecutionStatus.FAILED.name(), execTimeMs);
                break;
            }
            case SUCCESS: {
                if (logger.isDebugEnabled()) {
                    zuulCtx.addFilterExecutionSummary(filter.filterName(), ExecutionStatus.SUCCESS.name(), execTimeMs);
                }
                if (startSnapshot == null) break;
                Debug.addRoutingDebug(zuulCtx, "Filter {" + filter.filterName() + " TYPE:" + filter.filterType().toString() + " ORDER:" + filter.filterOrder() + "} Execution time = " + execTimeMs + "ms");
                Debug.compareContextState(filter.filterName(), zuulCtx, startSnapshot.getContext());
                break;
            }
        }
        logger.debug("Filter {} completed with status {}, UUID {}", new Object[]{filter.filterName(), status.name(), zuulMesg.getContext().getUUID()});
        this.usageNotifier.notify(filter, status);
    }

    protected void handleException(ZuulMessage zuulMesg, String filterName, Exception ex) {
        HttpRequestInfo zuulReq = null;
        if (zuulMesg instanceof HttpRequestMessage) {
            zuulReq = (HttpRequestMessage)zuulMesg;
        } else if (zuulMesg instanceof HttpResponseMessage) {
            zuulReq = ((HttpResponseMessage)zuulMesg).getInboundRequest();
        }
        String path = zuulReq != null ? zuulReq.getPathAndQuery() : "-";
        String method = zuulReq != null ? zuulReq.getMethod() : "-";
        String errMesg = "Error with filter: " + filterName + ", path: " + path + ", method: " + method;
        logger.error(errMesg, (Throwable)ex);
        BaseZuulFilterRunner.getChannelHandlerContext(zuulMesg).fireExceptionCaught((Throwable)ex);
    }

    protected abstract void resume(O var1);

    protected MethodBinding<?> methodBinding(ZuulMessage zuulMesg) {
        return MethodBinding.NO_OP_BINDING;
    }

    protected void resumeInBindingContext(O zuulMesg, String filterName) {
        try {
            this.methodBinding((ZuulMessage)zuulMesg).bind(() -> this.resume(zuulMesg));
        }
        catch (Exception ex) {
            this.handleException((ZuulMessage)zuulMesg, filterName, ex);
        }
    }

    private final class FilterChainResumer
    implements Observer<O> {
        private final I inMesg;
        private final ZuulFilter<I, O> filter;
        private final long startTime;
        private ZuulMessage snapshot;
        private AtomicBoolean concurrencyDecremented;
        private final AtomicReference<Link> onNextLinkOut = new AtomicReference();
        private final AtomicReference<Link> onErrorLinkOut = new AtomicReference();
        private final AtomicReference<Link> onCompletedLinkOut = new AtomicReference();
        final /* synthetic */ BaseZuulFilterRunner this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public FilterChainResumer(I filter, ZuulFilter<I, O> snapshot, ZuulMessage startTime, long l2) {
            void inMesg;
            this.this$0 = (BaseZuulFilterRunner)l;
            this.inMesg = (ZuulMessage)Preconditions.checkNotNull((Object)inMesg, (String)"input message");
            this.filter = (ZuulFilter)Preconditions.checkNotNull(filter, (String)"filter");
            this.snapshot = snapshot;
            this.startTime = (long)startTime;
            this.concurrencyDecremented = new AtomicBoolean(false);
        }

        void decrementConcurrency() {
            if (this.concurrencyDecremented.compareAndSet(false, true)) {
                this.filter.decrementConcurrency();
            }
        }

        public void onNext(O outMesg) {
            try (TaskCloseable ignored = PerfMark.traceTask(this.filter, f -> f.filterName() + ".onNextAsync");){
                PerfMark.linkIn((Link)this.onNextLinkOut.get());
                this.this$0.addPerfMarkTags((ZuulMessage)this.inMesg);
                this.this$0.recordFilterCompletion(ExecutionStatus.SUCCESS, this.filter, this.startTime, (ZuulMessage)this.inMesg, this.snapshot);
                if (outMesg == null) {
                    outMesg = this.filter.getDefaultOutput(this.inMesg);
                }
                this.this$0.resumeInBindingContext(outMesg, this.filter.filterName());
            }
            catch (Exception e) {
                this.decrementConcurrency();
                this.this$0.handleException((ZuulMessage)this.inMesg, this.filter.filterName(), e);
            }
        }

        public void onError(Throwable ex) {
            try (TaskCloseable ignored = PerfMark.traceTask(this.filter, f -> f.filterName() + ".onErrorAsync");){
                PerfMark.linkIn((Link)this.onErrorLinkOut.get());
                this.decrementConcurrency();
                this.this$0.recordFilterCompletion(ExecutionStatus.FAILED, this.filter, this.startTime, (ZuulMessage)this.inMesg, this.snapshot);
                Object outMesg = this.this$0.handleFilterException(this.inMesg, this.filter, ex);
                this.this$0.resumeInBindingContext(outMesg, this.filter.filterName());
            }
            catch (Exception e) {
                this.this$0.handleException((ZuulMessage)this.inMesg, this.filter.filterName(), e);
            }
        }

        public void onCompleted() {
            try (TaskCloseable ignored = PerfMark.traceTask(this.filter, f -> f.filterName() + ".onCompletedAsync");){
                PerfMark.linkIn((Link)this.onCompletedLinkOut.get());
                this.decrementConcurrency();
            }
        }

        private Action1<O> onNextStarted(Link onNextLinkIn) {
            return o -> {
                try (TaskCloseable ignored = PerfMark.traceTask(this.filter, f -> f.filterName() + ".onNext");){
                    PerfMark.linkIn((Link)onNextLinkIn);
                    this.onNextLinkOut.compareAndSet(null, PerfMark.linkOut());
                }
            };
        }

        private Action1<Throwable> onErrorStarted(Link onErrorLinkIn) {
            return t -> {
                try (TaskCloseable ignored = PerfMark.traceTask(this.filter, f -> f.filterName() + ".onError");){
                    PerfMark.linkIn((Link)onErrorLinkIn);
                    this.onErrorLinkOut.compareAndSet(null, PerfMark.linkOut());
                }
            };
        }

        private Action0 onCompletedStarted(Link onCompletedLinkIn) {
            return () -> {
                try (TaskCloseable ignored = PerfMark.traceTask(this.filter, f -> f.filterName() + ".onCompleted");){
                    PerfMark.linkIn((Link)onCompletedLinkIn);
                    this.onCompletedLinkOut.compareAndSet(null, PerfMark.linkOut());
                }
            };
        }
    }
}

