/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.connectionpool;

import com.netflix.zuul.netty.connectionpool.ConnectionPoolConfig;
import com.netflix.zuul.netty.server.Server;
import com.netflix.zuul.passport.CurrentPassport;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;

public final class NettyClientConnectionFactory {
    private final ConnectionPoolConfig connPoolConfig;
    private final ChannelInitializer<? extends Channel> channelInitializer;

    NettyClientConnectionFactory(ConnectionPoolConfig connPoolConfig, ChannelInitializer<? extends Channel> channelInitializer) {
        this.connPoolConfig = connPoolConfig;
        this.channelInitializer = channelInitializer;
    }

    public ChannelFuture connect(EventLoop eventLoop, SocketAddress socketAddress, CurrentPassport passport) {
        Objects.requireNonNull(socketAddress, "socketAddress");
        if (socketAddress instanceof InetSocketAddress) assert (!((InetSocketAddress)socketAddress).isUnresolved()) : socketAddress;
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(Server.defaultOutboundChannelType.get())).handler(this.channelInitializer)).group((EventLoopGroup)eventLoop)).attr(CurrentPassport.CHANNEL_ATTR, (Object)passport)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connPoolConfig.getConnectTimeout())).option(ChannelOption.SO_KEEPALIVE, (Object)this.connPoolConfig.getTcpKeepAlive())).option(ChannelOption.TCP_NODELAY, (Object)this.connPoolConfig.getTcpNoDelay())).option(ChannelOption.SO_SNDBUF, (Object)this.connPoolConfig.getTcpSendBufferSize())).option(ChannelOption.SO_RCVBUF, (Object)this.connPoolConfig.getTcpReceiveBufferSize())).option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)this.connPoolConfig.getNettyWriteBufferHighWaterMark())).option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)this.connPoolConfig.getNettyWriteBufferLowWaterMark())).option(ChannelOption.AUTO_READ, (Object)this.connPoolConfig.getNettyAutoRead())).remoteAddress(socketAddress);
        return bootstrap.connect();
    }
}

