/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.connectionpool;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.InetAddresses;
import com.netflix.client.config.IClientConfig;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.histogram.PercentileTimer;
import com.netflix.zuul.discovery.DiscoveryResult;
import com.netflix.zuul.discovery.DynamicServerResolver;
import com.netflix.zuul.discovery.ResolverResult;
import com.netflix.zuul.exception.OutboundErrorType;
import com.netflix.zuul.netty.SpectatorUtils;
import com.netflix.zuul.netty.connectionpool.ClientChannelManager;
import com.netflix.zuul.netty.connectionpool.ConnectionPoolConfig;
import com.netflix.zuul.netty.connectionpool.ConnectionPoolConfigImpl;
import com.netflix.zuul.netty.connectionpool.DefaultOriginChannelInitializer;
import com.netflix.zuul.netty.connectionpool.IConnectionPool;
import com.netflix.zuul.netty.connectionpool.NettyClientConnectionFactory;
import com.netflix.zuul.netty.connectionpool.OriginChannelInitializer;
import com.netflix.zuul.netty.connectionpool.OriginConnectException;
import com.netflix.zuul.netty.connectionpool.PerServerConnectionPool;
import com.netflix.zuul.netty.connectionpool.PooledConnection;
import com.netflix.zuul.netty.connectionpool.PooledConnectionFactory;
import com.netflix.zuul.netty.insights.PassportStateHttpClientHandler;
import com.netflix.zuul.origins.OriginName;
import com.netflix.zuul.passport.CurrentPassport;
import com.netflix.zuul.resolver.Resolver;
import com.netflix.zuul.resolver.ResolverListener;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientChannelManager
implements ClientChannelManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultClientChannelManager.class);
    public static final String METRIC_PREFIX = "connectionpool";
    private final Resolver<? extends DiscoveryResult> dynamicServerResolver;
    private final ConnectionPoolConfig connPoolConfig;
    private final IClientConfig clientConfig;
    private final Registry spectatorRegistry;
    private final OriginName originName;
    private static final Throwable SHUTTING_DOWN_ERR = new IllegalStateException("ConnectionPool is shutting down now.");
    private volatile boolean shuttingDown = false;
    private final Counter createNewConnCounter;
    private final Counter createConnSucceededCounter;
    private final Counter createConnFailedCounter;
    private final Counter closeConnCounter;
    private final Counter requestConnCounter;
    private final Counter reuseConnCounter;
    private final Counter releaseConnCounter;
    private final Counter alreadyClosedCounter;
    private final Counter connTakenFromPoolIsNotOpen;
    private final Counter maxConnsPerHostExceededCounter;
    private final Counter closeWrtBusyConnCounter;
    private final PercentileTimer connEstablishTimer;
    private final AtomicInteger connsInPool;
    private final AtomicInteger connsInUse;
    private final ConcurrentHashMap<DiscoveryResult, IConnectionPool> perServerPools;
    private NettyClientConnectionFactory clientConnFactory;
    private OriginChannelInitializer channelInitializer;
    public static final String IDLE_STATE_HANDLER_NAME = "idleStateHandler";

    public DefaultClientChannelManager(OriginName originName, IClientConfig clientConfig, Registry spectatorRegistry) {
        this.originName = Objects.requireNonNull(originName, "originName");
        this.dynamicServerResolver = new DynamicServerResolver(clientConfig, (ResolverListener)new ServerPoolListener());
        String metricId = originName.getMetricId();
        this.clientConfig = clientConfig;
        this.spectatorRegistry = spectatorRegistry;
        this.perServerPools = new ConcurrentHashMap(200);
        this.connPoolConfig = new ConnectionPoolConfigImpl(originName, this.clientConfig);
        this.createNewConnCounter = SpectatorUtils.newCounter("connectionpool_create", metricId);
        this.createConnSucceededCounter = SpectatorUtils.newCounter("connectionpool_create_success", metricId);
        this.createConnFailedCounter = SpectatorUtils.newCounter("connectionpool_create_fail", metricId);
        this.closeConnCounter = SpectatorUtils.newCounter("connectionpool_close", metricId);
        this.requestConnCounter = SpectatorUtils.newCounter("connectionpool_request", metricId);
        this.reuseConnCounter = SpectatorUtils.newCounter("connectionpool_reuse", metricId);
        this.releaseConnCounter = SpectatorUtils.newCounter("connectionpool_release", metricId);
        this.alreadyClosedCounter = SpectatorUtils.newCounter("connectionpool_alreadyClosed", metricId);
        this.connTakenFromPoolIsNotOpen = SpectatorUtils.newCounter("connectionpool_fromPoolIsClosed", metricId);
        this.maxConnsPerHostExceededCounter = SpectatorUtils.newCounter("connectionpool_maxConnsPerHostExceeded", metricId);
        this.closeWrtBusyConnCounter = SpectatorUtils.newCounter("connectionpool_closeWrtBusyConnCounter", metricId);
        this.connEstablishTimer = PercentileTimer.get((Registry)spectatorRegistry, (Id)spectatorRegistry.createId("connectionpool_createTiming", new String[]{"id", metricId}));
        this.connsInPool = SpectatorUtils.newGauge("connectionpool_inPool", metricId, new AtomicInteger());
        this.connsInUse = SpectatorUtils.newGauge("connectionpool_inUse", metricId, new AtomicInteger());
    }

    @VisibleForTesting
    public DefaultClientChannelManager(OriginName originName, IClientConfig clientConfig, Resolver<? extends DiscoveryResult> resolver, Registry spectatorRegistry) {
        this.originName = Objects.requireNonNull(originName, "originName");
        this.dynamicServerResolver = resolver;
        String metricId = originName.getMetricId();
        this.clientConfig = clientConfig;
        this.spectatorRegistry = spectatorRegistry;
        this.perServerPools = new ConcurrentHashMap(200);
        this.connPoolConfig = new ConnectionPoolConfigImpl(originName, this.clientConfig);
        this.createNewConnCounter = SpectatorUtils.newCounter("connectionpool_create", metricId);
        this.createConnSucceededCounter = SpectatorUtils.newCounter("connectionpool_create_success", metricId);
        this.createConnFailedCounter = SpectatorUtils.newCounter("connectionpool_create_fail", metricId);
        this.closeConnCounter = SpectatorUtils.newCounter("connectionpool_close", metricId);
        this.requestConnCounter = SpectatorUtils.newCounter("connectionpool_request", metricId);
        this.reuseConnCounter = SpectatorUtils.newCounter("connectionpool_reuse", metricId);
        this.releaseConnCounter = SpectatorUtils.newCounter("connectionpool_release", metricId);
        this.alreadyClosedCounter = SpectatorUtils.newCounter("connectionpool_alreadyClosed", metricId);
        this.connTakenFromPoolIsNotOpen = SpectatorUtils.newCounter("connectionpool_fromPoolIsClosed", metricId);
        this.maxConnsPerHostExceededCounter = SpectatorUtils.newCounter("connectionpool_maxConnsPerHostExceeded", metricId);
        this.closeWrtBusyConnCounter = SpectatorUtils.newCounter("connectionpool_closeWrtBusyConnCounter", metricId);
        this.connEstablishTimer = PercentileTimer.get((Registry)spectatorRegistry, (Id)spectatorRegistry.createId("connectionpool_createTiming", new String[]{"id", metricId}));
        this.connsInPool = SpectatorUtils.newGauge("connectionpool_inPool", metricId, new AtomicInteger());
        this.connsInUse = SpectatorUtils.newGauge("connectionpool_inUse", metricId, new AtomicInteger());
    }

    @Override
    public void init() {
        this.channelInitializer = this.createChannelInitializer(this.clientConfig, this.connPoolConfig, this.spectatorRegistry);
        this.clientConnFactory = this.createNettyClientConnectionFactory(this.connPoolConfig, this.channelInitializer);
    }

    protected OriginChannelInitializer createChannelInitializer(IClientConfig clientConfig, ConnectionPoolConfig connPoolConfig, Registry registry) {
        return new DefaultOriginChannelInitializer(connPoolConfig, registry);
    }

    protected NettyClientConnectionFactory createNettyClientConnectionFactory(ConnectionPoolConfig connPoolConfig, ChannelInitializer<? extends Channel> clientConnInitializer) {
        return new NettyClientConnectionFactory(connPoolConfig, clientConnInitializer);
    }

    @Override
    public ConnectionPoolConfig getConfig() {
        return this.connPoolConfig;
    }

    @Override
    public boolean isAvailable() {
        return this.dynamicServerResolver.hasServers();
    }

    @Override
    public boolean isCold() {
        return false;
    }

    @Override
    public int getInflightRequestsCount() {
        return this.channelInitializer.getHttpMetricsHandler().getInflightRequestsCount();
    }

    @Override
    public void shutdown() {
        this.shuttingDown = true;
        this.dynamicServerResolver.shutdown();
        for (IConnectionPool pool : this.perServerPools.values()) {
            pool.shutdown();
        }
    }

    @Override
    public boolean release(PooledConnection conn) {
        conn.stopRequestTimer();
        this.releaseConnCounter.increment();
        this.connsInUse.decrementAndGet();
        DiscoveryResult discoveryResult = conn.getServer();
        discoveryResult.decrementActiveRequestsCount();
        discoveryResult.incrementNumRequests();
        if (this.shuttingDown) {
            return false;
        }
        boolean released = false;
        if (conn.isShouldClose() || conn.getUsageCount() > (long)this.connPoolConfig.getMaxRequestsPerConnection()) {
            conn.setInPool(false);
            conn.close();
        } else if (discoveryResult.isCircuitBreakerTripped()) {
            conn.setInPool(false);
            conn.close();
        } else if (!conn.isActive()) {
            this.alreadyClosedCounter.increment();
            conn.updateServerStats();
            conn.setInPool(false);
        } else {
            this.releaseHandlers(conn);
            IConnectionPool pool = this.perServerPools.get(discoveryResult);
            if (pool != null) {
                released = pool.release(conn);
            } else {
                conn.setInPool(false);
                released = false;
                conn.close();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("PooledConnection released: " + conn.toString());
            }
        }
        return released;
    }

    protected void releaseHandlers(PooledConnection conn) {
        ChannelPipeline pipeline = conn.getChannel().pipeline();
        DefaultClientChannelManager.removeHandlerFromPipeline("_origin_response_receiver", pipeline);
        ChannelHandlerContext passportStateHttpClientHandlerCtx = pipeline.context(PassportStateHttpClientHandler.OutboundHandler.class);
        pipeline.addAfter(passportStateHttpClientHandlerCtx.name(), IDLE_STATE_HANDLER_NAME, (ChannelHandler)new IdleStateHandler(0L, 0L, (long)this.connPoolConfig.getIdleTimeout(), TimeUnit.MILLISECONDS));
    }

    public static void removeHandlerFromPipeline(String handlerName, ChannelPipeline pipeline) {
        if (pipeline.get(handlerName) != null) {
            pipeline.remove(handlerName);
        }
    }

    @Override
    public boolean remove(PooledConnection conn) {
        if (conn == null) {
            return false;
        }
        if (!conn.isInPool()) {
            return false;
        }
        IConnectionPool pool = this.perServerPools.get(conn.getServer());
        if (pool != null) {
            return pool.remove(conn);
        }
        conn.setInPool(false);
        this.connsInPool.decrementAndGet();
        return false;
    }

    @Override
    public Promise<PooledConnection> acquire(EventLoop eventLoop) {
        return this.acquire(eventLoop, null, CurrentPassport.create(), new AtomicReference<DiscoveryResult>(), new AtomicReference());
    }

    @Override
    public Promise<PooledConnection> acquire(EventLoop eventLoop, @Nullable Object key, CurrentPassport passport, AtomicReference<DiscoveryResult> selectedServer, AtomicReference<? super InetAddress> selectedHostAddr) {
        if (this.shuttingDown) {
            Promise promise = eventLoop.newPromise();
            promise.setFailure(SHUTTING_DOWN_ERR);
            return promise;
        }
        DiscoveryResult chosenServer = (DiscoveryResult)this.dynamicServerResolver.resolve(key);
        selectedServer.set(chosenServer);
        if (chosenServer == DiscoveryResult.EMPTY) {
            Promise promise = eventLoop.newPromise();
            promise.setFailure((Throwable)new OriginConnectException("No servers available", OutboundErrorType.NO_AVAILABLE_SERVERS));
            return promise;
        }
        IConnectionPool pool = this.perServerPools.computeIfAbsent(chosenServer, s -> {
            SocketAddress finalServerAddr = this.pickAddress(chosenServer);
            DefaultClientChannelManager clientChannelMgr = this;
            PooledConnectionFactory pcf = this.createPooledConnectionFactory(chosenServer, clientChannelMgr, this.closeConnCounter, this.closeWrtBusyConnCounter);
            return this.createConnectionPool(chosenServer, finalServerAddr, this.clientConnFactory, pcf, this.connPoolConfig, this.clientConfig, this.createNewConnCounter, this.createConnSucceededCounter, this.createConnFailedCounter, this.requestConnCounter, this.reuseConnCounter, this.connTakenFromPoolIsNotOpen, this.maxConnsPerHostExceededCounter, this.connEstablishTimer, this.connsInPool, this.connsInUse);
        });
        return pool.acquire(eventLoop, passport, selectedHostAddr);
    }

    protected PooledConnectionFactory createPooledConnectionFactory(DiscoveryResult chosenServer, ClientChannelManager clientChannelMgr, Counter closeConnCounter, Counter closeWrtBusyConnCounter) {
        return ch -> new PooledConnection(ch, chosenServer, clientChannelMgr, closeConnCounter, closeWrtBusyConnCounter);
    }

    protected IConnectionPool createConnectionPool(DiscoveryResult discoveryResult, SocketAddress serverAddr, NettyClientConnectionFactory clientConnFactory, PooledConnectionFactory pcf, ConnectionPoolConfig connPoolConfig, IClientConfig clientConfig, Counter createNewConnCounter, Counter createConnSucceededCounter, Counter createConnFailedCounter, Counter requestConnCounter, Counter reuseConnCounter, Counter connTakenFromPoolIsNotOpen, Counter maxConnsPerHostExceededCounter, PercentileTimer connEstablishTimer, AtomicInteger connsInPool, AtomicInteger connsInUse) {
        return new PerServerConnectionPool(discoveryResult, serverAddr, clientConnFactory, pcf, connPoolConfig, clientConfig, createNewConnCounter, createConnSucceededCounter, createConnFailedCounter, requestConnCounter, reuseConnCounter, connTakenFromPoolIsNotOpen, maxConnsPerHostExceededCounter, (Timer)connEstablishTimer, connsInPool, connsInUse);
    }

    @Override
    public int getConnsInPool() {
        return this.connsInPool.get();
    }

    @Override
    public int getConnsInUse() {
        return this.connsInUse.get();
    }

    protected ConcurrentHashMap<DiscoveryResult, IConnectionPool> getPerServerPools() {
        return this.perServerPools;
    }

    @VisibleForTesting
    static SocketAddress pickAddressInternal(ResolverResult chosenServer, @Nullable OriginName originName) {
        InetSocketAddress serverAddr;
        String rawHost = chosenServer.getHost();
        int port = chosenServer.getPort();
        try {
            InetAddress ipAddr = InetAddresses.forString((String)rawHost);
            serverAddr = new InetSocketAddress(ipAddr, port);
        }
        catch (IllegalArgumentException e1) {
            LOG.warn("NettyClientConnectionFactory got an unresolved address, addr: {}", (Object)rawHost);
            Counter unresolvedDiscoveryHost = SpectatorUtils.newCounter("unresolvedDiscoveryHost", originName == null ? "unknownOrigin" : originName.getTarget());
            unresolvedDiscoveryHost.increment();
            try {
                serverAddr = new InetSocketAddress(rawHost, port);
            }
            catch (RuntimeException e2) {
                e1.addSuppressed(e2);
                throw e1;
            }
        }
        return serverAddr;
    }

    protected SocketAddress pickAddress(DiscoveryResult chosenServer) {
        return DefaultClientChannelManager.pickAddressInternal((ResolverResult)chosenServer, this.connPoolConfig.getOriginName());
    }

    final class ServerPoolListener
    implements ResolverListener<DiscoveryResult> {
        ServerPoolListener() {
        }

        public void onChange(List<DiscoveryResult> removedSet) {
            if (!removedSet.isEmpty()) {
                LOG.debug("Removing connection pools for missing servers. name = {}. {} servers gone.", (Object)DefaultClientChannelManager.this.originName, (Object)removedSet.size());
                for (DiscoveryResult s : removedSet) {
                    IConnectionPool pool = (IConnectionPool)DefaultClientChannelManager.this.perServerPools.remove(s);
                    if (pool == null) continue;
                    pool.shutdown();
                }
            }
        }
    }
}

