/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.connectionpool;

import com.netflix.zuul.netty.connectionpool.PooledConnection;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AttributeKey;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientTimeoutHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ClientTimeoutHandler.class);
    public static final AttributeKey<Duration> ORIGIN_RESPONSE_READ_TIMEOUT = AttributeKey.newInstance((String)"originResponseReadTimeout");

    public static final class OutboundHandler
    extends ChannelOutboundHandlerAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            try {
                Duration timeout = (Duration)ctx.channel().attr(ORIGIN_RESPONSE_READ_TIMEOUT).get();
                if (timeout != null && msg instanceof LastHttpContent) {
                    promise.addListener(e -> {
                        LOG.debug("[{}] Adding read timeout handler: {}", (Object)ctx.channel().id(), (Object)timeout.toMillis());
                        PooledConnection.getFromChannel(ctx.channel()).startReadTimeoutHandler(timeout);
                    });
                }
            }
            finally {
                super.write(ctx, msg, promise);
            }
        }
    }

    public static final class InboundHandler
    extends ChannelInboundHandlerAdapter {
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            try {
                if (msg instanceof LastHttpContent) {
                    LOG.debug("[{}] Removing read timeout handler", (Object)ctx.channel().id());
                    PooledConnection.getFromChannel(ctx.channel()).removeReadTimeoutHandler();
                }
            }
            finally {
                super.channelRead(ctx, msg);
            }
        }
    }
}

