/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.connectionpool;

import com.google.common.base.Stopwatch;
import com.netflix.zuul.discovery.DiscoveryResult;
import com.netflix.zuul.exception.ErrorType;
import com.netflix.zuul.exception.OutboundErrorType;
import com.netflix.zuul.netty.connectionpool.RequestStat;
import java.util.concurrent.TimeUnit;

public class BasicRequestStat
implements RequestStat {
    private volatile boolean isFinished = false;
    private volatile Stopwatch stopwatch = Stopwatch.createStarted();

    @Override
    public RequestStat server(DiscoveryResult server) {
        return this;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public long duration() {
        long ms = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        return ms > 0L ? ms : 0L;
    }

    @Override
    public void serviceUnavailable() {
        this.failAndSetErrorCode(OutboundErrorType.SERVICE_UNAVAILABLE);
    }

    @Override
    public void generalError() {
        this.failAndSetErrorCode(OutboundErrorType.OTHER);
    }

    @Override
    public void failAndSetErrorCode(ErrorType error) {
    }

    @Override
    public void updateWithHttpStatusCode(int httpStatusCode) {
    }

    @Override
    public void finalAttempt(boolean finalAttempt) {
    }

    @Override
    public boolean finishIfNotAlready() {
        if (this.isFinished) {
            return false;
        }
        this.stopwatch.stop();
        this.publishMetrics();
        this.isFinished = true;
        return true;
    }

    protected void publishMetrics() {
    }
}

