/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.monitoring;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.histogram.PercentileTimer;
import com.netflix.zuul.Attrs;
import com.netflix.zuul.netty.server.Server;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class ConnTimer {
    private static final DynamicBooleanProperty PRECISE_TIMING = new DynamicBooleanProperty("zuul.conn.precise_timing", false);
    private static final AttributeKey<ConnTimer> CONN_TIMER = AttributeKey.newInstance((String)"zuul.conntimer");
    private static final Duration MIN_CONN_TIMING = Duration.ofNanos(1024L);
    private static final Duration MAX_CONN_TIMING = Duration.ofDays(366L);
    private static final Attrs EMPTY = Attrs.newInstance();
    private final Registry registry;
    private final Channel chan;
    private final Id metricBase;
    @Nullable
    private final Id preciseMetricBase;
    private final Map<String, Long> timings = new LinkedHashMap<String, Long>();

    private ConnTimer(Registry registry, Channel chan, Id metricBase) {
        this.registry = Objects.requireNonNull(registry);
        this.chan = Objects.requireNonNull(chan);
        this.metricBase = Objects.requireNonNull(metricBase);
        this.preciseMetricBase = PRECISE_TIMING.get() ? registry.createId(metricBase.name() + ".pct").withTags(metricBase.tags()) : null;
    }

    public static ConnTimer install(Channel chan, Registry registry, Id metricBase) {
        ConnTimer timer = new ConnTimer(registry, chan, metricBase);
        if (!chan.attr(CONN_TIMER).compareAndSet(null, (Object)timer)) {
            throw new IllegalStateException("pre-existing timer already present");
        }
        return timer;
    }

    public static ConnTimer from(Channel chan) {
        Objects.requireNonNull(chan);
        ConnTimer timer = (ConnTimer)chan.attr(CONN_TIMER).get();
        if (timer != null) {
            return timer;
        }
        if (chan.parent() != null && (timer = (ConnTimer)chan.parent().attr(CONN_TIMER).get()) != null) {
            return timer;
        }
        throw new IllegalStateException("no timer on channel");
    }

    public void record(Long now, String event) {
        this.record(now, event, EMPTY);
    }

    public void record(Long now, String event, Attrs extraDimensions) {
        if (this.timings.containsKey(event)) {
            return;
        }
        Objects.requireNonNull(now);
        Objects.requireNonNull(event);
        Objects.requireNonNull(extraDimensions);
        Attrs connDims = (Attrs)this.chan.attr(Server.CONN_DIMENSIONS).get();
        HashMap dimTags = new HashMap(connDims.size() + extraDimensions.size());
        connDims.forEach((k, v) -> dimTags.put(k.name(), String.valueOf(v)));
        extraDimensions.forEach((k, v) -> dimTags.put(k.name(), String.valueOf(v)));
        this.timings.forEach((from, stamp) -> {
            long durationNanos = now - stamp;
            if (durationNanos == 0L) {
                return;
            }
            this.registry.timer(this.buildId(this.metricBase, (String)from, event, dimTags)).record(durationNanos, TimeUnit.NANOSECONDS);
            if (this.preciseMetricBase != null) {
                ((PercentileTimer.Builder)PercentileTimer.builder((Registry)this.registry).withId(this.buildId(this.preciseMetricBase, (String)from, event, dimTags))).withRange(MIN_CONN_TIMING, MAX_CONN_TIMING).build().record(durationNanos, TimeUnit.NANOSECONDS);
            }
        });
        this.timings.put(event, now);
    }

    private Id buildId(Id base, String from, String to, Map<String, String> tags) {
        return this.registry.createId(this.metricBase.name() + '.' + from + '-' + to).withTags(base.tags()).withTags(tags);
    }
}

