/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.monitoring;

import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.zuul.Attrs;
import com.netflix.zuul.netty.server.Server;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnCounter {
    private static final Logger logger = LoggerFactory.getLogger(ConnCounter.class);
    private static final AttributeKey<ConnCounter> CONN_COUNTER = AttributeKey.newInstance((String)"zuul.conncounter");
    private static final int LOCK_COUNT = 256;
    private static final int LOCK_MASK = 255;
    private static final Attrs EMPTY = Attrs.newInstance();
    private static final Object[] locks = new Object[256];
    private final Registry registry;
    private final Channel chan;
    private final Id metricBase;
    private String lastCountKey;
    private final Map<String, Gauge> counts = new HashMap<String, Gauge>();

    private ConnCounter(Registry registry, Channel chan, Id metricBase) {
        this.registry = Objects.requireNonNull(registry);
        this.chan = Objects.requireNonNull(chan);
        this.metricBase = Objects.requireNonNull(metricBase);
    }

    public static ConnCounter install(Channel chan, Registry registry, Id metricBase) {
        ConnCounter counter = new ConnCounter(registry, chan, metricBase);
        if (!chan.attr(CONN_COUNTER).compareAndSet(null, (Object)counter)) {
            throw new IllegalStateException("pre-existing counter already present");
        }
        return counter;
    }

    public static ConnCounter from(Channel chan) {
        Objects.requireNonNull(chan);
        ConnCounter counter = (ConnCounter)chan.attr(CONN_COUNTER).get();
        if (counter != null) {
            return counter;
        }
        if (chan.parent() != null && (counter = (ConnCounter)chan.parent().attr(CONN_COUNTER).get()) != null) {
            return counter;
        }
        throw new IllegalStateException("no counter on channel");
    }

    public void increment(String event) {
        this.increment(event, EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(String event, Attrs extraDimensions) {
        Objects.requireNonNull(event);
        Objects.requireNonNull(extraDimensions);
        if (this.counts.containsKey(event)) {
            logger.warn("Duplicate conn counter increment {}", (Object)event);
            return;
        }
        Attrs connDims = (Attrs)this.chan.attr(Server.CONN_DIMENSIONS).get();
        HashMap<String, String> dimTags = new HashMap<String, String>(connDims.size() + extraDimensions.size());
        connDims.forEach((k, v) -> dimTags.put(k.name(), String.valueOf(v)));
        extraDimensions.forEach((k, v) -> dimTags.put(k.name(), String.valueOf(v)));
        dimTags.put("from", this.lastCountKey != null ? this.lastCountKey : "nascent");
        this.lastCountKey = event;
        Id id = this.registry.createId(this.metricBase.name() + '.' + event).withTags(this.metricBase.tags()).withTags(dimTags);
        Gauge gauge = this.registry.gauge(id);
        Object object = ConnCounter.getLock(id);
        synchronized (object) {
            double current = gauge.value();
            gauge.set(Double.isNaN(current) ? 1.0 : current + 1.0);
        }
        this.counts.put(event, gauge);
    }

    public double getCurrentActiveConns() {
        return this.counts.containsKey("active") ? this.counts.get("active").value() : 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement(String event) {
        Objects.requireNonNull(event);
        Gauge gauge = this.counts.remove(event);
        if (gauge == null) {
            logger.warn("Missing conn counter increment {}", (Object)event);
            return;
        }
        Object object = ConnCounter.getLock(gauge.id());
        synchronized (object) {
            assert (!Double.isNaN(gauge.value()) || gauge.getClass().getName().equals("com.netflix.spectator.api.NoopGauge"));
            gauge.set(gauge.value() - 1.0);
        }
    }

    private static Object getLock(Id id) {
        return locks[id.hashCode() & 0xFF];
    }

    static {
        for (int i = 0; i < locks.length; ++i) {
            ConnCounter.locks[i] = new Object();
        }
    }
}

