/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.message.http;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.config.CachedDynamicBooleanProperty;
import com.netflix.config.CachedDynamicIntProperty;
import com.netflix.config.DynamicStringProperty;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.filters.ZuulFilter;
import com.netflix.zuul.message.Headers;
import com.netflix.zuul.message.ZuulMessage;
import com.netflix.zuul.message.ZuulMessageImpl;
import com.netflix.zuul.message.http.Cookies;
import com.netflix.zuul.message.http.HttpHeaderNames;
import com.netflix.zuul.message.http.HttpQueryParams;
import com.netflix.zuul.message.http.HttpRequestInfo;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.util.HttpUtils;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.HttpContent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestMessageImpl
implements HttpRequestMessage {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestMessageImpl.class);
    private static final CachedDynamicIntProperty MAX_BODY_SIZE_PROP = new CachedDynamicIntProperty("zuul.HttpRequestMessage.body.max.size", 15360000);
    private static final CachedDynamicBooleanProperty CLEAN_COOKIES = new CachedDynamicBooleanProperty("zuul.HttpRequestMessage.cookies.clean", false);
    private static final DynamicStringProperty REGEX_PTNS_TO_STRIP_PROP = new DynamicStringProperty("zuul.request.cookie.cleaner.strip", " Secure,");
    private static final List<Pattern> RE_STRIP = new ArrayList<Pattern>();
    private static final String URI_SCHEME_SEP = "://";
    private static final String URI_SCHEME_HTTP = "http";
    private static final String URI_SCHEME_HTTPS = "https";
    private final boolean immutable;
    private ZuulMessage message;
    private String protocol;
    private String method;
    private String path;
    private String decodedPath;
    private HttpQueryParams queryParams;
    private String clientIp;
    private String scheme;
    private int port;
    private String serverName;
    private SocketAddress clientRemoteAddress;
    private HttpRequestInfo inboundRequest = null;
    private Cookies parsedCookies = null;
    private String reconstructedUri = null;
    private String pathAndQuery = null;
    private String infoForLogging = null;
    private static final SocketAddress UNDEFINED_CLIENT_DEST_ADDRESS;

    public HttpRequestMessageImpl(SessionContext context, String protocol, String method, String path, HttpQueryParams queryParams, Headers headers, String clientIp, String scheme, int port, String serverName) {
        this(context, protocol, method, path, queryParams, headers, clientIp, scheme, port, serverName, UNDEFINED_CLIENT_DEST_ADDRESS, false);
    }

    public HttpRequestMessageImpl(SessionContext context, String protocol, String method, String path, HttpQueryParams queryParams, Headers headers, String clientIp, String scheme, int port, String serverName, SocketAddress clientRemoteAddress, boolean immutable) {
        this.immutable = immutable;
        this.message = new ZuulMessageImpl(context, headers);
        this.protocol = protocol;
        this.method = method;
        this.path = path;
        try {
            this.decodedPath = URLDecoder.decode(path, "UTF-8");
        }
        catch (Exception e) {
            this.decodedPath = path;
        }
        this.queryParams = queryParams == null ? new HttpQueryParams() : queryParams;
        this.clientIp = clientIp;
        this.scheme = scheme;
        this.port = port;
        this.serverName = serverName;
        this.clientRemoteAddress = clientRemoteAddress;
    }

    private void immutableCheck() {
        if (this.immutable) {
            throw new IllegalStateException("This HttpRequestMessageImpl is immutable. No mutating operations allowed!");
        }
    }

    @Override
    public SessionContext getContext() {
        return this.message.getContext();
    }

    @Override
    public Headers getHeaders() {
        return this.message.getHeaders();
    }

    @Override
    public void setHeaders(Headers newHeaders) {
        this.immutableCheck();
        this.message.setHeaders(newHeaders);
    }

    @Override
    public void setHasBody(boolean hasBody) {
        this.message.setHasBody(hasBody);
    }

    @Override
    public boolean hasBody() {
        return this.message.hasBody();
    }

    @Override
    public void bufferBodyContents(HttpContent chunk) {
        this.message.bufferBodyContents(chunk);
    }

    @Override
    public void setBodyAsText(String bodyText) {
        this.message.setBodyAsText(bodyText);
    }

    @Override
    public void setBody(byte[] body) {
        this.message.setBody(body);
    }

    @Override
    public boolean finishBufferedBodyIfIncomplete() {
        return this.message.finishBufferedBodyIfIncomplete();
    }

    @Override
    public Iterable<HttpContent> getBodyContents() {
        return this.message.getBodyContents();
    }

    public void runBufferedBodyContentThroughFilter(ZuulFilter filter) {
        this.message.runBufferedBodyContentThroughFilter(filter);
    }

    @Override
    public String getBodyAsText() {
        return this.message.getBodyAsText();
    }

    @Override
    public byte[] getBody() {
        return this.message.getBody();
    }

    @Override
    public int getBodyLength() {
        return this.message.getBodyLength();
    }

    @Override
    public boolean hasCompleteBody() {
        return this.message.hasCompleteBody();
    }

    @Override
    public void disposeBufferedBody() {
        this.message.disposeBufferedBody();
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(String protocol) {
        this.immutableCheck();
        this.protocol = protocol;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(String method) {
        this.immutableCheck();
        this.method = method;
    }

    @Override
    public String getPath() {
        if (this.message.getContext().containsKey("zuul_use_decoded_uri")) {
            return this.decodedPath;
        }
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.immutableCheck();
        this.path = path;
        this.decodedPath = path;
    }

    @Override
    public HttpQueryParams getQueryParams() {
        return this.queryParams;
    }

    @Override
    public String getPathAndQuery() {
        if (this.immutable) {
            if (this.pathAndQuery == null) {
                this.pathAndQuery = this.generatePathAndQuery();
            }
            return this.pathAndQuery;
        }
        return this.generatePathAndQuery();
    }

    protected String generatePathAndQuery() {
        if (this.queryParams != null && this.queryParams.entries().size() > 0) {
            return this.getPath() + "?" + this.queryParams.toEncodedString();
        }
        return this.getPath();
    }

    @Override
    public String getClientIp() {
        return this.clientIp;
    }

    @Deprecated
    @VisibleForTesting
    void setClientIp(String clientIp) {
        this.immutableCheck();
        this.clientIp = clientIp;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public void setScheme(String scheme) {
        this.immutableCheck();
        this.scheme = scheme;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Deprecated
    @VisibleForTesting
    void setPort(int port) {
        this.immutableCheck();
        this.port = port;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public void setServerName(String serverName) {
        this.immutableCheck();
        this.serverName = serverName;
    }

    @Override
    public Cookies parseCookies() {
        if (this.parsedCookies == null) {
            this.parsedCookies = this.reParseCookies();
        }
        return this.parsedCookies;
    }

    @Override
    public Cookies reParseCookies() {
        Cookies cookies = new Cookies();
        for (String aCookieHeader : this.getHeaders().getAll(HttpHeaderNames.COOKIE)) {
            try {
                if (CLEAN_COOKIES.get()) {
                    aCookieHeader = HttpRequestMessageImpl.cleanCookieHeader(aCookieHeader);
                }
                Set decoded = CookieDecoder.decode((String)aCookieHeader, (boolean)false);
                for (Cookie cookie : decoded) {
                    cookies.add(cookie);
                }
            }
            catch (Exception e) {
                LOG.error(String.format("Error parsing request Cookie header. cookie=%s, request-info=%s", aCookieHeader, this.getInfoForLogging()));
            }
        }
        this.parsedCookies = cookies;
        return cookies;
    }

    @VisibleForTesting
    static String cleanCookieHeader(String cookie) {
        for (Pattern stripPtn : RE_STRIP) {
            Matcher matcher = stripPtn.matcher(cookie);
            if (!matcher.find()) continue;
            cookie = matcher.replaceAll("");
        }
        return cookie;
    }

    @Override
    public int getMaxBodySize() {
        return MAX_BODY_SIZE_PROP.get();
    }

    @Override
    public ZuulMessage clone() {
        HttpRequestMessageImpl clone = new HttpRequestMessageImpl(this.message.getContext().clone(), this.protocol, this.method, this.path, this.queryParams.clone(), Headers.copyOf(this.message.getHeaders()), this.clientIp, this.scheme, this.port, this.serverName, this.clientRemoteAddress, this.immutable);
        if (this.getInboundRequest() != null) {
            clone.inboundRequest = (HttpRequestInfo)this.getInboundRequest().clone();
        }
        return clone;
    }

    protected HttpRequestInfo copyRequestInfo() {
        HttpRequestMessageImpl req = new HttpRequestMessageImpl(this.message.getContext(), this.protocol, this.method, this.path, this.queryParams.immutableCopy(), Headers.copyOf(this.message.getHeaders()), this.clientIp, this.scheme, this.port, this.serverName, this.clientRemoteAddress, true);
        req.setHasBody(this.hasBody());
        return req;
    }

    @Override
    public void storeInboundRequest() {
        this.inboundRequest = this.copyRequestInfo();
    }

    @Override
    public HttpRequestInfo getInboundRequest() {
        return this.inboundRequest;
    }

    @Override
    public void setQueryParams(HttpQueryParams queryParams) {
        this.immutableCheck();
        this.queryParams = queryParams;
    }

    @Override
    public String getInfoForLogging() {
        if (this.immutable) {
            if (this.infoForLogging == null) {
                this.infoForLogging = this.generateInfoForLogging();
            }
            return this.infoForLogging;
        }
        return this.generateInfoForLogging();
    }

    protected String generateInfoForLogging() {
        HttpRequestInfo req = this.getInboundRequest() == null ? this : this.getInboundRequest();
        StringBuilder sb = new StringBuilder().append("uri=").append(req.reconstructURI()).append(", method=").append(req.getMethod()).append(", clientip=").append(HttpUtils.getClientIP(req));
        return sb.toString();
    }

    @Override
    public String getOriginalHost() {
        try {
            return HttpRequestMessageImpl.getOriginalHost(this.getHeaders(), this.getServerName());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @VisibleForTesting
    static String getOriginalHost(Headers headers, String serverName) throws URISyntaxException {
        String xForwardedHost = headers.getFirst(HttpHeaderNames.X_FORWARDED_HOST);
        if (xForwardedHost != null) {
            return xForwardedHost;
        }
        String host = headers.getFirst(HttpHeaderNames.HOST);
        if (host != null) {
            URI uri = new URI(null, host, null, null, null);
            if (uri.getHost() == null) {
                throw new URISyntaxException(host, "Bad host name");
            }
            return uri.getHost();
        }
        return serverName;
    }

    @Override
    public String getOriginalScheme() {
        String scheme = this.getHeaders().getFirst(HttpHeaderNames.X_FORWARDED_PROTO);
        if (scheme == null) {
            scheme = this.getScheme();
        }
        return scheme;
    }

    @Override
    public String getOriginalProtocol() {
        String proto = this.getHeaders().getFirst(HttpHeaderNames.X_FORWARDED_PROTO_VERSION);
        if (proto == null) {
            proto = this.getProtocol();
        }
        return proto;
    }

    @Override
    public int getOriginalPort() {
        try {
            return HttpRequestMessageImpl.getOriginalPort(this.getContext(), this.getHeaders(), this.getPort());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @VisibleForTesting
    static int getOriginalPort(SessionContext context, Headers headers, int serverPort) throws URISyntaxException {
        URI uri;
        if (context.containsKey("proxy_protocol_destination_address")) {
            return ((InetSocketAddress)context.get("proxy_protocol_destination_address")).getPort();
        }
        String portStr = headers.getFirst(HttpHeaderNames.X_FORWARDED_PORT);
        if (portStr != null && !portStr.isEmpty()) {
            return Integer.parseInt(portStr);
        }
        String host = headers.getFirst(HttpHeaderNames.HOST);
        if (host != null && (uri = new URI(null, host, null, null, null)).getPort() != -1) {
            return uri.getPort();
        }
        return serverPort;
    }

    @Override
    public Optional<Integer> getClientDestinationPort() {
        if (this.clientRemoteAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)this.clientRemoteAddress;
            return Optional.of(inetSocketAddress.getPort());
        }
        return Optional.empty();
    }

    @Override
    public String reconstructURI() {
        if (this.immutable) {
            if (this.reconstructedUri == null) {
                this.reconstructedUri = this._reconstructURI();
            }
            return this.reconstructedUri;
        }
        return this._reconstructURI();
    }

    protected String _reconstructURI() {
        try {
            StringBuilder uri = new StringBuilder(100);
            String scheme = this.getOriginalScheme().toLowerCase();
            uri.append(scheme);
            uri.append(URI_SCHEME_SEP).append(HttpRequestMessageImpl.getOriginalHost(this.getHeaders(), this.getServerName()));
            int port = this.getOriginalPort();
            if (!(URI_SCHEME_HTTP.equals(scheme) && 80 == port || URI_SCHEME_HTTPS.equals(scheme) && 443 == port)) {
                uri.append(':').append(port);
            }
            uri.append(this.getPathAndQuery());
            return uri.toString();
        }
        catch (URISyntaxException e) {
            LOG.debug("Error reconstructing request URI!", (Throwable)e);
            return "";
        }
        catch (Exception e) {
            LOG.error("Error reconstructing request URI!", (Throwable)e);
            return "";
        }
    }

    public String toString() {
        return "HttpRequestMessageImpl{immutable=" + this.immutable + ", message=" + this.message + ", protocol='" + this.protocol + '\'' + ", method='" + this.method + '\'' + ", path='" + this.path + '\'' + ", queryParams=" + this.queryParams + ", clientIp='" + this.clientIp + '\'' + ", scheme='" + this.scheme + '\'' + ", port=" + this.port + ", serverName='" + this.serverName + '\'' + ", inboundRequest=" + this.inboundRequest + ", parsedCookies=" + this.parsedCookies + ", reconstructedUri='" + this.reconstructedUri + '\'' + ", pathAndQuery='" + this.pathAndQuery + '\'' + ", infoForLogging='" + this.infoForLogging + '\'' + '}';
    }

    static {
        for (String ptn : REGEX_PTNS_TO_STRIP_PROP.get().split(":::")) {
            RE_STRIP.add(Pattern.compile(ptn));
        }
        UNDEFINED_CLIENT_DEST_ADDRESS = new SocketAddress(){

            public String toString() {
                return "Undefined destination address.";
            }
        };
    }
}

