/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.message.http;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class HttpQueryParams
implements Cloneable {
    private final ListMultimap<String, String> delegate;
    private final boolean immutable;
    private final HashMap<String, Boolean> trailingEquals;

    public HttpQueryParams() {
        this.delegate = ArrayListMultimap.create();
        this.immutable = false;
        this.trailingEquals = new HashMap();
    }

    private HttpQueryParams(ListMultimap<String, String> delegate) {
        this.delegate = delegate;
        this.immutable = ImmutableListMultimap.class.isAssignableFrom(delegate.getClass());
        this.trailingEquals = new HashMap();
    }

    public static HttpQueryParams parse(String queryString) {
        HttpQueryParams queryParams = new HttpQueryParams();
        if (queryString == null) {
            return queryParams;
        }
        StringTokenizer st = new StringTokenizer(queryString, "&");
        while (st.hasMoreTokens()) {
            String name;
            String s = st.nextToken();
            int i = s.indexOf("=");
            if (i > 0) {
                name = s.substring(0, i);
                String value = s.substring(i + 1);
                try {
                    name = URLDecoder.decode(name, "UTF-8");
                    value = URLDecoder.decode(value, "UTF-8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                queryParams.add(name, value);
                if (!s.endsWith("=") || !value.isEmpty()) continue;
                queryParams.setTrailingEquals(name, true);
                continue;
            }
            if (s.length() <= 0) continue;
            name = s;
            try {
                name = URLDecoder.decode(name, "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
            queryParams.add(name, "");
        }
        return queryParams;
    }

    public String getFirst(String name) {
        List values = this.delegate.get((Object)name);
        if (values != null && values.size() > 0) {
            return (String)values.get(0);
        }
        return null;
    }

    public List<String> get(String name) {
        return this.delegate.get((Object)name.toLowerCase());
    }

    public boolean contains(String name) {
        return this.delegate.containsKey((Object)name);
    }

    public boolean containsIgnoreCase(String name) {
        return this.delegate.containsKey((Object)name) || this.delegate.containsKey((Object)name.toLowerCase(Locale.ROOT));
    }

    public boolean contains(String name, String value) {
        return this.delegate.containsEntry((Object)name, (Object)value);
    }

    public void set(String name, String value) {
        this.delegate.removeAll((Object)name);
        this.delegate.put((Object)name, (Object)value);
    }

    public void add(String name, String value) {
        this.delegate.put((Object)name, (Object)value);
    }

    public void removeAll(String name) {
        this.delegate.removeAll((Object)name);
    }

    public void clear() {
        this.delegate.clear();
    }

    public Collection<Map.Entry<String, String>> entries() {
        return this.delegate.entries();
    }

    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    public String toEncodedString() {
        StringBuilder sb = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : this.entries()) {
                sb.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                if (!Strings.isNullOrEmpty((String)entry.getValue())) {
                    sb.append('=');
                    sb.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                } else if (this.isTrailingEquals(entry.getKey())) {
                    sb.append('=');
                }
                sb.append('&');
            }
            if (sb.length() > 0 && '&' == sb.charAt(sb.length() - 1)) {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.entries()) {
            sb.append(entry.getKey());
            if (!Strings.isNullOrEmpty((String)entry.getValue())) {
                sb.append('=');
                sb.append(entry.getValue());
            }
            sb.append('&');
        }
        if (sb.length() > 0 && '&' == sb.charAt(sb.length() - 1)) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    protected HttpQueryParams clone() {
        HttpQueryParams copy = new HttpQueryParams();
        copy.delegate.putAll(this.delegate);
        return copy;
    }

    public HttpQueryParams immutableCopy() {
        return new HttpQueryParams((ListMultimap<String, String>)ImmutableListMultimap.copyOf(this.delegate));
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public boolean isTrailingEquals(String key) {
        return this.trailingEquals.getOrDefault(key, false);
    }

    public void setTrailingEquals(String key, boolean trailingEquals) {
        this.trailingEquals.put(key, trailingEquals);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpQueryParams)) {
            return false;
        }
        HttpQueryParams hqp2 = (HttpQueryParams)obj;
        return Iterables.elementsEqual((Iterable)this.delegate.entries(), (Iterable)hqp2.delegate.entries());
    }
}

