/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.message;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.filters.ZuulFilter;
import com.netflix.zuul.message.Headers;
import com.netflix.zuul.message.ZuulMessage;
import com.netflix.zuul.message.http.HttpHeaderNames;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ZuulMessageImpl
implements ZuulMessage {
    protected static final DynamicIntProperty MAX_BODY_SIZE_PROP = DynamicPropertyFactory.getInstance().getIntProperty("zuul.message.body.max.size", 25600000);
    private static final Charset CS_UTF8 = Charset.forName("UTF-8");
    protected final SessionContext context;
    protected Headers headers;
    private boolean hasBody;
    private boolean bodyBufferedCompletely;
    private List<HttpContent> bodyChunks;

    public ZuulMessageImpl(SessionContext context) {
        this(context, new Headers());
    }

    public ZuulMessageImpl(SessionContext context, Headers headers) {
        this.context = context == null ? new SessionContext() : context;
        this.headers = headers == null ? new Headers() : headers;
        this.bodyChunks = new ArrayList<HttpContent>(16);
    }

    @Override
    public SessionContext getContext() {
        return this.context;
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(Headers newHeaders) {
        this.headers = newHeaders;
    }

    @Override
    public int getMaxBodySize() {
        return MAX_BODY_SIZE_PROP.get();
    }

    @Override
    public void setHasBody(boolean hasBody) {
        this.hasBody = hasBody;
    }

    @Override
    public boolean hasBody() {
        return this.hasBody;
    }

    @Override
    public boolean hasCompleteBody() {
        return this.bodyBufferedCompletely;
    }

    @Override
    public void bufferBodyContents(HttpContent chunk) {
        this.setHasBody(true);
        this.bodyChunks.add(chunk);
        if (chunk instanceof LastHttpContent) {
            this.bodyBufferedCompletely = true;
        }
    }

    private void setContentLength(int length) {
        this.headers.remove(HttpHeaderNames.TRANSFER_ENCODING);
        this.headers.set(HttpHeaderNames.CONTENT_LENGTH, Integer.toString(length));
    }

    @Override
    public void setBodyAsText(String bodyText) {
        this.disposeBufferedBody();
        if (!Strings.isNullOrEmpty((String)bodyText)) {
            ByteBuf content = Unpooled.copiedBuffer((byte[])bodyText.getBytes(Charsets.UTF_8));
            this.bufferBodyContents((HttpContent)new DefaultLastHttpContent(content));
            this.setContentLength(bodyText.getBytes(CS_UTF8).length);
        } else {
            this.bufferBodyContents((HttpContent)new DefaultLastHttpContent());
            this.setContentLength(0);
        }
    }

    @Override
    public void setBody(byte[] body) {
        this.disposeBufferedBody();
        if (body != null && body.length > 0) {
            ByteBuf content = Unpooled.copiedBuffer((byte[])body);
            this.bufferBodyContents((HttpContent)new DefaultLastHttpContent(content));
            this.setContentLength(body.length);
        } else {
            this.bufferBodyContents((HttpContent)new DefaultLastHttpContent());
            this.setContentLength(0);
        }
    }

    @Override
    public String getBodyAsText() {
        byte[] body = this.getBody();
        return body != null && body.length > 0 ? new String(this.getBody(), Charsets.UTF_8) : null;
    }

    @Override
    public byte[] getBody() {
        if (this.bodyChunks.size() == 0) {
            return null;
        }
        int size = 0;
        for (HttpContent chunk : this.bodyChunks) {
            size += chunk.content().readableBytes();
        }
        byte[] body = new byte[size];
        int offset = 0;
        for (HttpContent chunk : this.bodyChunks) {
            ByteBuf content = chunk.content();
            int len = content.readableBytes();
            content.getBytes(content.readerIndex(), body, offset, len);
            offset += len;
        }
        return body;
    }

    @Override
    public int getBodyLength() {
        int size = 0;
        for (HttpContent chunk : this.bodyChunks) {
            size += chunk.content().readableBytes();
        }
        return size;
    }

    @Override
    public Iterable<HttpContent> getBodyContents() {
        return Collections.unmodifiableList(this.bodyChunks);
    }

    @Override
    public boolean finishBufferedBodyIfIncomplete() {
        if (!this.bodyBufferedCompletely) {
            this.bufferBodyContents((HttpContent)new DefaultLastHttpContent());
            return true;
        }
        return false;
    }

    @Override
    public void disposeBufferedBody() {
        this.bodyChunks.forEach(chunk -> {
            if (chunk != null && chunk.refCnt() > 0) {
                chunk.release();
            }
        });
        this.bodyChunks.clear();
    }

    @Override
    public void runBufferedBodyContentThroughFilter(ZuulFilter<?, ?> filter) {
        for (int i = 0; i < this.bodyChunks.size(); ++i) {
            HttpContent origChunk = this.bodyChunks.get(i);
            HttpContent filteredChunk = filter.processContentChunk(this, origChunk);
            if (filteredChunk == null || filteredChunk == origChunk) continue;
            this.bodyChunks.set(i, filteredChunk);
            int refCnt = origChunk.refCnt();
            if (refCnt <= 0) continue;
            origChunk.release(refCnt);
        }
    }

    @Override
    public ZuulMessage clone() {
        ZuulMessageImpl copy = new ZuulMessageImpl(this.context.clone(), Headers.copyOf(this.headers));
        this.bodyChunks.forEach(chunk -> {
            chunk.retain();
            copy.bufferBodyContents((HttpContent)chunk);
        });
        return copy;
    }

    @Override
    public String getInfoForLogging() {
        return "ZuulMessage";
    }
}

