/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.message;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Spectator;
import com.netflix.zuul.exception.ZuulException;
import com.netflix.zuul.message.Header;
import com.netflix.zuul.message.HeaderName;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class Headers {
    private static final int ABSENT = -1;
    private final List<String> originalNames;
    private final List<String> names;
    private final List<String> values;
    private static final Counter invalidHeaderCounter = Spectator.globalRegistry().counter("zuul.header.invalid.char");

    public static Headers copyOf(Headers original) {
        return new Headers(Objects.requireNonNull(original, "original"));
    }

    public Headers() {
        this.originalNames = new ArrayList<String>();
        this.names = new ArrayList<String>();
        this.values = new ArrayList<String>();
    }

    private Headers(Headers original) {
        this.originalNames = new ArrayList<String>(original.originalNames);
        this.names = new ArrayList<String>(original.names);
        this.values = new ArrayList<String>(original.values);
    }

    @Nullable
    public String getFirst(String headerName) {
        String normalName = HeaderName.normalize(Objects.requireNonNull(headerName, "headerName"));
        return this.getFirstNormal(normalName);
    }

    @Nullable
    public String getFirst(HeaderName headerName) {
        String normalName = Objects.requireNonNull(headerName, "headerName").getNormalised();
        return this.getFirstNormal(normalName);
    }

    @Nullable
    private String getFirstNormal(String name) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.name(i).equals(name)) continue;
            return this.value(i);
        }
        return null;
    }

    public String getFirst(String headerName, String defaultValue) {
        Objects.requireNonNull(defaultValue, "defaultValue");
        String value = this.getFirst(headerName);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public String getFirst(HeaderName headerName, String defaultValue) {
        Objects.requireNonNull(defaultValue, "defaultValue");
        String value = this.getFirst(headerName);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public List<String> getAll(String headerName) {
        String normalName = HeaderName.normalize(Objects.requireNonNull(headerName, "headerName"));
        return this.getAllNormal(normalName);
    }

    public List<String> getAll(HeaderName headerName) {
        String normalName = Objects.requireNonNull(headerName, "headerName").getNormalised();
        return this.getAllNormal(normalName);
    }

    private List<String> getAllNormal(String normalName) {
        ArrayList<String> results = null;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.name(i).equals(normalName)) continue;
            if (results == null) {
                results = new ArrayList<String>(1);
            }
            results.add(this.value(i));
        }
        if (results == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(results);
    }

    public void forEachNormalised(BiConsumer<? super String, ? super String> entryConsumer) {
        for (int i = 0; i < this.size(); ++i) {
            entryConsumer.accept(this.name(i), this.value(i));
        }
    }

    public void set(String headerName, @Nullable String value) {
        String normalName = HeaderName.normalize(Objects.requireNonNull(headerName, "headerName"));
        this.setNormal(headerName, normalName, value);
    }

    public void set(HeaderName headerName, String value) {
        String normalName = Objects.requireNonNull(headerName, "headerName").getNormalised();
        this.setNormal(headerName.getName(), normalName, value);
    }

    public void setAndValidate(String headerName, @Nullable String value) {
        String normalName = HeaderName.normalize(Objects.requireNonNull(headerName, "headerName"));
        this.setNormal(Headers.validateField(headerName), Headers.validateField(normalName), Headers.validateField(value));
    }

    public void setIfValid(HeaderName headerName, String value) {
        Objects.requireNonNull(headerName, "headerName");
        if (Headers.isValid(headerName.getName()) && Headers.isValid(value)) {
            String normalName = headerName.getNormalised();
            this.setNormal(headerName.getName(), normalName, value);
        }
    }

    public void setIfValid(String headerName, @Nullable String value) {
        Objects.requireNonNull(headerName, "headerName");
        if (Headers.isValid(headerName) && Headers.isValid(value)) {
            String normalName = HeaderName.normalize(headerName);
            this.setNormal(headerName, normalName, value);
        }
    }

    public void setAndValidate(HeaderName headerName, String value) {
        String normalName = Objects.requireNonNull(headerName, "headerName").getNormalised();
        this.setNormal(Headers.validateField(headerName.getName()), Headers.validateField(normalName), Headers.validateField(value));
    }

    private void setNormal(String originalName, String normalName, @Nullable String value) {
        int i = this.findNormal(normalName);
        if (i == -1) {
            if (value != null) {
                this.addNormal(originalName, normalName, value);
            }
            return;
        }
        if (value != null) {
            this.value(i, value);
            this.originalName(i, originalName);
            ++i;
        }
        this.clearMatchingStartingAt(i, normalName, null);
    }

    private int findNormal(String normalName) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.name(i).equals(normalName)) continue;
            return i;
        }
        return -1;
    }

    private void clearMatchingStartingAt(int i, String normalName, @Nullable Collection<? super String> removed) {
        int w = i;
        for (int r = i; r < this.size(); ++r) {
            if (!this.name(r).equals(normalName)) {
                this.originalName(w, this.originalName(r));
                this.name(w, this.name(r));
                this.value(w, this.value(r));
                ++w;
                continue;
            }
            if (removed == null) continue;
            removed.add(this.value(r));
        }
        this.truncate(w);
    }

    public boolean setIfAbsent(String headerName, String value) {
        Objects.requireNonNull(value, "value");
        String normalName = HeaderName.normalize(Objects.requireNonNull(headerName, "headerName"));
        return this.setIfAbsentNormal(headerName, normalName, value);
    }

    public boolean setIfAbsent(HeaderName headerName, String value) {
        Objects.requireNonNull(value, "value");
        String normalName = Objects.requireNonNull(headerName, "headerName").getNormalised();
        return this.setIfAbsentNormal(headerName.getName(), normalName, value);
    }

    private boolean setIfAbsentNormal(String originalName, String normalName, String value) {
        int i = this.findNormal(normalName);
        if (i != -1) {
            return false;
        }
        this.addNormal(originalName, normalName, value);
        return true;
    }

    public boolean setIfAbsentAndValid(String headerName, String value) {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(headerName, "headerName");
        if (Headers.isValid(headerName) && Headers.isValid(value)) {
            String normalName = HeaderName.normalize(headerName);
            return this.setIfAbsentNormal(headerName, normalName, value);
        }
        return false;
    }

    public boolean setIfAbsentAndValid(HeaderName headerName, String value) {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(headerName, "headerName");
        if (Headers.isValid(headerName.getName()) && Headers.isValid(value)) {
            String normalName = headerName.getNormalised();
            return this.setIfAbsentNormal(headerName.getName(), normalName, value);
        }
        return false;
    }

    public void add(String headerName, String value) {
        String normalName = HeaderName.normalize(Objects.requireNonNull(headerName, "headerName"));
        Objects.requireNonNull(value, "value");
        this.addNormal(headerName, normalName, value);
    }

    public void add(HeaderName headerName, String value) {
        String normalName = Objects.requireNonNull(headerName, "headerName").getNormalised();
        Objects.requireNonNull(value, "value");
        this.addNormal(headerName.getName(), normalName, value);
    }

    public void addAndValidate(String headerName, String value) {
        String normalName = HeaderName.normalize(Objects.requireNonNull(headerName, "headerName"));
        Objects.requireNonNull(value, "value");
        this.addNormal(Headers.validateField(headerName), Headers.validateField(normalName), Headers.validateField(value));
    }

    public void addAndValidate(HeaderName headerName, String value) {
        String normalName = Objects.requireNonNull(headerName, "headerName").getNormalised();
        Objects.requireNonNull(value, "value");
        this.addNormal(Headers.validateField(headerName.getName()), Headers.validateField(normalName), Headers.validateField(value));
    }

    public void addIfValid(String headerName, String value) {
        Objects.requireNonNull(headerName, "headerName");
        Objects.requireNonNull(value, "value");
        if (Headers.isValid(headerName) && Headers.isValid(value)) {
            String normalName = HeaderName.normalize(headerName);
            this.addNormal(headerName, normalName, value);
        }
    }

    public void addIfValid(HeaderName headerName, String value) {
        Objects.requireNonNull(headerName, "headerName");
        Objects.requireNonNull(value, "value");
        if (Headers.isValid(headerName.getName()) && Headers.isValid(value)) {
            String normalName = headerName.getNormalised();
            this.addNormal(headerName.getName(), normalName, value);
        }
    }

    public void putAll(Headers headers) {
        for (int i = 0; i < headers.size(); ++i) {
            this.addNormal(headers.originalName(i), headers.name(i), headers.value(i));
        }
    }

    public List<String> remove(String headerName) {
        String normalName = HeaderName.normalize(Objects.requireNonNull(headerName, "headerName"));
        return this.removeNormal(normalName);
    }

    public List<String> remove(HeaderName headerName) {
        String normalName = Objects.requireNonNull(headerName, "headerName").getNormalised();
        return this.removeNormal(normalName);
    }

    private List<String> removeNormal(String normalName) {
        ArrayList removed = new ArrayList();
        this.clearMatchingStartingAt(0, normalName, removed);
        return Collections.unmodifiableList(removed);
    }

    public boolean removeIf(Predicate<? super Map.Entry<HeaderName, String>> filter) {
        Objects.requireNonNull(filter, "filter");
        boolean removed = false;
        int w = 0;
        for (int r = 0; r < this.size(); ++r) {
            if (filter.test(new AbstractMap.SimpleImmutableEntry<HeaderName, String>(new HeaderName(this.originalName(r), this.name(r)), this.value(r)))) {
                removed = true;
                continue;
            }
            this.originalName(w, this.originalName(r));
            this.name(w, this.name(r));
            this.value(w, this.value(r));
            ++w;
        }
        this.truncate(w);
        return removed;
    }

    public Collection<Header> entries() {
        ArrayList<Header> entries = new ArrayList<Header>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            entries.add(new Header(new HeaderName(this.originalName(i), this.name(i)), this.value(i)));
        }
        return Collections.unmodifiableList(entries);
    }

    public Set<HeaderName> keySet() {
        LinkedHashSet<HeaderName> headerNames = new LinkedHashSet<HeaderName>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            HeaderName headerName = new HeaderName(this.originalName(i), this.name(i));
            if (headerNames.contains(headerName)) continue;
            headerNames.add(headerName);
        }
        return Collections.unmodifiableSet(headerNames);
    }

    public boolean contains(String headerName) {
        String normalName = HeaderName.normalize(Objects.requireNonNull(headerName, "headerName"));
        return this.findNormal(normalName) != -1;
    }

    public boolean contains(HeaderName headerName) {
        String normalName = Objects.requireNonNull(headerName, "headerName").getNormalised();
        return this.findNormal(normalName) != -1;
    }

    public boolean contains(String headerName, String value) {
        String normalName = HeaderName.normalize(Objects.requireNonNull(headerName, "headerName"));
        Objects.requireNonNull(value, "value");
        return this.containsNormal(normalName, value);
    }

    public boolean contains(HeaderName headerName, String value) {
        String normalName = Objects.requireNonNull(headerName, "headerName").getNormalised();
        Objects.requireNonNull(value, "value");
        return this.containsNormal(normalName, value);
    }

    private boolean containsNormal(String normalName, String value) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.name(i).equals(normalName) || !this.value(i).equals(value)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.names.size();
    }

    @VisibleForTesting
    public int hashCode() {
        return this.asMap().hashCode();
    }

    @VisibleForTesting
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Headers)) {
            return false;
        }
        Headers other = (Headers)obj;
        return this.asMap().equals(other.asMap());
    }

    private Map<String, List<String>> asMap() {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            map.computeIfAbsent(this.name(i), k -> new ArrayList(1)).add(this.value(i));
        }
        return map;
    }

    public String toString() {
        return this.asMap().toString();
    }

    private String originalName(int i) {
        return this.originalNames.get(i);
    }

    private void originalName(int i, String originalName) {
        this.originalNames.set(i, originalName);
    }

    private String name(int i) {
        return this.names.get(i);
    }

    private void name(int i, String name) {
        this.names.set(i, name);
    }

    private String value(int i) {
        return this.values.get(i);
    }

    private void value(int i, String val) {
        this.values.set(i, val);
    }

    private void addNormal(String originalName, String normalName, String value) {
        this.originalNames.add(originalName);
        this.names.add(normalName);
        this.values.add(value);
    }

    private void truncate(int i) {
        for (int k = this.size() - 1; k >= i; --k) {
            this.originalNames.remove(k);
            this.names.remove(k);
            this.values.remove(k);
        }
    }

    private static boolean isValid(@Nullable String value) {
        if (value == null || Headers.findInvalid(value) == -1) {
            return true;
        }
        invalidHeaderCounter.increment();
        return false;
    }

    private static String validateField(@Nullable String value) {
        int pos;
        if (value != null && (pos = Headers.findInvalid(value)) != -1) {
            invalidHeaderCounter.increment();
            throw new ZuulException("Invalid header field: char " + value.charAt(pos) + " in string " + value + " does not comply with RFC 7230");
        }
        return value;
    }

    private static int findInvalid(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= '\u001f' && c != '\u007f') continue;
            return i;
        }
        return -1;
    }
}

