/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.message;

import java.util.Locale;

public final class HeaderName {
    private final String name;
    private final String normalised;
    private final int hashCode;

    public HeaderName(String name) {
        if (name == null) {
            throw new NullPointerException("HeaderName cannot be null!");
        }
        this.name = name;
        this.normalised = HeaderName.normalize(name);
        this.hashCode = this.normalised.hashCode();
    }

    HeaderName(String name, String normalised) {
        this.name = name;
        this.normalised = normalised;
        this.hashCode = normalised.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getNormalised() {
        return this.normalised;
    }

    static String normalize(String s) {
        return s.toLowerCase(Locale.ROOT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HeaderName)) {
            return false;
        }
        HeaderName that = (HeaderName)o;
        return this.normalised.equals(that.normalised);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.name;
    }
}

