/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.message;

import com.netflix.zuul.message.HeaderName;

public final class Header {
    private final HeaderName name;
    private final String value;

    public Header(HeaderName name, String value) {
        if (name == null) {
            throw new NullPointerException("Header name cannot be null!");
        }
        this.name = name;
        this.value = value;
    }

    public String getKey() {
        return this.name.getName();
    }

    public HeaderName getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Header header = (Header)o;
        if (!this.name.equals(header.name)) {
            return false;
        }
        return !(this.value == null ? header.value != null : !this.value.equals(header.value));
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("%s: %s", this.name, this.value);
    }
}

