/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.filters.endpoint;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.ForOverride;
import com.netflix.client.ClientException;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.config.CachedDynamicLongProperty;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntegerSetProperty;
import com.netflix.spectator.api.Counter;
import com.netflix.zuul.Filter;
import com.netflix.zuul.context.Debug;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.discovery.DiscoveryResult;
import com.netflix.zuul.exception.ErrorType;
import com.netflix.zuul.exception.OutboundErrorType;
import com.netflix.zuul.exception.OutboundException;
import com.netflix.zuul.exception.ZuulException;
import com.netflix.zuul.filters.FilterType;
import com.netflix.zuul.filters.SyncZuulFilterAdapter;
import com.netflix.zuul.message.HeaderName;
import com.netflix.zuul.message.Headers;
import com.netflix.zuul.message.ZuulMessage;
import com.netflix.zuul.message.http.HttpHeaderNames;
import com.netflix.zuul.message.http.HttpQueryParams;
import com.netflix.zuul.message.http.HttpRequestInfo;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.message.http.HttpResponseMessageImpl;
import com.netflix.zuul.netty.ChannelUtils;
import com.netflix.zuul.netty.NettyRequestAttemptFactory;
import com.netflix.zuul.netty.SpectatorUtils;
import com.netflix.zuul.netty.connectionpool.BasicRequestStat;
import com.netflix.zuul.netty.connectionpool.ClientTimeoutHandler;
import com.netflix.zuul.netty.connectionpool.PooledConnection;
import com.netflix.zuul.netty.connectionpool.RequestStat;
import com.netflix.zuul.netty.filter.FilterRunner;
import com.netflix.zuul.netty.server.ClientRequestReceiver;
import com.netflix.zuul.netty.server.MethodBinding;
import com.netflix.zuul.netty.server.OriginResponseReceiver;
import com.netflix.zuul.netty.timeouts.OriginTimeoutManager;
import com.netflix.zuul.niws.RequestAttempt;
import com.netflix.zuul.niws.RequestAttempts;
import com.netflix.zuul.origins.NettyOrigin;
import com.netflix.zuul.origins.Origin;
import com.netflix.zuul.origins.OriginManager;
import com.netflix.zuul.origins.OriginName;
import com.netflix.zuul.passport.CurrentPassport;
import com.netflix.zuul.passport.PassportState;
import com.netflix.zuul.stats.status.StatusCategory;
import com.netflix.zuul.stats.status.StatusCategoryUtils;
import com.netflix.zuul.stats.status.ZuulStatusCategory;
import com.netflix.zuul.util.HttpUtils;
import com.netflix.zuul.util.ProxyUtils;
import com.netflix.zuul.util.VipUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.perfmark.PerfMark;
import io.perfmark.TaskCloseable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Filter(order=0, type=FilterType.ENDPOINT)
public class ProxyEndpoint
extends SyncZuulFilterAdapter<HttpRequestMessage, HttpResponseMessage>
implements GenericFutureListener<Future<PooledConnection>> {
    private final ChannelHandlerContext channelCtx;
    private final FilterRunner<HttpResponseMessage, ?> responseFilters;
    protected final AtomicReference<DiscoveryResult> chosenServer;
    protected final AtomicReference<InetAddress> chosenHostAddr;
    protected final HttpRequestMessage zuulRequest;
    protected final SessionContext context;
    @Nullable
    protected final NettyOrigin origin;
    protected final RequestAttempts requestAttempts;
    protected final CurrentPassport passport;
    protected final NettyRequestAttemptFactory requestAttemptFactory;
    protected final OriginTimeoutManager originTimeoutManager;
    protected MethodBinding<?> methodBinding;
    protected HttpResponseMessage zuulResponse;
    protected boolean startedSendingResponseToClient;
    protected Duration timeLeftForAttempt;
    private volatile PooledConnection originConn;
    private volatile OriginResponseReceiver originResponseReceiver;
    private volatile int concurrentReqCount;
    private volatile boolean proxiedRequestWithoutBuffering;
    protected int attemptNum;
    protected RequestAttempt currentRequestAttempt;
    protected List<RequestStat> requestStats = new ArrayList<RequestStat>();
    protected RequestStat currentRequestStat;
    private final byte[] retryBodyCache;
    public static final Set<String> IDEMPOTENT_HTTP_METHODS = Sets.newHashSet((Object[])new String[]{"GET", "HEAD", "OPTIONS"});
    private static final DynamicIntegerSetProperty RETRIABLE_STATUSES_FOR_IDEMPOTENT_METHODS = new DynamicIntegerSetProperty("zuul.retry.allowed.statuses.idempotent", "500");
    private static final DynamicBooleanProperty ENABLE_CACHING_BODIES = new DynamicBooleanProperty("zuul.cache.bodies", true);
    private static final DynamicBooleanProperty ENABLE_CACHING_PLAINTEXT_BODIES = new DynamicBooleanProperty("zuul.cache.bodies.plaintext", true);
    private static final CachedDynamicLongProperty THROTTLE_MEMORY_SECONDS = new CachedDynamicLongProperty("zuul.proxy.throttle_memory_seconds", Duration.ofMinutes(5L).getSeconds());
    private static final Set<HeaderName> REQUEST_HEADERS_TO_REMOVE = Sets.newHashSet((Object[])new HeaderName[]{HttpHeaderNames.CONNECTION, HttpHeaderNames.KEEP_ALIVE});
    private static final Set<HeaderName> RESPONSE_HEADERS_TO_REMOVE = Sets.newHashSet((Object[])new HeaderName[]{HttpHeaderNames.CONNECTION, HttpHeaderNames.KEEP_ALIVE});
    public static final String POOLED_ORIGIN_CONNECTION_KEY = "_origin_pooled_conn";
    private static final Logger LOG = LoggerFactory.getLogger(ProxyEndpoint.class);
    private static final Counter NO_RETRY_INCOMPLETE_BODY = SpectatorUtils.newCounter("zuul.no.retry", "incomplete_body");
    private static final Counter NO_RETRY_RESP_STARTED = SpectatorUtils.newCounter("zuul.no.retry", "resp_started");
    private final Counter populatedRetryBody;

    public ProxyEndpoint(HttpRequestMessage inMesg, ChannelHandlerContext ctx, FilterRunner<HttpResponseMessage, ?> filters, MethodBinding<?> methodBinding) {
        this(inMesg, ctx, filters, methodBinding, new NettyRequestAttemptFactory());
    }

    public ProxyEndpoint(HttpRequestMessage inMesg, ChannelHandlerContext ctx, FilterRunner<HttpResponseMessage, ?> filters, MethodBinding<?> methodBinding, NettyRequestAttemptFactory requestAttemptFactory) {
        this.channelCtx = ctx;
        this.responseFilters = filters;
        this.zuulRequest = this.transformRequest(inMesg);
        this.context = this.zuulRequest.getContext();
        this.origin = this.getOrigin(this.zuulRequest);
        this.originTimeoutManager = this.getTimeoutManager(this.origin);
        this.requestAttempts = RequestAttempts.getFromSessionContext(this.context);
        this.passport = CurrentPassport.fromSessionContext(this.context);
        this.chosenServer = new AtomicReference<DiscoveryResult>(DiscoveryResult.EMPTY);
        this.chosenHostAddr = new AtomicReference();
        this.retryBodyCache = this.preCacheBodyForRetryingRequests();
        this.populatedRetryBody = SpectatorUtils.newCounter("zuul.populated.retry.body", this.origin == null ? "null" : this.origin.getName().getTarget());
        this.methodBinding = methodBinding;
        this.requestAttemptFactory = requestAttemptFactory;
    }

    public int getAttemptNum() {
        return this.attemptNum;
    }

    public RequestAttempts getRequestAttempts() {
        return this.requestAttempts;
    }

    protected RequestAttempt getCurrentRequestAttempt() {
        return this.currentRequestAttempt;
    }

    public CurrentPassport getPassport() {
        return this.passport;
    }

    public NettyOrigin getOrigin() {
        return this.origin;
    }

    public HttpRequestMessage getZuulRequest() {
        return this.zuulRequest;
    }

    private Channel unlinkFromOrigin() {
        if (this.originResponseReceiver != null) {
            this.originResponseReceiver.unlinkFromClientRequest();
            this.originResponseReceiver = null;
        }
        if (this.concurrentReqCount > 0) {
            this.origin.recordProxyRequestEnd();
            --this.concurrentReqCount;
        }
        Channel origCh = null;
        if (this.originConn != null) {
            origCh = this.originConn.getChannel();
            this.originConn = null;
        }
        return origCh;
    }

    public void finish(boolean error) {
        Channel origCh = this.unlinkFromOrigin();
        while (this.concurrentReqCount > 0) {
            this.origin.recordProxyRequestEnd();
            --this.concurrentReqCount;
        }
        if (this.currentRequestStat != null && error) {
            this.currentRequestStat.generalError();
        }
        if (!this.requestStats.isEmpty()) {
            int indexFinal = this.requestStats.size() - 1;
            for (int i = 0; i < this.requestStats.size(); ++i) {
                RequestStat stat = this.requestStats.get(i);
                stat.finalAttempt(i == indexFinal);
                stat.finishIfNotAlready();
            }
        }
        if (error && origCh != null) {
            origCh.close();
        }
    }

    @Override
    public String filterName() {
        return "ProxyEndpoint";
    }

    @Override
    public HttpResponseMessage apply(HttpRequestMessage input) {
        try {
            if (this.origin == null) {
                this.handleNoOriginSelected();
                return null;
            }
            this.origin.onRequestExecutionStart(this.zuulRequest);
            this.proxyRequestToOrigin();
            return null;
        }
        catch (Exception ex) {
            this.handleError(ex);
            return null;
        }
    }

    @Override
    public HttpContent processContentChunk(ZuulMessage zuulReq, HttpContent chunk) {
        if (this.originConn != null) {
            this.proxiedRequestWithoutBuffering = true;
            this.originConn.getChannel().writeAndFlush((Object)chunk);
            return null;
        }
        return chunk;
    }

    @Override
    public HttpResponseMessage getDefaultOutput(HttpRequestMessage input) {
        return null;
    }

    public void invokeNext(HttpResponseMessage zuulResponse) {
        try {
            this.methodBinding.bind(() -> this.filterResponse(zuulResponse));
        }
        catch (Exception ex) {
            this.unlinkFromOrigin();
            LOG.error("Error in invokeNext resp", (Throwable)ex);
            this.channelCtx.fireExceptionCaught((Throwable)ex);
        }
    }

    private void filterResponse(HttpResponseMessage zuulResponse) {
        if (this.responseFilters != null) {
            this.responseFilters.filter(zuulResponse);
        } else {
            this.channelCtx.fireChannelRead((Object)zuulResponse);
        }
    }

    public void invokeNext(HttpContent chunk) {
        try {
            this.methodBinding.bind(() -> this.filterResponseChunk(chunk));
        }
        catch (Exception ex) {
            this.unlinkFromOrigin();
            LOG.error("Error in invokeNext content", (Throwable)ex);
            this.channelCtx.fireExceptionCaught((Throwable)ex);
        }
    }

    private void filterResponseChunk(HttpContent chunk) {
        if (chunk instanceof LastHttpContent) {
            this.unlinkFromOrigin();
        }
        if (this.responseFilters != null) {
            this.responseFilters.filter(this.zuulResponse, chunk);
        } else {
            this.channelCtx.fireChannelRead((Object)chunk);
        }
    }

    private void storeAndLogOriginRequestInfo() {
        String ipAddr;
        Map<String, Object> eventProps = this.context.getEventProperties();
        HashMap<Integer, String> attemptToIpAddressMap = (HashMap<Integer, String>)eventProps.get("_zuul_origin_attempt_ipaddr_map");
        HashMap<Integer, InetAddress> attemptToChosenHostMap = (HashMap<Integer, InetAddress>)eventProps.get("_zuul_origin_chosen_host_addr_map");
        if (attemptToIpAddressMap == null) {
            attemptToIpAddressMap = new HashMap<Integer, String>();
        }
        if (attemptToChosenHostMap == null) {
            attemptToChosenHostMap = new HashMap<Integer, InetAddress>();
        }
        if ((ipAddr = this.origin.getIpAddrFromServer(this.chosenServer.get())) != null) {
            attemptToIpAddressMap.put(this.attemptNum, ipAddr);
            eventProps.put("_zuul_origin_attempt_ipaddr_map", attemptToIpAddressMap);
            this.context.put("_zuul_origin_attempt_ipaddr_map", attemptToIpAddressMap);
        }
        if (this.chosenHostAddr.get() != null) {
            attemptToChosenHostMap.put(this.attemptNum, this.chosenHostAddr.get());
            eventProps.put("_zuul_origin_chosen_host_addr_map", attemptToChosenHostMap);
            this.context.put("_zuul_origin_chosen_host_addr_map", attemptToChosenHostMap);
        }
        eventProps.put("_zuul_origin_request_uri", this.zuulRequest.getPathAndQuery());
    }

    protected void updateOriginRpsTrackers(NettyOrigin origin, int attempt) {
    }

    private void proxyRequestToOrigin() {
        Promise<PooledConnection> promise = null;
        try {
            ++this.attemptNum;
            this.timeLeftForAttempt = this.originTimeoutManager.computeReadTimeout(this.zuulRequest, this.attemptNum);
            this.currentRequestStat = this.createRequestStat();
            this.origin.preRequestChecks(this.zuulRequest);
            ++this.concurrentReqCount;
            this.updateOriginRpsTrackers(this.origin, this.attemptNum);
            promise = this.origin.connectToOrigin(this.zuulRequest, this.channelCtx.channel().eventLoop(), this.attemptNum, this.passport, this.chosenServer, this.chosenHostAddr);
            this.storeAndLogOriginRequestInfo();
            this.currentRequestAttempt = this.origin.newRequestAttempt(this.chosenServer.get(), this.context, this.attemptNum);
            this.requestAttempts.add(this.currentRequestAttempt);
            this.passport.add(PassportState.ORIGIN_CONN_ACQUIRE_START);
            if (promise.isDone()) {
                this.operationComplete((Future<PooledConnection>)promise);
            } else {
                promise.addListener((GenericFutureListener)this);
            }
        }
        catch (Exception ex) {
            LOG.error("Error while connecting to origin, UUID {} " + this.context.getUUID(), (Throwable)ex);
            this.storeAndLogOriginRequestInfo();
            if (promise != null && !promise.isDone()) {
                promise.setFailure((Throwable)ex);
            }
            this.errorFromOrigin(ex);
        }
    }

    protected RequestStat createRequestStat() {
        BasicRequestStat basicRequestStat = new BasicRequestStat();
        this.requestStats.add(basicRequestStat);
        RequestStat.putInSessionContext(basicRequestStat, this.context);
        return basicRequestStat;
    }

    public void operationComplete(Future<PooledConnection> connectResult) {
        try {
            this.methodBinding.bind(() -> {
                DiscoveryResult server = this.chosenServer.get();
                if (server != DiscoveryResult.EMPTY) {
                    if (this.currentRequestStat != null) {
                        this.currentRequestStat.server(server);
                    }
                    this.origin.onRequestStartWithServer(this.zuulRequest, server, this.attemptNum);
                }
                if (connectResult.isSuccess()) {
                    this.onOriginConnectSucceeded((PooledConnection)connectResult.getNow(), this.timeLeftForAttempt);
                } else {
                    this.onOriginConnectFailed(connectResult.cause());
                }
            });
        }
        catch (Throwable ex) {
            LOG.error("Uncaught error in operationComplete(). Closing the server channel now. {}", (Object)ChannelUtils.channelInfoForLogging(this.channelCtx.channel()), (Object)ex);
            this.unlinkFromOrigin();
            this.channelCtx.fireExceptionCaught(ex);
        }
    }

    private void onOriginConnectSucceeded(PooledConnection conn, Duration readTimeout) {
        this.passport.add(PassportState.ORIGIN_CONN_ACQUIRE_END);
        if (this.context.isCancelled()) {
            LOG.info("Client cancelled after successful origin connect: {}", (Object)conn.getChannel());
            conn.setConnectionState(PooledConnection.ConnectionState.WRITE_READY);
            conn.release();
        } else {
            this.currentRequestAttempt.setReadTimeout(readTimeout.toMillis());
            this.writeClientRequestToOrigin(conn, readTimeout);
        }
    }

    private void onOriginConnectFailed(Throwable cause) {
        this.passport.add(PassportState.ORIGIN_CONN_ACQUIRE_FAILED);
        if (!this.context.isCancelled()) {
            this.errorFromOrigin(cause);
        }
    }

    @Nullable
    private byte[] preCacheBodyForRetryingRequests() {
        long timeSinceLastThrottle;
        ZonedDateTime lastThrottleEvent;
        if (ENABLE_CACHING_BODIES.get() && this.origin != null && this.zuulRequest.hasCompleteBody() && (((Boolean)this.origin.getClientConfig().get(IClientConfigKey.Keys.IsSecure, (Object)false)).booleanValue() || ENABLE_CACHING_PLAINTEXT_BODIES.get()) && (lastThrottleEvent = this.origin.stats().lastThrottleEvent()) != null && (timeSinceLastThrottle = Duration.between(lastThrottleEvent, ZonedDateTime.now()).getSeconds()) <= THROTTLE_MEMORY_SECONDS.get()) {
            return this.zuulRequest.getBody();
        }
        return null;
    }

    private void repopulateRetryBody() {
        if (this.retryBodyCache != null && this.attemptNum > 1 && this.zuulRequest.getBodyLength() == 0 && this.zuulRequest.getBody() != null) {
            this.zuulRequest.setBody(this.retryBodyCache);
            this.populatedRetryBody.increment();
        }
    }

    private void writeClientRequestToOrigin(PooledConnection conn, Duration readTimeout) {
        Channel ch = conn.getChannel();
        this.passport.setOnChannel(ch);
        ch.attr(ClientTimeoutHandler.ORIGIN_RESPONSE_READ_TIMEOUT).set((Object)readTimeout);
        this.context.set("_origin_channel", ch);
        this.context.set(POOLED_ORIGIN_CONNECTION_KEY, conn);
        this.preWriteToOrigin(this.chosenServer.get(), this.zuulRequest);
        ChannelPipeline pipeline = ch.pipeline();
        this.originResponseReceiver = this.getOriginResponseReceiver();
        pipeline.addBefore("connectionPoolHandler", "_origin_response_receiver", (ChannelHandler)this.originResponseReceiver);
        this.repopulateRetryBody();
        ch.write((Object)this.zuulRequest);
        ProxyEndpoint.writeBufferedBodyContent(this.zuulRequest, ch);
        ch.flush();
        ch.read();
        this.originConn = conn;
        this.channelCtx.read();
    }

    protected OriginResponseReceiver getOriginResponseReceiver() {
        return new OriginResponseReceiver(this);
    }

    protected void preWriteToOrigin(DiscoveryResult chosenServer, HttpRequestMessage zuulRequest) {
    }

    private static void writeBufferedBodyContent(HttpRequestMessage zuulRequest, Channel channel) {
        zuulRequest.getBodyContents().forEach(chunk -> channel.write((Object)chunk.retain()));
    }

    protected boolean isRemoteZuulRetriesBelowRetryLimit(int maxAllowedRetries) {
        return true;
    }

    protected boolean isBelowRetryLimit() {
        int maxAllowedRetries = this.origin.getMaxRetriesForRequest(this.context);
        return this.attemptNum <= maxAllowedRetries && this.isRemoteZuulRetriesBelowRetryLimit(maxAllowedRetries);
    }

    public void errorFromOrigin(Throwable ex) {
        try {
            if (this.originConn != null) {
                this.originConn.getServer().incrementSuccessiveConnectionFailureCount();
                this.originConn.getServer().addToFailureCount();
                this.originConn.flagShouldClose();
            }
            Channel originCh = this.unlinkFromOrigin();
            this.methodBinding.bind(() -> this.processErrorFromOrigin(ex, originCh));
        }
        catch (Exception e) {
            this.channelCtx.fireExceptionCaught(ex);
        }
    }

    private void processErrorFromOrigin(Throwable ex, Channel origCh) {
        try {
            SessionContext zuulCtx = this.context;
            ErrorType err = this.requestAttemptFactory.mapNettyToOutboundErrorType(ex);
            if (zuulCtx.isInBrownoutMode()) {
                LOG.warn(err.getStatusCategory().name() + ", origin = " + this.origin.getName() + ": " + String.valueOf(ex));
            } else {
                String origChInfo;
                String string = origChInfo = origCh != null ? ChannelUtils.channelInfoForLogging(origCh) : "";
                if (LOG.isInfoEnabled()) {
                    LOG.warn(err.getStatusCategory().name() + ", origin = " + this.origin.getName() + ", origin channel info = " + origChInfo, ex);
                } else {
                    LOG.warn(err.getStatusCategory().name() + ", origin = " + this.origin.getName() + ", " + String.valueOf(ex) + ", origin channel info = " + origChInfo);
                }
            }
            if (this.currentRequestStat != null) {
                this.currentRequestStat.failAndSetErrorCode(err);
            }
            if (this.currentRequestAttempt != null) {
                this.currentRequestAttempt.complete(-1, this.currentRequestStat.duration(), ex);
            }
            this.postErrorProcessing(ex, zuulCtx, err, this.chosenServer.get(), this.attemptNum);
            ClientException niwsEx = new ClientException(ClientException.ErrorType.valueOf((String)err.getClientErrorType().name()));
            if (this.chosenServer.get() != DiscoveryResult.EMPTY) {
                this.origin.onRequestExceptionWithServer(this.zuulRequest, this.chosenServer.get(), this.attemptNum, (Throwable)niwsEx);
            }
            if (this.isBelowRetryLimit() && this.isRetryable(err)) {
                this.passport.add(PassportState.ORIGIN_RETRY_START);
                this.origin.adjustRetryPolicyIfNeeded(this.zuulRequest);
                this.proxyRequestToOrigin();
            } else {
                zuulCtx.setError(ex);
                zuulCtx.setShouldSendErrorResponse(true);
                StatusCategoryUtils.storeStatusCategoryIfNotAlreadyFailure(zuulCtx, err.getStatusCategory());
                this.origin.recordFinalError(this.zuulRequest, ex);
                this.origin.onRequestExecutionFailed(this.zuulRequest, this.chosenServer.get(), this.attemptNum - 1, (Throwable)niwsEx);
                this.handleError(ex);
            }
        }
        catch (Exception e) {
            this.handleError(ex);
        }
    }

    protected void postErrorProcessing(Throwable ex, SessionContext zuulCtx, ErrorType err, DiscoveryResult chosenServer, int attemptNum) {
    }

    private void handleError(Throwable cause) {
        ZuulException ze = cause instanceof ZuulException ? (ZuulException)cause : this.requestAttemptFactory.mapNettyToOutboundException(cause, this.context);
        LOG.debug("Proxy endpoint failed.", cause);
        if (!this.startedSendingResponseToClient) {
            this.startedSendingResponseToClient = true;
            this.zuulResponse = new HttpResponseMessageImpl(this.context, this.zuulRequest, ze.getStatusCode());
            this.zuulResponse.getHeaders().add("Connection", "close");
            this.zuulResponse.finishBufferedBodyIfIncomplete();
            this.invokeNext(this.zuulResponse);
        } else {
            this.channelCtx.fireExceptionCaught((Throwable)ze);
        }
    }

    private void handleNoOriginSelected() {
        StatusCategoryUtils.setStatusCategory(this.context, ZuulStatusCategory.SUCCESS_LOCAL_NO_ROUTE);
        this.startedSendingResponseToClient = true;
        this.zuulResponse = new HttpResponseMessageImpl(this.context, this.zuulRequest, 404);
        this.zuulResponse.finishBufferedBodyIfIncomplete();
        this.invokeNext(this.zuulResponse);
    }

    protected boolean isRetryable(ErrorType err) {
        if (err == OutboundErrorType.RESET_CONNECTION || err == OutboundErrorType.CONNECT_ERROR || err == OutboundErrorType.READ_TIMEOUT && IDEMPOTENT_HTTP_METHODS.contains(this.zuulRequest.getMethod().toUpperCase())) {
            return this.isRequestReplayable();
        }
        return false;
    }

    protected boolean isRequestReplayable() {
        if (this.startedSendingResponseToClient) {
            NO_RETRY_RESP_STARTED.increment();
            return false;
        }
        if (this.proxiedRequestWithoutBuffering) {
            NO_RETRY_INCOMPLETE_BODY.increment();
            return false;
        }
        return true;
    }

    public void responseFromOrigin(HttpResponse originResponse) {
        try (TaskCloseable ignore = PerfMark.traceTask((String)"ProxyEndpoint.responseFromOrigin");){
            PerfMark.attachTag((String)"uuid", (Object)this.zuulRequest, r -> r.getContext().getUUID());
            PerfMark.attachTag((String)"path", (Object)this.zuulRequest, HttpRequestInfo::getPath);
            this.methodBinding.bind(() -> this.processResponseFromOrigin(originResponse));
        }
        catch (Exception ex) {
            this.unlinkFromOrigin();
            LOG.error("Error in responseFromOrigin", (Throwable)ex);
            this.channelCtx.fireExceptionCaught((Throwable)ex);
        }
    }

    private void processResponseFromOrigin(HttpResponse originResponse) {
        if (originResponse.status().code() >= 500) {
            this.handleOriginNonSuccessResponse(originResponse, this.chosenServer.get());
        } else {
            this.handleOriginSuccessResponse(originResponse, this.chosenServer.get());
        }
    }

    protected void handleOriginSuccessResponse(HttpResponse originResponse, DiscoveryResult chosenServer) {
        this.origin.recordSuccessResponse();
        if (this.originConn != null) {
            this.originConn.getServer().clearSuccessiveConnectionFailureCount();
        }
        int respStatus = originResponse.status().code();
        long duration = 0L;
        if (this.currentRequestStat != null) {
            this.currentRequestStat.updateWithHttpStatusCode(respStatus);
            duration = this.currentRequestStat.duration();
        }
        if (this.currentRequestAttempt != null) {
            this.currentRequestAttempt.complete(respStatus, duration, null);
        }
        ZuulStatusCategory statusCategory = respStatus == 404 ? ZuulStatusCategory.SUCCESS_NOT_FOUND : ZuulStatusCategory.SUCCESS;
        this.zuulResponse = this.buildZuulHttpResponse(originResponse, statusCategory, this.context.getError());
        this.invokeNext(this.zuulResponse);
    }

    private HttpResponseMessage buildZuulHttpResponse(HttpResponse httpResponse, StatusCategory statusCategory, Throwable ex) {
        this.startedSendingResponseToClient = true;
        SessionContext zuulCtx = this.context;
        int respStatus = httpResponse.status().code();
        HttpResponseMessageImpl zuulResponse = new HttpResponseMessageImpl(zuulCtx, this.zuulRequest, respStatus);
        Headers respHeaders = zuulResponse.getHeaders();
        for (Map.Entry entry : httpResponse.headers()) {
            respHeaders.add((String)entry.getKey(), (String)entry.getValue());
        }
        if (HttpUtils.hasChunkedTransferEncodingHeader(zuulResponse) || HttpUtils.hasNonZeroContentLengthHeader(zuulResponse)) {
            zuulResponse.setHasBody(true);
        }
        zuulResponse.storeInboundResponse();
        this.channelCtx.channel().attr(ClientRequestReceiver.ATTR_ZUUL_RESP).set((Object)zuulResponse);
        if (httpResponse instanceof DefaultFullHttpResponse) {
            ByteBuf chunk = ((DefaultFullHttpResponse)httpResponse).content();
            zuulResponse.bufferBodyContents((HttpContent)new DefaultLastHttpContent(chunk));
        }
        if (this.originConn != null) {
            if (statusCategory == ZuulStatusCategory.FAILURE_ORIGIN_THROTTLED) {
                this.origin.onRequestExecutionFailed(this.zuulRequest, this.originConn.getServer(), this.attemptNum, (Throwable)new ClientException(ClientException.ErrorType.SERVER_THROTTLED));
            } else {
                this.origin.onRequestExecutionSuccess(this.zuulRequest, zuulResponse, this.originConn.getServer(), this.attemptNum);
            }
        }
        this.origin.recordFinalResponse(zuulResponse);
        this.origin.recordFinalError(this.zuulRequest, ex);
        zuulCtx.set("status_category", statusCategory);
        zuulCtx.setError(ex);
        zuulCtx.put("origin_http_status", Integer.toString(respStatus));
        return this.transformResponse(zuulResponse);
    }

    private HttpResponseMessage transformResponse(HttpResponseMessage resp) {
        RESPONSE_HEADERS_TO_REMOVE.stream().forEach(s -> resp.getHeaders().remove((HeaderName)s));
        return resp;
    }

    protected void handleOriginNonSuccessResponse(HttpResponse originResponse, DiscoveryResult chosenServer) {
        OutboundException obe;
        ClientException.ErrorType niwsErrorType;
        ZuulStatusCategory statusCategory;
        int respStatus = originResponse.status().code();
        if (respStatus == 503) {
            statusCategory = ZuulStatusCategory.FAILURE_ORIGIN_THROTTLED;
            niwsErrorType = ClientException.ErrorType.SERVER_THROTTLED;
            obe = new OutboundException(OutboundErrorType.SERVICE_UNAVAILABLE, this.requestAttempts);
            this.origin.stats().lastThrottleEvent(ZonedDateTime.now());
            if (this.originConn != null) {
                this.originConn.getServer().incrementSuccessiveConnectionFailureCount();
                this.originConn.getServer().addToFailureCount();
                this.originConn.flagShouldClose();
            }
            if (this.currentRequestStat != null) {
                this.currentRequestStat.updateWithHttpStatusCode(respStatus);
                this.currentRequestStat.serviceUnavailable();
            }
        } else {
            statusCategory = ZuulStatusCategory.FAILURE_ORIGIN;
            niwsErrorType = ClientException.ErrorType.GENERAL;
            obe = new OutboundException(OutboundErrorType.ERROR_STATUS_RESPONSE, this.requestAttempts);
            if (this.currentRequestStat != null) {
                this.currentRequestStat.updateWithHttpStatusCode(respStatus);
                this.currentRequestStat.generalError();
            }
        }
        obe.setStatusCode(respStatus);
        long duration = 0L;
        if (this.currentRequestStat != null) {
            duration = this.currentRequestStat.duration();
        }
        if (this.currentRequestAttempt != null) {
            this.currentRequestAttempt.complete(respStatus, duration, obe);
        }
        this.origin.onRequestExceptionWithServer(this.zuulRequest, chosenServer, this.attemptNum, (Throwable)new ClientException(niwsErrorType));
        if (this.isBelowRetryLimit() && this.isRetryable5xxResponse(this.zuulRequest, originResponse)) {
            LOG.debug("Retrying: status={}, attemptNum={}, maxRetries={}, startedSendingResponseToClient={}, hasCompleteBody={}, method={}", new Object[]{respStatus, this.attemptNum, this.origin.getMaxRetriesForRequest(this.context), this.startedSendingResponseToClient, this.zuulRequest.hasCompleteBody(), this.zuulRequest.getMethod()});
            this.unlinkFromOrigin();
            this.passport.add(PassportState.ORIGIN_RETRY_START);
            this.origin.adjustRetryPolicyIfNeeded(this.zuulRequest);
            this.proxyRequestToOrigin();
        } else {
            SessionContext zuulCtx = this.context;
            LOG.info("Sending error to client: status={}, attemptNum={}, maxRetries={}, startedSendingResponseToClient={}, hasCompleteBody={}, method={}", new Object[]{respStatus, this.attemptNum, this.origin.getMaxRetriesForRequest(zuulCtx), this.startedSendingResponseToClient, this.zuulRequest.hasCompleteBody(), this.zuulRequest.getMethod()});
            this.zuulResponse = this.buildZuulHttpResponse(originResponse, statusCategory, obe);
            this.invokeNext(this.zuulResponse);
        }
    }

    public boolean isRetryable5xxResponse(HttpRequestMessage zuulRequest, HttpResponse originResponse) {
        if (this.isRequestReplayable()) {
            int status = originResponse.status().code();
            if (status == 503 || this.originIndicatesRetryableInternalServerError(originResponse)) {
                return true;
            }
            if (RETRIABLE_STATUSES_FOR_IDEMPOTENT_METHODS.get().contains(status) && IDEMPOTENT_HTTP_METHODS.contains(zuulRequest.getMethod().toUpperCase())) {
                return true;
            }
        }
        return false;
    }

    protected boolean originIndicatesRetryableInternalServerError(HttpResponse response) {
        return false;
    }

    protected HttpRequestMessage transformRequest(HttpRequestMessage requestMsg) {
        HttpRequestMessage massagedRequest = ProxyEndpoint.massageRequestURI(requestMsg);
        Headers headers = massagedRequest.getHeaders();
        REQUEST_HEADERS_TO_REMOVE.forEach(headerName -> headers.remove(headerName.getName()));
        this.addCustomRequestHeaders(headers);
        ProxyUtils.addXForwardedHeaders(massagedRequest);
        return massagedRequest;
    }

    protected void addCustomRequestHeaders(Headers headers) {
    }

    private static HttpRequestMessage massageRequestURI(HttpRequestMessage request) {
        Object override;
        SessionContext context = request.getContext();
        HttpQueryParams modifiedQueryParams = null;
        String uri = null;
        if (context.get("requestURI") != null) {
            uri = (String)context.get("requestURI");
        }
        if ((override = context.get("overrideURI")) != null) {
            uri = override.toString();
        }
        if (null != uri) {
            String modifiedPath;
            int index = uri.indexOf(63);
            if (index != -1) {
                String paramString = uri.substring(index + 1);
                modifiedPath = uri.substring(0, index);
                try {
                    paramString = URLDecoder.decode(paramString, "UTF-8");
                    modifiedQueryParams = new HttpQueryParams();
                    StringTokenizer stk = new StringTokenizer(paramString, "&");
                    while (stk.hasMoreTokens()) {
                        String token = stk.nextToken();
                        int idx = token.indexOf("=");
                        if (idx == -1) continue;
                        String key = token.substring(0, idx);
                        String val = token.substring(idx + 1);
                        modifiedQueryParams.add(key, val);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error("Error decoding url query param - " + paramString, (Throwable)e);
                }
            } else {
                modifiedPath = uri;
            }
            request.setPath(modifiedPath);
            if (null != modifiedQueryParams) {
                request.setQueryParams(modifiedQueryParams);
            }
        }
        return request;
    }

    @Nullable
    protected NettyOrigin getOrigin(HttpRequestMessage request) {
        String primaryRoute;
        ImmutableList.Builder routingLogEntries;
        SessionContext context = request.getContext();
        OriginManager originManager = (OriginManager)context.get("origin_manager");
        if (Debug.debugRequest(context) && (routingLogEntries = (ImmutableList.Builder)context.get("routing_log")) != null) {
            for (String entry : routingLogEntries.build()) {
                Debug.addRequestDebug(context, "RoutingLog: " + entry);
            }
        }
        if (Strings.isNullOrEmpty((String)(primaryRoute = context.getRouteVIP()))) {
            return null;
        }
        String restClientVIP = primaryRoute;
        boolean useFullName = context.getBoolean("use_full_vip_name");
        String restClientName = useFullName ? restClientVIP : VipUtils.getVIPPrefix(restClientVIP);
        NettyOrigin origin = null;
        OriginName overrideOriginName = this.injectCustomOriginName(request);
        if (overrideOriginName != null) {
            origin = this.getOrCreateOrigin(originManager, overrideOriginName, request.reconstructURI(), context);
        } else if (restClientName != null) {
            OriginName originName = OriginName.fromVip(restClientVIP, restClientName);
            origin = this.getOrCreateOrigin(originManager, originName, request.reconstructURI(), context);
        }
        this.verifyOrigin(context, request, restClientName, origin);
        if (origin != null) {
            context.set("origin_vip_actual", origin.getClientConfig().get(IClientConfigKey.Keys.DeploymentContextBasedVipAddresses));
            context.set("origin_vip_secure", origin.getClientConfig().get(IClientConfigKey.Keys.IsSecure));
        }
        return origin;
    }

    @Nullable
    protected OriginName injectCustomOriginName(HttpRequestMessage request) {
        return null;
    }

    private NettyOrigin getOrCreateOrigin(OriginManager<NettyOrigin> originManager, OriginName originName, String uri, SessionContext ctx) {
        NettyOrigin origin = originManager.getOrigin(originName, uri, ctx);
        if (origin == null) {
            LOG.warn("Attempting to register RestClient for client that has not been configured. originName={}, uri={}", (Object)originName, (Object)uri);
            origin = originManager.createOrigin(originName, uri, ctx);
        }
        return origin;
    }

    private void verifyOrigin(SessionContext context, HttpRequestMessage request, String restClientName, Origin primaryOrigin) {
        if (primaryOrigin == null) {
            context.set("status_category", ZuulStatusCategory.SUCCESS_LOCAL_NO_ROUTE);
            String causeName = "RESTCLIENT_NOTFOUND";
            this.originNotFound(context, causeName);
            ZuulException ze = new ZuulException("No origin found for request. name=" + restClientName + ", uri=" + request.reconstructURI(), causeName);
            ze.setStatusCode(404);
            throw ze;
        }
    }

    @ForOverride
    protected void originNotFound(SessionContext context, String causeName) {
    }

    @ForOverride
    protected OriginTimeoutManager getTimeoutManager(NettyOrigin origin) {
        return new OriginTimeoutManager(origin);
    }
}

