/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.filters.endpoint;

import com.netflix.zuul.Filter;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.exception.ZuulException;
import com.netflix.zuul.filters.FilterType;
import com.netflix.zuul.filters.SyncZuulFilterAdapter;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.message.http.HttpResponseMessageImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Filter(order=0, type=FilterType.ENDPOINT)
public final class MissingEndpointHandlingFilter
extends SyncZuulFilterAdapter<HttpRequestMessage, HttpResponseMessage> {
    private final String name;
    private static final Logger LOG = LoggerFactory.getLogger(MissingEndpointHandlingFilter.class);

    public MissingEndpointHandlingFilter(String name) {
        this.name = name;
    }

    @Override
    public HttpResponseMessage apply(HttpRequestMessage request) {
        SessionContext zuulCtx = request.getContext();
        zuulCtx.setErrorResponseSent(true);
        String errMesg = "Missing Endpoint filter, name = " + this.name;
        zuulCtx.setError(new ZuulException(errMesg, true));
        LOG.error(errMesg);
        return new HttpResponseMessageImpl(zuulCtx, request, 500);
    }

    @Override
    public String filterName() {
        return this.name;
    }

    @Override
    public HttpResponseMessage getDefaultOutput(HttpRequestMessage input) {
        return HttpResponseMessageImpl.defaultErrorResponse(input);
    }
}

