/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.filters.common;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicStringProperty;
import com.netflix.zuul.Filter;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.filters.FilterType;
import com.netflix.zuul.filters.http.HttpInboundSyncFilter;
import com.netflix.zuul.message.http.HttpQueryParams;
import com.netflix.zuul.message.http.HttpRequestMessage;

@Filter(order=99, type=FilterType.INBOUND)
public class SurgicalDebugFilter
extends HttpInboundSyncFilter {
    protected boolean patternMatches(HttpRequestMessage request) {
        return false;
    }

    @Override
    public int filterOrder() {
        return 99;
    }

    @Override
    public boolean shouldFilter(HttpRequestMessage request) {
        DynamicBooleanProperty debugFilterShutoff = new DynamicBooleanProperty("zuul.debugFilters.disabled", false);
        if (debugFilterShutoff.get()) {
            return false;
        }
        if (this.isDisabled()) {
            return false;
        }
        String isSurgicalFilterRequest = request.getHeaders().getFirst("X-Zuul-Surgical-Filter");
        boolean notAlreadyFiltered = !"true".equals(isSurgicalFilterRequest);
        return notAlreadyFiltered && this.patternMatches(request);
    }

    @Override
    public HttpRequestMessage apply(HttpRequestMessage request) {
        DynamicStringProperty routeVip = new DynamicStringProperty("zuul.debug.vip", null);
        DynamicStringProperty routeHost = new DynamicStringProperty("zuul.debug.host", null);
        SessionContext ctx = request.getContext();
        if (routeVip.get() != null || routeHost.get() != null) {
            ctx.set("routeHost", routeHost.get());
            ctx.set("routeVIP", routeVip.get());
            request.getHeaders().set("X-Zuul-Surgical-Filter", "true");
            HttpQueryParams queryParams = request.getQueryParams();
            queryParams.set("debugRequest", "true");
            ctx.setDebugRequest(true);
            ctx.set("zuulToZuul", true);
        }
        return request;
    }
}

