/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.filters.common;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.config.CachedDynamicBooleanProperty;
import com.netflix.config.CachedDynamicIntProperty;
import com.netflix.config.DynamicStringSetProperty;
import com.netflix.zuul.Filter;
import com.netflix.zuul.filters.FilterType;
import com.netflix.zuul.filters.http.HttpOutboundSyncFilter;
import com.netflix.zuul.message.Headers;
import com.netflix.zuul.message.ZuulMessage;
import com.netflix.zuul.message.http.HttpHeaderNames;
import com.netflix.zuul.message.http.HttpRequestInfo;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.util.Gzipper;
import com.netflix.zuul.util.HttpUtils;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;

@Filter(order=110, type=FilterType.OUTBOUND)
public class GZipResponseFilter
extends HttpOutboundSyncFilter {
    private static DynamicStringSetProperty GZIPPABLE_CONTENT_TYPES = new DynamicStringSetProperty("zuul.gzip.contenttypes", "text/html,application/x-javascript,text/css,application/javascript,text/javascript,text/plain,text/xml,application/json,application/vnd.ms-fontobject,application/x-font-opentype,application/x-font-truetype,application/x-font-ttf,application/xml,font/eot,font/opentype,font/otf,image/svg+xml,image/vnd.microsoft.icon", ",");
    private static final CachedDynamicIntProperty MIN_BODY_SIZE_FOR_GZIP = new CachedDynamicIntProperty("zuul.min.gzip.body.size", 860);
    private static final CachedDynamicBooleanProperty ENABLED = new CachedDynamicBooleanProperty("zuul.response.gzip.filter.enabled", true);

    @Override
    public boolean shouldFilter(HttpResponseMessage response) {
        boolean shouldGzip;
        if (!ENABLED.get() || !response.hasBody() || response.getContext().isInBrownoutMode()) {
            return false;
        }
        if (response.getContext().get("gzipper") != null) {
            return true;
        }
        HttpRequestInfo request = response.getInboundRequest();
        Boolean overrideIsGzipRequested = (Boolean)response.getContext().get("overrideGzipRequested");
        boolean isGzipRequested = overrideIsGzipRequested == null ? HttpUtils.acceptsGzip(request.getHeaders()) : overrideIsGzipRequested;
        Headers respHeaders = response.getHeaders();
        boolean isResponseGzipped = HttpUtils.isGzipped(respHeaders);
        boolean bl = shouldGzip = this.isGzippableContentType(response) && isGzipRequested && !isResponseGzipped && this.isRightSizeForGzip(response);
        if (shouldGzip) {
            response.getContext().set("gzipper", this.getGzipper());
        }
        return shouldGzip;
    }

    protected Gzipper getGzipper() {
        return new Gzipper();
    }

    @VisibleForTesting
    boolean isRightSizeForGzip(HttpResponseMessage response) {
        Integer bodySize = HttpUtils.getBodySizeIfKnown(response);
        return bodySize == null || bodySize >= MIN_BODY_SIZE_FOR_GZIP.get();
    }

    @Override
    public HttpResponseMessage apply(HttpResponseMessage response) {
        Headers respHeaders = response.getHeaders();
        respHeaders.set(HttpHeaderNames.CONTENT_ENCODING, "gzip");
        respHeaders.remove(HttpHeaderNames.CONTENT_LENGTH);
        return response;
    }

    private boolean isGzippableContentType(HttpResponseMessage response) {
        String ct = response.getHeaders().getFirst(HttpHeaderNames.CONTENT_TYPE);
        if (ct != null) {
            int charsetIndex = ct.indexOf(59);
            if (charsetIndex > 0) {
                ct = ct.substring(0, charsetIndex);
            }
            return GZIPPABLE_CONTENT_TYPES.get().contains(ct.toLowerCase());
        }
        return false;
    }

    @Override
    public HttpContent processContentChunk(ZuulMessage resp, HttpContent chunk) {
        Gzipper gzipper = (Gzipper)resp.getContext().get("gzipper");
        gzipper.write(chunk);
        if (chunk instanceof LastHttpContent) {
            gzipper.finish();
            return new DefaultLastHttpContent(gzipper.getByteBuf());
        }
        return new DefaultHttpContent(gzipper.getByteBuf());
    }
}

