/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.filters;

import com.netflix.zuul.Filter;
import com.netflix.zuul.exception.ZuulFilterConcurrencyExceededException;
import com.netflix.zuul.filters.FilterSyncType;
import com.netflix.zuul.filters.FilterType;
import com.netflix.zuul.filters.ShouldFilter;
import com.netflix.zuul.message.ZuulMessage;
import io.netty.handler.codec.http.HttpContent;
import rx.Observable;

public interface ZuulFilter<I extends ZuulMessage, O extends ZuulMessage>
extends ShouldFilter<I> {
    public boolean isDisabled();

    public String filterName();

    default public int filterOrder() {
        Filter f = this.getClass().getAnnotation(Filter.class);
        if (f != null) {
            return f.order();
        }
        throw new UnsupportedOperationException("not implemented");
    }

    default public FilterType filterType() {
        Filter f = this.getClass().getAnnotation(Filter.class);
        if (f != null) {
            return f.type();
        }
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean overrideStopFilterProcessing();

    public void incrementConcurrency() throws ZuulFilterConcurrencyExceededException;

    public Observable<O> applyAsync(I var1);

    public void decrementConcurrency();

    default public FilterSyncType getSyncType() {
        Filter f = this.getClass().getAnnotation(Filter.class);
        if (f != null) {
            return f.sync();
        }
        throw new UnsupportedOperationException("not implemented");
    }

    public O getDefaultOutput(I var1);

    public boolean needsBodyBuffered(I var1);

    public HttpContent processContentChunk(ZuulMessage var1, HttpContent var2);
}

