/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.filters;

import com.netflix.zuul.filters.FilterRegistry;
import com.netflix.zuul.filters.ZuulFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.inject.Singleton;

@Singleton
public final class MutableFilterRegistry
implements FilterRegistry {
    private final ConcurrentHashMap<String, ZuulFilter<?, ?>> filters = new ConcurrentHashMap();

    @Override
    @Nullable
    public ZuulFilter<?, ?> remove(String key) {
        return this.filters.remove(Objects.requireNonNull(key, "key"));
    }

    @Override
    @Nullable
    public ZuulFilter<?, ?> get(String key) {
        return this.filters.get(Objects.requireNonNull(key, "key"));
    }

    @Override
    public void put(String key, ZuulFilter<?, ?> filter) {
        this.filters.putIfAbsent(Objects.requireNonNull(key, "key"), Objects.requireNonNull(filter, "filter"));
    }

    @Override
    public int size() {
        return this.filters.size();
    }

    @Override
    public Collection<ZuulFilter<?, ?>> getAllFilters() {
        return Collections.unmodifiableList(new ArrayList(this.filters.values()));
    }

    @Override
    public boolean isMutable() {
        return true;
    }
}

