/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.filters;

import com.netflix.config.CachedDynamicBooleanProperty;
import com.netflix.config.CachedDynamicIntProperty;
import com.netflix.spectator.api.Counter;
import com.netflix.zuul.exception.ZuulFilterConcurrencyExceededException;
import com.netflix.zuul.filters.FilterSyncType;
import com.netflix.zuul.filters.ZuulFilter;
import com.netflix.zuul.message.ZuulMessage;
import com.netflix.zuul.netty.SpectatorUtils;
import io.netty.handler.codec.http.HttpContent;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BaseFilter<I extends ZuulMessage, O extends ZuulMessage>
implements ZuulFilter<I, O> {
    private final String baseName = this.getClass().getSimpleName() + "." + (Object)((Object)this.filterType());
    private final AtomicInteger concurrentCount = SpectatorUtils.newGauge("zuul.filter.concurrency.current", this.baseName, new AtomicInteger(0));
    private final Counter concurrencyRejections = SpectatorUtils.newCounter("zuul.filter.concurrency.rejected", this.baseName);
    private final CachedDynamicBooleanProperty filterDisabled = new CachedDynamicBooleanProperty(this.disablePropertyName(), false);
    private final CachedDynamicIntProperty filterConcurrencyLimit = new CachedDynamicIntProperty(this.maxConcurrencyPropertyName(), 4000);
    private static final CachedDynamicBooleanProperty concurrencyProtectEnabled = new CachedDynamicBooleanProperty("zuul.filter.concurrency.protect.enabled", true);

    protected BaseFilter() {
    }

    @Override
    public String filterName() {
        return this.getClass().getName();
    }

    @Override
    public boolean overrideStopFilterProcessing() {
        return false;
    }

    public String disablePropertyName() {
        return "zuul." + this.baseName + ".disable";
    }

    public String maxConcurrencyPropertyName() {
        return "zuul." + this.baseName + ".concurrency.limit";
    }

    @Override
    public boolean isDisabled() {
        return this.filterDisabled.get();
    }

    @Override
    public O getDefaultOutput(I input) {
        return (O)input;
    }

    @Override
    public FilterSyncType getSyncType() {
        return FilterSyncType.ASYNC;
    }

    public String toString() {
        return String.valueOf((Object)this.filterType()) + ":" + String.valueOf(this.filterName());
    }

    @Override
    public boolean needsBodyBuffered(I input) {
        return false;
    }

    @Override
    public HttpContent processContentChunk(ZuulMessage zuulMessage, HttpContent chunk) {
        return chunk;
    }

    @Override
    public void incrementConcurrency() throws ZuulFilterConcurrencyExceededException {
        int limit = this.filterConcurrencyLimit.get();
        if (concurrencyProtectEnabled.get() && this.concurrentCount.get() >= limit) {
            this.concurrencyRejections.increment();
            throw new ZuulFilterConcurrencyExceededException(this, limit);
        }
        this.concurrentCount.incrementAndGet();
    }

    @Override
    public void decrementConcurrency() {
        this.concurrentCount.decrementAndGet();
    }
}

