/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.context;

import com.netflix.config.DynamicPropertyFactory;
import com.netflix.zuul.filters.FilterError;
import com.netflix.zuul.message.http.HttpResponseMessage;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SessionContext
extends HashMap<String, Object>
implements Cloneable {
    private static final int INITIAL_SIZE = DynamicPropertyFactory.getInstance().getIntProperty("com.netflix.zuul.context.SessionContext.initialSize", 60).get();
    private boolean brownoutMode = false;
    private boolean shouldStopFilterProcessing = false;
    private boolean shouldSendErrorResponse = false;
    private boolean errorResponseSent = false;
    private boolean debugRouting = false;
    private boolean debugRequest = false;
    private boolean debugRequestHeadersOnly = false;
    private boolean cancelled = false;
    private static final String KEY_UUID = "_uuid";
    private static final String KEY_VIP = "routeVIP";
    private static final String KEY_ENDPOINT = "_endpoint";
    private static final String KEY_STATIC_RESPONSE = "_static_response";
    private static final String KEY_EVENT_PROPS = "eventProperties";
    private static final String KEY_FILTER_ERRORS = "_filter_errors";
    private static final String KEY_FILTER_EXECS = "_filter_executions";

    public SessionContext() {
        super(INITIAL_SIZE);
        this.put(KEY_FILTER_EXECS, new StringBuilder());
        this.put(KEY_EVENT_PROPS, new HashMap());
        this.put(KEY_FILTER_ERRORS, new ArrayList());
    }

    @Override
    public SessionContext clone() {
        return (SessionContext)super.clone();
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultResponse) {
        Boolean b = (Boolean)this.get(key);
        if (b != null) {
            return b;
        }
        return defaultResponse;
    }

    public void set(String key) {
        this.put(key, Boolean.TRUE);
    }

    public void set(String key, Object value) {
        if (value != null) {
            this.put(key, value);
        } else {
            this.remove(key);
        }
    }

    public String getUUID() {
        return this.getString(KEY_UUID);
    }

    public void setUUID(String uuid) {
        this.set(KEY_UUID, uuid);
    }

    public void setStaticResponse(HttpResponseMessage response) {
        this.set(KEY_STATIC_RESPONSE, response);
    }

    public HttpResponseMessage getStaticResponse() {
        return (HttpResponseMessage)this.get(KEY_STATIC_RESPONSE);
    }

    public Throwable getError() {
        return (Throwable)this.get("_error");
    }

    public void setError(Throwable th) {
        this.put("_error", th);
    }

    public String getErrorEndpoint() {
        return (String)this.get("_error-endpoint");
    }

    public void setErrorEndpoint(String name) {
        this.put("_error-endpoint", name);
    }

    public void setDebugRouting(boolean bDebug) {
        this.debugRouting = bDebug;
    }

    public boolean debugRouting() {
        return this.debugRouting;
    }

    public void setDebugRequestHeadersOnly(boolean bHeadersOnly) {
        this.debugRequestHeadersOnly = bHeadersOnly;
    }

    public boolean debugRequestHeadersOnly() {
        return this.debugRequestHeadersOnly;
    }

    public void setDebugRequest(boolean bDebug) {
        this.debugRequest = bDebug;
    }

    public boolean debugRequest() {
        return this.debugRequest;
    }

    public void removeRouteHost() {
        this.remove("routeHost");
    }

    public void setRouteHost(URL routeHost) {
        this.set("routeHost", routeHost);
    }

    public URL getRouteHost() {
        return (URL)this.get("routeHost");
    }

    public void addFilterExecutionSummary(String name, String status, long time) {
        StringBuilder sb = this.getFilterExecutionSummary();
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(name).append('[').append(status).append(']').append('[').append(time).append("ms]");
    }

    public StringBuilder getFilterExecutionSummary() {
        return (StringBuilder)this.get(KEY_FILTER_EXECS);
    }

    public boolean shouldSendErrorResponse() {
        return this.shouldSendErrorResponse;
    }

    public void setShouldSendErrorResponse(boolean should) {
        this.shouldSendErrorResponse = should;
    }

    public boolean errorResponseSent() {
        return this.errorResponseSent;
    }

    public void setErrorResponseSent(boolean should) {
        this.errorResponseSent = should;
    }

    public boolean isInBrownoutMode() {
        return this.brownoutMode;
    }

    public void setInBrownoutMode() {
        this.brownoutMode = true;
    }

    public void stopFilterProcessing() {
        this.shouldStopFilterProcessing = true;
    }

    public boolean shouldStopFilterProcessing() {
        return this.shouldStopFilterProcessing;
    }

    public String getRouteVIP() {
        return (String)this.get(KEY_VIP);
    }

    public void setRouteVIP(String sVip) {
        this.set(KEY_VIP, sVip);
    }

    public void setEndpoint(String endpoint) {
        this.put(KEY_ENDPOINT, endpoint);
    }

    public String getEndpoint() {
        return (String)this.get(KEY_ENDPOINT);
    }

    public void setEventProperty(String key, Object value) {
        this.getEventProperties().put(key, value);
    }

    public Map<String, Object> getEventProperties() {
        return (Map)this.get(KEY_EVENT_PROPS);
    }

    public List<FilterError> getFilterErrors() {
        return (List)this.get(KEY_FILTER_ERRORS);
    }

    public void setOriginReportedDuration(int duration) {
        this.put("_originReportedDuration", duration);
    }

    public int getOriginReportedDuration() {
        Object value = this.get("_originReportedDuration");
        if (value != null) {
            return (Integer)value;
        }
        return -1;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void cancel() {
        this.cancelled = true;
    }
}

