/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.context;

import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.message.Header;
import com.netflix.zuul.message.ZuulMessage;
import com.netflix.zuul.message.http.HttpRequestInfo;
import com.netflix.zuul.message.http.HttpResponseInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class Debug {
    private static final Logger LOG = LoggerFactory.getLogger(Debug.class);

    public static void setDebugRequest(SessionContext ctx, boolean bDebug) {
        ctx.setDebugRequest(bDebug);
    }

    public static void setDebugRequestHeadersOnly(SessionContext ctx, boolean bHeadersOnly) {
        ctx.setDebugRequestHeadersOnly(bHeadersOnly);
    }

    public static boolean debugRequestHeadersOnly(SessionContext ctx) {
        return ctx.debugRequestHeadersOnly();
    }

    public static void setDebugRouting(SessionContext ctx, boolean bDebug) {
        ctx.setDebugRouting(bDebug);
    }

    public static boolean debugRequest(SessionContext ctx) {
        return ctx.debugRequest();
    }

    public static boolean debugRouting(SessionContext ctx) {
        return ctx.debugRouting();
    }

    public static void addRoutingDebug(SessionContext ctx, String line) {
        List<String> rd = Debug.getRoutingDebug(ctx);
        rd.add(line);
    }

    public static void addRequestDebugForMessage(SessionContext ctx, ZuulMessage message, String prefix) {
        for (Header header : message.getHeaders().entries()) {
            Debug.addRequestDebug(ctx, prefix + " " + header.getKey() + " " + header.getValue());
        }
        if (message.hasBody()) {
            String bodyStr = message.getBodyAsText();
            Debug.addRequestDebug(ctx, prefix + " " + bodyStr);
        }
    }

    public static List<String> getRoutingDebug(SessionContext ctx) {
        ArrayList rd = (ArrayList)ctx.get("routingDebug");
        if (rd == null) {
            rd = new ArrayList();
            ctx.set("routingDebug", rd);
        }
        return rd;
    }

    public static void addRequestDebug(SessionContext ctx, String line) {
        List<String> rd = Debug.getRequestDebug(ctx);
        rd.add(line);
    }

    public static List<String> getRequestDebug(SessionContext ctx) {
        ArrayList rd = (ArrayList)ctx.get("requestDebug");
        if (rd == null) {
            rd = new ArrayList();
            ctx.set("requestDebug", rd);
        }
        return rd;
    }

    public static void compareContextState(String filterName, SessionContext context, SessionContext copy) {
        Debug.getRoutingDebug(context);
        Iterator it = context.keySet().iterator();
        String key = (String)it.next();
        while (key != null) {
            if (!key.equals("routingDebug") && !key.equals("requestDebug")) {
                Object newValue = context.get(key);
                Object oldValue = copy.get(key);
                if (oldValue == null && newValue != null) {
                    Debug.addRoutingDebug(context, "{" + filterName + "} added " + key + "=" + newValue.toString());
                } else if (oldValue != null && newValue != null && !oldValue.equals(newValue)) {
                    Debug.addRoutingDebug(context, "{" + filterName + "} changed " + key + "=" + newValue.toString());
                }
            }
            if (it.hasNext()) {
                key = (String)it.next();
                continue;
            }
            key = null;
        }
    }

    public static Observable<Boolean> writeDebugRequest(SessionContext context, HttpRequestInfo request, boolean isInbound) {
        Observable<Boolean> obs = null;
        if (Debug.debugRequest(context)) {
            String prefix = isInbound ? "REQUEST_INBOUND" : "REQUEST_OUTBOUND";
            String arrow = ">";
            Debug.addRequestDebug(context, String.format("%s:: %s LINE: %s %s %s", prefix, arrow, request.getMethod().toUpperCase(), request.getPathAndQuery(), request.getProtocol()));
            obs = Debug.writeDebugMessage(context, request, prefix, arrow);
        }
        if (obs == null) {
            obs = Observable.just((Object)Boolean.FALSE);
        }
        return obs;
    }

    public static Observable<Boolean> writeDebugResponse(SessionContext context, HttpResponseInfo response, boolean isInbound) {
        Observable<Boolean> obs = null;
        if (Debug.debugRequest(context)) {
            String prefix = isInbound ? "RESPONSE_INBOUND" : "RESPONSE_OUTBOUND";
            String arrow = "<";
            Debug.addRequestDebug(context, String.format("%s:: %s STATUS: %s", prefix, arrow, response.getStatus()));
            obs = Debug.writeDebugMessage(context, response, prefix, arrow);
        }
        if (obs == null) {
            obs = Observable.just((Object)Boolean.FALSE);
        }
        return obs;
    }

    public static Observable<Boolean> writeDebugMessage(SessionContext context, ZuulMessage msg, String prefix, String arrow) {
        Observable obs = null;
        for (Header header : msg.getHeaders().entries()) {
            Debug.addRequestDebug(context, String.format("%s:: %s HDR: %s:%s", prefix, arrow, header.getKey(), header.getValue()));
        }
        if (msg.hasBody() && !Debug.debugRequestHeadersOnly(context)) {
            String body = msg.getBodyAsText();
            Debug.addRequestDebug(context, String.format("%s:: %s BODY: %s", prefix, arrow, body));
        }
        if (obs == null) {
            obs = Observable.just((Object)Boolean.FALSE);
        }
        return obs;
    }
}

