/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul;

import com.google.errorprone.annotations.DoNotCall;
import com.netflix.zuul.FilterFactory;
import com.netflix.zuul.FilterLoader;
import com.netflix.zuul.filters.FilterType;
import com.netflix.zuul.filters.ZuulFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StaticFilterLoader
implements FilterLoader {
    private static final Logger logger = LoggerFactory.getLogger(StaticFilterLoader.class);
    public static final String RESOURCE_NAME = "META-INF/zuul/allfilters";
    private final Map<FilterType, ? extends SortedSet<ZuulFilter<?, ?>>> filtersByType;
    private final Map<FilterType, ? extends Map<String, ZuulFilter<?, ?>>> filtersByTypeAndName;

    @Inject
    public StaticFilterLoader(FilterFactory filterFactory, Set<? extends Class<? extends ZuulFilter<?, ?>>> filterTypes) {
        EnumMap<FilterType, SortedSet> filtersByType = new EnumMap<FilterType, SortedSet>(FilterType.class);
        EnumMap<FilterType, Map> filtersByName = new EnumMap<FilterType, Map>(FilterType.class);
        for (Class<ZuulFilter<?, ?>> clazz : filterTypes) {
            try {
                ZuulFilter<?, ?> f = filterFactory.newInstance(clazz);
                filtersByType.computeIfAbsent(f.filterType(), k -> new TreeSet(FILTER_COMPARATOR)).add(f);
                filtersByName.computeIfAbsent(f.filterType(), k -> new HashMap()).put(f.filterName(), f);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        for (Map.Entry entry : filtersByType.entrySet()) {
            entry.setValue(Collections.unmodifiableSortedSet((SortedSet)entry.getValue()));
        }
        EnumMap immutableFiltersByName = new EnumMap(FilterType.class);
        for (Map.Entry entry : filtersByName.entrySet()) {
            immutableFiltersByName.put((FilterType)((Object)entry.getKey()), Collections.unmodifiableMap((Map)entry.getValue()));
        }
        this.filtersByTypeAndName = Collections.unmodifiableMap(immutableFiltersByName);
        this.filtersByType = Collections.unmodifiableMap(filtersByType);
    }

    public static Set<Class<ZuulFilter<?, ?>>> loadFilterTypesFromResources(ClassLoader loader) throws IOException {
        LinkedHashSet<Class<ZuulFilter>> filterTypes = new LinkedHashSet<Class<ZuulFilter>>();
        for (URL url : Collections.list(loader.getResources(RESOURCE_NAME))) {
            InputStream is = url.openStream();
            Throwable throwable = null;
            try {
                InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                Throwable throwable2 = null;
                try {
                    BufferedReader br = new BufferedReader(isr);
                    Throwable throwable3 = null;
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            Class<?> clz;
                            String trimmed = line.trim();
                            if (trimmed.isEmpty()) continue;
                            try {
                                clz = Class.forName(trimmed, false, loader);
                            }
                            catch (ClassNotFoundException e) {
                                logger.warn("Missing Filter", (Throwable)e);
                                continue;
                            }
                            Class<ZuulFilter> filterClz = clz.asSubclass(ZuulFilter.class);
                            filterTypes.add(filterClz);
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (br == null) continue;
                        if (throwable3 != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        br.close();
                    }
                }
                catch (Throwable throwable6) {
                    throwable2 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (isr == null) continue;
                    if (throwable2 != null) {
                        try {
                            isr.close();
                        }
                        catch (Throwable throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    isr.close();
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable9) {
                        throwable.addSuppressed(throwable9);
                    }
                    continue;
                }
                is.close();
            }
        }
        return Collections.unmodifiableSet(filterTypes);
    }

    @Override
    @DoNotCall
    public boolean putFilter(File file) {
        throw new UnsupportedOperationException();
    }

    @Override
    @DoNotCall
    public List<ZuulFilter<?, ?>> putFiltersForClasses(String[] classNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    @DoNotCall
    public ZuulFilter<?, ?> putFilterForClassName(String className) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<ZuulFilter<?, ?>> getFiltersByType(FilterType filterType) {
        return this.filtersByType.get((Object)filterType);
    }

    @Override
    @Nullable
    public ZuulFilter<?, ?> getFilterByNameAndType(String name, FilterType type) {
        Map<String, ZuulFilter<?, ?>> filtersByName = this.filtersByTypeAndName.get((Object)type);
        if (filtersByName == null) {
            return null;
        }
        return filtersByName.get(name);
    }
}

