/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.config.DynamicIntProperty;
import com.netflix.zuul.FilterLoader;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FilterFileManager {
    private static final Logger LOG = LoggerFactory.getLogger(FilterFileManager.class);
    private static final DynamicIntProperty FILE_PROCESSOR_THREADS = new DynamicIntProperty("zuul.filterloader.threads", 1);
    private static final DynamicIntProperty FILE_PROCESSOR_TASKS_TIMEOUT_SECS = new DynamicIntProperty("zuul.filterloader.tasks.timeout", 120);
    Thread poller;
    boolean bRunning = true;
    private final FilterFileManagerConfig config;
    private final FilterLoader filterLoader;
    private final ExecutorService processFilesService;

    @Inject
    public FilterFileManager(FilterFileManagerConfig config, FilterLoader filterLoader) {
        this.config = config;
        this.filterLoader = filterLoader;
        ThreadFactory tf = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("FilterFileManager_ProcessFiles-%d").build();
        this.processFilesService = Executors.newFixedThreadPool(FILE_PROCESSOR_THREADS.get(), tf);
    }

    @Inject
    public void init() throws Exception {
        long startTime = System.currentTimeMillis();
        this.filterLoader.putFiltersForClasses(this.config.getClassNames());
        this.manageFiles();
        this.startPoller();
        LOG.warn("Finished loading all zuul filters. Duration = " + (System.currentTimeMillis() - startTime) + " ms.");
    }

    public void shutdown() {
        this.stopPoller();
    }

    void stopPoller() {
        this.bRunning = false;
    }

    void startPoller() {
        this.poller = new Thread("GroovyFilterFileManagerPoller"){
            {
                this.setDaemon(true);
            }

            @Override
            public void run() {
                while (FilterFileManager.this.bRunning) {
                    try {
                        1.sleep(FilterFileManager.this.config.getPollingIntervalSeconds() * 1000);
                        FilterFileManager.this.manageFiles();
                    }
                    catch (Exception e) {
                        LOG.error("Error checking and/or loading filter files from Poller thread.", (Throwable)e);
                    }
                }
            }
        };
        this.poller.start();
    }

    public File getDirectory(String sPath) {
        File directory = new File(sPath);
        if (!directory.isDirectory()) {
            URL resource = FilterFileManager.class.getClassLoader().getResource(sPath);
            try {
                directory = new File(resource.toURI());
            }
            catch (Exception e) {
                LOG.error("Error accessing directory in classloader. path=" + sPath, (Throwable)e);
            }
            if (!directory.isDirectory()) {
                throw new RuntimeException(directory.getAbsolutePath() + " is not a valid directory");
            }
        }
        return directory;
    }

    List<File> getFiles() {
        ArrayList<File> list = new ArrayList<File>();
        for (String sDirectory : this.config.getDirectories()) {
            File directory;
            File[] aFiles;
            if (sDirectory == null || (aFiles = (directory = this.getDirectory(sDirectory)).listFiles(this.config.getFilenameFilter())) == null) continue;
            list.addAll(Arrays.asList(aFiles));
        }
        return list;
    }

    void processGroovyFiles(List<File> aFiles) throws Exception {
        ArrayList<Callable<Boolean>> tasks = new ArrayList<Callable<Boolean>>();
        for (File file : aFiles) {
            tasks.add(() -> {
                try {
                    return this.filterLoader.putFilter(file);
                }
                catch (Exception e) {
                    LOG.error("Error loading groovy filter from disk! file = " + String.valueOf(file), (Throwable)e);
                    return false;
                }
            });
        }
        this.processFilesService.invokeAll(tasks, FILE_PROCESSOR_TASKS_TIMEOUT_SECS.get(), TimeUnit.SECONDS);
    }

    void manageFiles() {
        try {
            List<File> aFiles = this.getFiles();
            this.processGroovyFiles(aFiles);
        }
        catch (Exception e) {
            String msg = "Error updating groovy filters from disk!";
            LOG.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    public static class FilterFileManagerConfig {
        private String[] directories;
        private String[] classNames;
        private int pollingIntervalSeconds;
        private FilenameFilter filenameFilter;

        public FilterFileManagerConfig(String[] directories, String[] classNames, int pollingIntervalSeconds, FilenameFilter filenameFilter) {
            this.directories = directories;
            this.classNames = classNames;
            this.pollingIntervalSeconds = pollingIntervalSeconds;
            this.filenameFilter = filenameFilter;
        }

        public String[] getDirectories() {
            return this.directories;
        }

        public String[] getClassNames() {
            return this.classNames;
        }

        public int getPollingIntervalSeconds() {
            return this.pollingIntervalSeconds;
        }

        public FilenameFilter getFilenameFilter() {
            return this.filenameFilter;
        }
    }
}

