/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul;

import com.netflix.zuul.DynamicCodeCompiler;
import com.netflix.zuul.FilterFactory;
import com.netflix.zuul.FilterLoader;
import com.netflix.zuul.filters.FilterRegistry;
import com.netflix.zuul.filters.FilterType;
import com.netflix.zuul.filters.ZuulFilter;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class DynamicFilterLoader
implements FilterLoader {
    private static final Logger LOG = LoggerFactory.getLogger(FilterLoader.class);
    private final ConcurrentMap<String, Long> filterClassLastModified = new ConcurrentHashMap<String, Long>();
    private final ConcurrentMap<String, String> filterClassCode = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, String> filterCheck = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<FilterType, SortedSet<ZuulFilter<?, ?>>> hashFiltersByType = new ConcurrentHashMap();
    private final ConcurrentMap<String, ZuulFilter<?, ?>> filtersByNameAndType = new ConcurrentHashMap();
    private final FilterRegistry filterRegistry;
    private final DynamicCodeCompiler compiler;
    private final FilterFactory filterFactory;

    @Inject
    public DynamicFilterLoader(FilterRegistry filterRegistry, DynamicCodeCompiler compiler, FilterFactory filterFactory) {
        this.filterRegistry = filterRegistry;
        this.compiler = compiler;
        this.filterFactory = filterFactory;
    }

    @Deprecated
    public ZuulFilter<?, ?> getFilter(String sourceCode, String filterName) throws Exception {
        Class<?> clazz;
        ZuulFilter<?, ?> filter;
        if (this.filterCheck.get(filterName) == null) {
            this.filterCheck.putIfAbsent(filterName, filterName);
            if (!sourceCode.equals(this.filterClassCode.get(filterName))) {
                if (this.filterRegistry.isMutable()) {
                    LOG.info("reloading code {}", (Object)filterName);
                    this.filterRegistry.remove(filterName);
                } else {
                    LOG.warn("Filter registry is not mutable, discarding {}", (Object)filterName);
                }
            }
        }
        if ((filter = this.filterRegistry.get(filterName)) == null && !Modifier.isAbstract((clazz = this.compiler.compile(sourceCode, filterName)).getModifiers())) {
            filter = this.filterFactory.newInstance(clazz);
        }
        return filter;
    }

    public int filterInstanceMapSize() {
        return this.filterRegistry.size();
    }

    @Override
    public boolean putFilter(File file) {
        if (!this.filterRegistry.isMutable()) {
            return false;
        }
        try {
            Class<?> clazz;
            ZuulFilter<?, ?> filter;
            String sName = file.getAbsolutePath();
            if (this.filterClassLastModified.get(sName) != null && file.lastModified() != ((Long)this.filterClassLastModified.get(sName)).longValue()) {
                LOG.debug("reloading filter " + sName);
                this.filterRegistry.remove(sName);
            }
            if ((filter = this.filterRegistry.get(sName)) == null && !Modifier.isAbstract((clazz = this.compiler.compile(file)).getModifiers())) {
                filter = this.filterFactory.newInstance(clazz);
                this.putFilter(sName, filter, file.lastModified());
                return true;
            }
        }
        catch (Exception e) {
            LOG.error("Error loading filter! Continuing. file=" + file, (Throwable)e);
            return false;
        }
        return false;
    }

    private void putFilter(String filterName, ZuulFilter<?, ?> filter, long lastModified) {
        if (!this.filterRegistry.isMutable()) {
            LOG.warn("Filter registry is not mutable, discarding {}", (Object)filterName);
            return;
        }
        SortedSet set = (SortedSet)this.hashFiltersByType.get((Object)filter.filterType());
        if (set != null) {
            this.hashFiltersByType.remove((Object)filter.filterType());
        }
        String nameAndType = (Object)((Object)filter.filterType()) + ":" + filter.filterName();
        this.filtersByNameAndType.put(nameAndType, filter);
        this.filterRegistry.put(filterName, filter);
        this.filterClassLastModified.put(filterName, lastModified);
    }

    @Override
    public List<ZuulFilter<?, ?>> putFiltersForClasses(String[] classNames) throws Exception {
        ArrayList newFilters = new ArrayList();
        for (String className : classNames) {
            newFilters.add(this.putFilterForClassName(className));
        }
        return Collections.unmodifiableList(newFilters);
    }

    @Override
    public ZuulFilter<?, ?> putFilterForClassName(String className) throws Exception {
        Class<?> clazz = Class.forName(className);
        if (!ZuulFilter.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Specified filter class does not implement ZuulFilter interface!");
        }
        ZuulFilter<?, ?> filter = this.filterFactory.newInstance(clazz);
        this.putFilter(className, filter, System.currentTimeMillis());
        return filter;
    }

    @Override
    public SortedSet<ZuulFilter<?, ?>> getFiltersByType(FilterType filterType) {
        TreeSet set = (TreeSet)this.hashFiltersByType.get((Object)filterType);
        if (set != null) {
            return set;
        }
        set = new TreeSet(FILTER_COMPARATOR);
        for (ZuulFilter<?, ?> filter : this.filterRegistry.getAllFilters()) {
            if (!filter.filterType().equals((Object)filterType)) continue;
            set.add(filter);
        }
        this.hashFiltersByType.putIfAbsent(filterType, set);
        return Collections.unmodifiableSortedSet(set);
    }

    @Override
    public ZuulFilter<?, ?> getFilterByNameAndType(String name, FilterType type) {
        if (name == null || type == null) {
            return null;
        }
        String nameAndType = (Object)((Object)type) + ":" + name;
        return (ZuulFilter)this.filtersByNameAndType.get(nameAndType);
    }
}

