/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public final class Attrs {
    final Map<Key<?>, Object> storage = new IdentityHashMap();

    public static <T> Key<T> newKey(String keyName) {
        return new Key(keyName);
    }

    private Attrs() {
    }

    public static Attrs newInstance() {
        return new Attrs();
    }

    public Set<Key<?>> keySet() {
        return Collections.unmodifiableSet(new LinkedHashSet(this.storage.keySet()));
    }

    public void forEach(BiConsumer<? super Key<?>, Object> consumer) {
        this.storage.forEach(consumer);
    }

    public int size() {
        return this.storage.size();
    }

    public String toString() {
        return "Attrs{" + this.storage + '}';
    }

    @VisibleForTesting
    public boolean equals(Object other) {
        if (!(other instanceof Attrs)) {
            return false;
        }
        Attrs that = (Attrs)other;
        return Objects.equals(this.storage, that.storage);
    }

    @VisibleForTesting
    public int hashCode() {
        return Objects.hash(this.storage);
    }

    public static final class Key<T> {
        private final String name;

        @Nullable
        public T get(Attrs attrs) {
            Objects.requireNonNull(attrs, "attrs");
            return (T)attrs.storage.get(this);
        }

        public T getOrDefault(Attrs attrs, T defaultValue) {
            Objects.requireNonNull(attrs, "attrs");
            Objects.requireNonNull(defaultValue, "defaultValue");
            Object result = attrs.storage.get(this);
            if (result != null) {
                return (T)result;
            }
            return defaultValue;
        }

        public void put(Attrs attrs, T value) {
            Objects.requireNonNull(attrs, "attrs");
            Objects.requireNonNull(value);
            attrs.storage.put(this, value);
        }

        public String name() {
            return this.name;
        }

        private Key(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public String toString() {
            return "Key{" + this.name + '}';
        }
    }
}

