/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.throttle;

import com.netflix.netty.common.ConnectionCloseChannelAttributes;
import com.netflix.netty.common.proxyprotocol.HAProxyMessageChannelHandler;
import com.netflix.netty.common.throttle.RejectionType;
import com.netflix.netty.common.throttle.RequestRejectedEvent;
import com.netflix.zuul.passport.CurrentPassport;
import com.netflix.zuul.passport.PassportState;
import com.netflix.zuul.stats.status.StatusCategory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class RejectionUtils {
    public static final HttpResponseStatus REJECT_CLOSING_STATUS = new HttpResponseStatus(999, "Closing(Rejection)");

    public static void rejectByClosingConnection(ChannelHandlerContext ctx, StatusCategory nfStatus, String reason, HttpRequest request, @Nullable Integer injectedLatencyMillis) {
        if (injectedLatencyMillis != null && injectedLatencyMillis > 0) {
            ctx.executor().schedule(() -> {
                CurrentPassport.fromChannel(ctx.channel()).add(PassportState.SERVER_CH_REJECTING);
                ctx.close();
            }, (long)injectedLatencyMillis.intValue(), TimeUnit.MILLISECONDS);
        } else {
            CurrentPassport.fromChannel(ctx.channel()).add(PassportState.SERVER_CH_REJECTING);
            ctx.close();
        }
        RejectionUtils.notifyHandlers(ctx, nfStatus, REJECT_CLOSING_STATUS, reason, request);
    }

    public static void sendRejectionResponse(ChannelHandlerContext ctx, StatusCategory nfStatus, String reason, HttpRequest request, @Nullable Integer injectedLatencyMillis, HttpResponseStatus rejectedCode, String rejectedBody, Map<String, String> rejectionHeaders) {
        boolean shouldClose = RejectionUtils.closeConnectionAfterReject(ctx.channel());
        FullHttpResponse response = RejectionUtils.createRejectionResponse(rejectedCode, rejectedBody, shouldClose, rejectionHeaders);
        if (injectedLatencyMillis != null && injectedLatencyMillis > 0) {
            ctx.executor().schedule(() -> {
                CurrentPassport.fromChannel(ctx.channel()).add(PassportState.IN_REQ_REJECTED);
                ctx.writeAndFlush((Object)response);
            }, (long)injectedLatencyMillis.intValue(), TimeUnit.MILLISECONDS);
        } else {
            CurrentPassport.fromChannel(ctx.channel()).add(PassportState.IN_REQ_REJECTED);
            ctx.writeAndFlush((Object)response);
        }
        RejectionUtils.notifyHandlers(ctx, nfStatus, rejectedCode, reason, request);
    }

    public static void allowThenClose(ChannelHandlerContext ctx) {
        ctx.channel().attr(ConnectionCloseChannelAttributes.CLOSE_AFTER_RESPONSE).set((Object)ctx.newPromise());
    }

    public static void handleRejection(ChannelHandlerContext ctx, Object msg, RejectionType rejectionType, StatusCategory nfStatus, String reason, @Nullable Integer injectedLatencyMillis, HttpResponseStatus rejectedCode, String rejectedBody, Map<String, String> rejectionHeaders) throws Exception {
        boolean shouldDropMessage = false;
        if (rejectionType == RejectionType.REJECT || rejectionType == RejectionType.CLOSE) {
            shouldDropMessage = true;
        }
        boolean shouldRejectNow = false;
        if (rejectionType == RejectionType.REJECT && msg instanceof LastHttpContent) {
            shouldRejectNow = true;
        } else if (rejectionType == RejectionType.CLOSE && msg instanceof HttpRequest) {
            shouldRejectNow = true;
        } else if (rejectionType == RejectionType.ALLOW_THEN_CLOSE && msg instanceof HttpRequest) {
            shouldRejectNow = true;
        }
        if (shouldRejectNow) {
            HttpRequest request = msg instanceof HttpRequest ? (HttpRequest)msg : null;
            RejectionUtils.reject(ctx, rejectionType, nfStatus, reason, request, injectedLatencyMillis, rejectedCode, rejectedBody, rejectionHeaders);
        }
        if (shouldDropMessage) {
            ReferenceCountUtil.safeRelease((Object)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public static void reject(ChannelHandlerContext ctx, RejectionType rejectionType, StatusCategory nfStatus, String reason, HttpRequest request, @Nullable Integer injectedLatencyMillis, HttpResponseStatus rejectedCode, String rejectedBody) {
        RejectionUtils.reject(ctx, rejectionType, nfStatus, reason, request, injectedLatencyMillis, rejectedCode, rejectedBody, Collections.emptyMap());
    }

    public static void reject(ChannelHandlerContext ctx, RejectionType rejectionType, StatusCategory nfStatus, String reason, HttpRequest request, @Nullable Integer injectedLatencyMillis, HttpResponseStatus rejectedCode, String rejectedBody, Map<String, String> rejectionHeaders) {
        switch (rejectionType) {
            case REJECT: {
                RejectionUtils.sendRejectionResponse(ctx, nfStatus, reason, request, injectedLatencyMillis, rejectedCode, rejectedBody, rejectionHeaders);
                return;
            }
            case CLOSE: {
                RejectionUtils.rejectByClosingConnection(ctx, nfStatus, reason, request, injectedLatencyMillis);
                return;
            }
            case ALLOW_THEN_CLOSE: {
                RejectionUtils.allowThenClose(ctx);
                return;
            }
        }
        throw new AssertionError((Object)("Bad rejection type: " + (Object)((Object)rejectionType)));
    }

    private static void notifyHandlers(ChannelHandlerContext ctx, StatusCategory nfStatus, HttpResponseStatus status, String reason, HttpRequest request) {
        RequestRejectedEvent event = new RequestRejectedEvent(request, nfStatus, status, reason);
        ctx.pipeline().fireUserEventTriggered((Object)event);
    }

    private static boolean closeConnectionAfterReject(Channel channel) {
        if (channel.hasAttr(HAProxyMessageChannelHandler.ATTR_HAPROXY_VERSION)) {
            return HAProxyProtocolVersion.V2 == channel.attr(HAProxyMessageChannelHandler.ATTR_HAPROXY_VERSION).get();
        }
        return false;
    }

    private static FullHttpResponse createRejectionResponse(HttpResponseStatus status, String plaintextMessage, boolean closeConnection, Map<String, String> rejectionHeaders) {
        ByteBuf body = Unpooled.wrappedBuffer((byte[])plaintextMessage.getBytes(StandardCharsets.UTF_8));
        int length = body.readableBytes();
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=utf-8");
        headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)length);
        if (closeConnection) {
            headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        }
        rejectionHeaders.forEach((arg_0, arg_1) -> ((DefaultHttpHeaders)headers).add(arg_0, arg_1));
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, body, (HttpHeaders)headers, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
    }

    private RejectionUtils() {
    }
}

