/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.throttle;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.zuul.passport.CurrentPassport;
import com.netflix.zuul.passport.PassportState;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MaxInboundConnectionsHandler
extends ChannelInboundHandlerAdapter {
    public static final AttributeKey<Boolean> ATTR_CH_THROTTLED = AttributeKey.newInstance((String)"_channel_throttled");
    private static final Logger LOG = LoggerFactory.getLogger(MaxInboundConnectionsHandler.class);
    private static final AtomicInteger connections = new AtomicInteger(0);
    private final Counter connectionThrottled;
    private final int maxConnections;

    public MaxInboundConnectionsHandler(Registry registry, String metricId, int maxConnections) {
        this.maxConnections = maxConnections;
        this.connectionThrottled = registry.counter("server.connections.throttled", new String[]{"id", metricId});
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        int currentCount;
        if (this.maxConnections > 0 && (currentCount = connections.getAndIncrement()) + 1 > this.maxConnections) {
            LOG.warn("Throttling incoming connection as above configured max connections threshold of " + this.maxConnections);
            Channel channel = ctx.channel();
            channel.attr(ATTR_CH_THROTTLED).set((Object)Boolean.TRUE);
            CurrentPassport.fromChannel(channel).add(PassportState.SERVER_CH_THROTTLING);
            channel.close();
            this.connectionThrottled.increment();
        }
        super.channelActive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (ctx.channel().attr(ATTR_CH_THROTTLED).get() == null) {
            super.channelRead(ctx, msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.maxConnections > 0) {
            connections.decrementAndGet();
        }
        super.channelInactive(ctx);
    }
}

