/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.proxyprotocol;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.InetAddresses;
import com.netflix.netty.common.SourceAddressChannelHandler;
import com.netflix.zuul.Attrs;
import com.netflix.zuul.netty.server.Server;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;

public final class HAProxyMessageChannelHandler
extends ChannelInboundHandlerAdapter {
    public static final AttributeKey<HAProxyMessage> ATTR_HAPROXY_MESSAGE = AttributeKey.newInstance((String)"_haproxy_message");
    public static final AttributeKey<HAProxyProtocolVersion> ATTR_HAPROXY_VERSION = AttributeKey.newInstance((String)"_haproxy_version");
    @VisibleForTesting
    static final Attrs.Key<Integer> HAPM_DEST_PORT = Attrs.newKey("hapm_port");

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HAProxyMessage) {
            String sourceAddress;
            HAProxyMessage hapm = (HAProxyMessage)msg;
            Channel channel = ctx.channel();
            channel.attr(ATTR_HAPROXY_MESSAGE).set((Object)hapm);
            ctx.channel().closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)future -> hapm.release()));
            channel.attr(ATTR_HAPROXY_VERSION).set((Object)hapm.protocolVersion());
            String destinationAddress = hapm.destinationAddress();
            if (destinationAddress != null) {
                InetSocketAddress addr;
                channel.attr(SourceAddressChannelHandler.ATTR_LOCAL_ADDRESS).set((Object)destinationAddress);
                switch (hapm.proxiedProtocol()) {
                    case UNKNOWN: {
                        throw new IllegalArgumentException("unknown proxy protocl" + destinationAddress);
                    }
                    case TCP4: 
                    case TCP6: {
                        InetSocketAddress inetAddr;
                        addr = inetAddr = new InetSocketAddress(InetAddresses.forString((String)destinationAddress), hapm.destinationPort());
                        channel.attr(SourceAddressChannelHandler.ATTR_PROXY_PROTOCOL_DESTINATION_ADDRESS).set((Object)inetAddr);
                        Attrs attrs = (Attrs)ctx.channel().attr(Server.CONN_DIMENSIONS).get();
                        HAPM_DEST_PORT.put(attrs, hapm.destinationPort());
                        break;
                    }
                    case UNIX_STREAM: 
                    case UDP4: 
                    case UDP6: 
                    case UNIX_DGRAM: {
                        throw new IllegalArgumentException("unknown proxy protocol" + destinationAddress);
                    }
                    default: {
                        throw new AssertionError(hapm.proxiedProtocol());
                    }
                }
                channel.attr(SourceAddressChannelHandler.ATTR_LOCAL_ADDR).set((Object)addr);
            }
            if ((sourceAddress = hapm.sourceAddress()) != null) {
                InetSocketAddress addr;
                channel.attr(SourceAddressChannelHandler.ATTR_SOURCE_ADDRESS).set((Object)sourceAddress);
                switch (hapm.proxiedProtocol()) {
                    case UNKNOWN: {
                        throw new IllegalArgumentException("unknown proxy protocl" + sourceAddress);
                    }
                    case TCP4: 
                    case TCP6: {
                        addr = new InetSocketAddress(InetAddresses.forString((String)sourceAddress), hapm.sourcePort());
                        break;
                    }
                    case UNIX_STREAM: 
                    case UDP4: 
                    case UDP6: 
                    case UNIX_DGRAM: {
                        throw new IllegalArgumentException("unknown proxy protocol" + sourceAddress);
                    }
                    default: {
                        throw new AssertionError(hapm.proxiedProtocol());
                    }
                }
                channel.attr(SourceAddressChannelHandler.ATTR_REMOTE_ADDR).set((Object)addr);
            }
            ctx.pipeline().remove((ChannelHandler)this);
            return;
        }
    }
}

