/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.proxyprotocol;

import com.google.common.base.Preconditions;
import com.netflix.netty.common.proxyprotocol.HAProxyMessageChannelHandler;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ProtocolDetectionState;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;

public final class ElbProxyProtocolChannelHandler
extends ChannelInboundHandlerAdapter {
    public static final String NAME = ElbProxyProtocolChannelHandler.class.getSimpleName();
    private final boolean withProxyProtocol;
    private final Registry spectatorRegistry;
    private final Counter hapmDecodeFailure;

    public ElbProxyProtocolChannelHandler(Registry registry, boolean withProxyProtocol) {
        this.withProxyProtocol = withProxyProtocol;
        this.spectatorRegistry = (Registry)Preconditions.checkNotNull((Object)registry);
        this.hapmDecodeFailure = this.spectatorRegistry.counter("zuul.hapm.failure");
    }

    public void addProxyProtocol(ChannelPipeline pipeline) {
        pipeline.addLast(NAME, (ChannelHandler)this);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.withProxyProtocol && this.isHAPMDetected(msg)) {
            ctx.pipeline().addAfter(NAME, null, (ChannelHandler)new HAProxyMessageChannelHandler()).replace((ChannelHandler)this, null, (ChannelHandler)new HAProxyMessageDecoder());
        } else {
            if (this.withProxyProtocol) {
                this.hapmDecodeFailure.increment();
            }
            ctx.pipeline().remove((ChannelHandler)this);
        }
        super.channelRead(ctx, msg);
    }

    private boolean isHAPMDetected(Object msg) {
        return HAProxyMessageDecoder.detectProtocol((ByteBuf)((ByteBuf)msg)).state() == ProtocolDetectionState.DETECTED;
    }
}

