/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.zuul.netty.SpectatorUtils;
import io.netty.util.ResourceLeakDetector;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class InstrumentedResourceLeakDetector<T>
extends ResourceLeakDetector<T> {
    private final AtomicInteger instancesLeakCounter;
    @VisibleForTesting
    final AtomicInteger leakCounter;

    public InstrumentedResourceLeakDetector(Class<?> resourceType, int samplingInterval) {
        super(resourceType, samplingInterval);
        this.instancesLeakCounter = SpectatorUtils.newGauge("NettyLeakDetector_instances", resourceType.getSimpleName(), new AtomicInteger());
        this.leakCounter = SpectatorUtils.newGauge("NettyLeakDetector", resourceType.getSimpleName(), new AtomicInteger());
    }

    public InstrumentedResourceLeakDetector(Class<?> resourceType, int samplingInterval, long maxActive) {
        this(resourceType, samplingInterval);
    }

    protected void reportTracedLeak(String resourceType, String records) {
        super.reportTracedLeak(resourceType, records);
        this.leakCounter.incrementAndGet();
        this.resetReportedLeaks();
    }

    protected void reportUntracedLeak(String resourceType) {
        super.reportUntracedLeak(resourceType);
        this.leakCounter.incrementAndGet();
        this.resetReportedLeaks();
    }

    private void resetReportedLeaks() {
        try {
            Field reportedLeaks = ResourceLeakDetector.class.getDeclaredField("reportedLeaks");
            reportedLeaks.setAccessible(true);
            Object f = reportedLeaks.get((Object)this);
            if (f instanceof Map) {
                ((Map)f).clear();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

