/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.metrics;

import com.netflix.netty.common.HttpLifecycleChannelHandler;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Registry;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;
import java.util.concurrent.atomic.AtomicInteger;

@ChannelHandler.Sharable
public class HttpMetricsChannelHandler
extends ChannelInboundHandlerAdapter {
    private static final AttributeKey<Object> ATTR_REQ_INFLIGHT = AttributeKey.newInstance((String)"_httpmetrics_inflight");
    private static final Object INFLIGHT = "is_inflight";
    private static final AttributeKey<AtomicInteger> ATTR_CURRENT_REQS = AttributeKey.newInstance((String)"_server_http_current_count");
    private final AtomicInteger currentRequests = new AtomicInteger(0);
    private final Registry registry;
    private final Gauge currentRequestsGauge;
    private final Counter unSupportedPipeliningCounter;

    public HttpMetricsChannelHandler(Registry registry, String name, String id) {
        this.registry = registry;
        this.currentRequestsGauge = this.registry.gauge(this.registry.createId(name + ".http.requests.current", new String[]{"id", id}));
        this.unSupportedPipeliningCounter = this.registry.counter(name + ".http.requests.pipelining.dropped", new String[]{"id", id});
    }

    public static int getInflightRequestCountFromChannel(Channel ch) {
        AtomicInteger current = (AtomicInteger)ch.attr(ATTR_CURRENT_REQS).get();
        return current == null ? 0 : current.get();
    }

    public int getInflightRequestsCount() {
        return this.currentRequests.get();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().attr(ATTR_CURRENT_REQS).set((Object)this.currentRequests);
        super.channelActive(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpLifecycleChannelHandler.StartEvent) {
            this.incrementCurrentRequestsInFlight(ctx);
        } else if (evt instanceof HttpLifecycleChannelHandler.CompleteEvent && ((HttpLifecycleChannelHandler.CompleteEvent)evt).getReason() == HttpLifecycleChannelHandler.CompleteReason.PIPELINE_REJECT) {
            this.unSupportedPipeliningCounter.increment();
        } else if (evt instanceof HttpLifecycleChannelHandler.CompleteEvent) {
            this.decrementCurrentRequestsIfOneInflight(ctx);
        }
        super.userEventTriggered(ctx, evt);
    }

    private void incrementCurrentRequestsInFlight(ChannelHandlerContext ctx) {
        this.currentRequestsGauge.set((double)this.currentRequests.incrementAndGet());
        ctx.channel().attr(ATTR_REQ_INFLIGHT).set(INFLIGHT);
    }

    private void decrementCurrentRequestsIfOneInflight(ChannelHandlerContext ctx) {
        if (ctx.channel().attr(ATTR_REQ_INFLIGHT).getAndSet(null) != null) {
            this.currentRequestsGauge.set((double)this.currentRequests.decrementAndGet());
        }
    }
}

