/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common;

import com.netflix.spectator.api.Registry;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.unix.Errors;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class SwallowSomeHttp2ExceptionsHandler
extends ChannelOutboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SwallowSomeHttp2ExceptionsHandler.class);
    private final Registry registry;

    public SwallowSomeHttp2ExceptionsHandler(Registry registry) {
        this.registry = registry;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.incrementExceptionCounter(cause);
        if (cause instanceof Http2Exception) {
            Http2Exception h2e = (Http2Exception)cause;
            if (h2e.error() == Http2Error.NO_ERROR && Http2Exception.ShutdownHint.GRACEFUL_SHUTDOWN.equals((Object)h2e.shutdownHint())) {
                LOG.debug("Swallowed Http2Exception.ShutdownHint.GRACEFUL_SHUTDOWN ", cause);
            } else {
                super.exceptionCaught(ctx, cause);
            }
        } else if (cause instanceof Errors.NativeIoException) {
            LOG.debug("Swallowed NativeIoException", cause);
        } else {
            super.exceptionCaught(ctx, cause);
        }
    }

    private void incrementExceptionCounter(Throwable throwable) {
        this.registry.counter("server.connection.pipeline.exception", new String[]{"id", throwable.getClass().getSimpleName()}).increment();
    }
}

