/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common;

import com.google.common.annotations.VisibleForTesting;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import javax.annotation.Nullable;

@ChannelHandler.Sharable
public final class SourceAddressChannelHandler
extends ChannelInboundHandlerAdapter {
    public static final AttributeKey<SocketAddress> ATTR_REMOTE_ADDR = AttributeKey.newInstance((String)"_remote_addr");
    public static final AttributeKey<InetSocketAddress> ATTR_PROXY_PROTOCOL_DESTINATION_ADDRESS = AttributeKey.newInstance((String)"_proxy_protocol_destination_address");
    @Deprecated
    public static final AttributeKey<InetSocketAddress> ATTR_SOURCE_INET_ADDR = AttributeKey.newInstance((String)"_source_inet_addr");
    public static final AttributeKey<String> ATTR_SOURCE_ADDRESS = AttributeKey.newInstance((String)"_source_address");
    public static final AttributeKey<SocketAddress> ATTR_LOCAL_ADDR = AttributeKey.newInstance((String)"_local_addr");
    @Deprecated
    public static final AttributeKey<InetSocketAddress> ATTR_LOCAL_INET_ADDR = AttributeKey.newInstance((String)"_local_inet_addr");
    public static final AttributeKey<String> ATTR_LOCAL_ADDRESS = AttributeKey.newInstance((String)"_local_address");
    @Deprecated
    public static final AttributeKey<String> ATTR_SERVER_LOCAL_ADDRESS = AttributeKey.newInstance((String)"_server_local_address");
    @Deprecated
    public static final AttributeKey<Integer> ATTR_SERVER_LOCAL_PORT = AttributeKey.newInstance((String)"_server_local_port");

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().attr(ATTR_REMOTE_ADDR).set((Object)ctx.channel().remoteAddress());
        InetSocketAddress sourceAddress = this.sourceAddress(ctx.channel());
        ctx.channel().attr(ATTR_SOURCE_INET_ADDR).setIfAbsent((Object)sourceAddress);
        ctx.channel().attr(ATTR_SOURCE_ADDRESS).setIfAbsent((Object)SourceAddressChannelHandler.getHostAddress(sourceAddress));
        ctx.channel().attr(ATTR_LOCAL_ADDR).set((Object)ctx.channel().localAddress());
        InetSocketAddress localAddress = this.localAddress(ctx.channel());
        ctx.channel().attr(ATTR_LOCAL_INET_ADDR).setIfAbsent((Object)localAddress);
        ctx.channel().attr(ATTR_LOCAL_ADDRESS).setIfAbsent((Object)SourceAddressChannelHandler.getHostAddress(localAddress));
        ctx.channel().attr(ATTR_SERVER_LOCAL_ADDRESS).setIfAbsent((Object)localAddress.getAddress().getHostAddress());
        ctx.channel().attr(ATTR_SERVER_LOCAL_PORT).setIfAbsent((Object)localAddress.getPort());
        super.channelActive(ctx);
    }

    @Nullable
    @VisibleForTesting
    static String getHostAddress(InetSocketAddress socketAddress) {
        InetAddress address = socketAddress.getAddress();
        if (address instanceof Inet6Address) {
            try {
                return InetAddress.getByAddress(address.getAddress()).getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        if (address instanceof Inet4Address) {
            return address.getHostAddress();
        }
        assert (address == null);
        return null;
    }

    private InetSocketAddress sourceAddress(Channel channel) {
        InetSocketAddress inetSocketAddress;
        SocketAddress remoteSocketAddr = channel.remoteAddress();
        if (null != remoteSocketAddr && InetSocketAddress.class.isAssignableFrom(remoteSocketAddr.getClass()) && (inetSocketAddress = (InetSocketAddress)remoteSocketAddr).getAddress() != null) {
            return inetSocketAddress;
        }
        return null;
    }

    private InetSocketAddress localAddress(Channel channel) {
        InetSocketAddress inetSocketAddress;
        SocketAddress localSocketAddress = channel.localAddress();
        if (null != localSocketAddress && InetSocketAddress.class.isAssignableFrom(localSocketAddress.getClass()) && (inetSocketAddress = (InetSocketAddress)localSocketAddress).getAddress() != null) {
            return inetSocketAddress;
        }
        return null;
    }
}

