/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.zuul.passport.CurrentPassport;
import com.netflix.zuul.passport.PassportState;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpLifecycleChannelHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpLifecycleChannelHandler.class);
    public static final AttributeKey<HttpRequest> ATTR_HTTP_REQ = AttributeKey.newInstance((String)"_http_request");
    public static final AttributeKey<HttpResponse> ATTR_HTTP_RESP = AttributeKey.newInstance((String)"_http_response");
    public static final AttributeKey<Boolean> ATTR_HTTP_PIPELINE_REJECT = AttributeKey.newInstance((String)"_http_pipeline_reject");
    @VisibleForTesting
    protected static final AttributeKey<State> ATTR_STATE = AttributeKey.newInstance((String)"_httplifecycle_state");

    protected static boolean fireStartEvent(ChannelHandlerContext ctx, HttpRequest request) {
        Channel channel = ctx.channel();
        Attribute attr = channel.attr(ATTR_STATE);
        State state = (State)((Object)attr.get());
        if (state == State.STARTED) {
            LOG.error("Received a http request on connection where we already have a request being processed. Closing the connection now. channel = " + channel.id().asLongText());
            channel.attr(ATTR_HTTP_PIPELINE_REJECT).set((Object)Boolean.TRUE);
            channel.close();
            return false;
        }
        channel.attr(ATTR_STATE).set((Object)State.STARTED);
        channel.attr(ATTR_HTTP_REQ).set((Object)request);
        ctx.pipeline().fireUserEventTriggered((Object)new StartEvent(request));
        return true;
    }

    protected static boolean fireCompleteEventIfNotAlready(ChannelHandlerContext ctx, CompleteReason reason) {
        Attribute attr = ctx.channel().attr(ATTR_STATE);
        State state = (State)((Object)attr.get());
        if (state == null || state != State.STARTED) {
            return false;
        }
        attr.set((Object)State.COMPLETED);
        HttpRequest request = (HttpRequest)ctx.channel().attr(ATTR_HTTP_REQ).get();
        HttpResponse response = (HttpResponse)ctx.channel().attr(ATTR_HTTP_RESP).get();
        ctx.channel().attr(ATTR_HTTP_REQ).set(null);
        ctx.channel().attr(ATTR_HTTP_RESP).set(null);
        ctx.pipeline().fireUserEventTriggered((Object)new CompleteEvent(reason, request, response));
        return true;
    }

    protected static void addPassportState(ChannelHandlerContext ctx, PassportState state) {
        CurrentPassport passport = CurrentPassport.fromChannel(ctx.channel());
        passport.add(state);
    }

    public static class CompleteEvent {
        private final CompleteReason reason;
        private final HttpRequest request;
        private final HttpResponse response;

        public CompleteEvent(CompleteReason reason, HttpRequest request, HttpResponse response) {
            this.reason = reason;
            this.request = request;
            this.response = response;
        }

        public CompleteReason getReason() {
            return this.reason;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public HttpResponse getResponse() {
            return this.response;
        }
    }

    public static class StartEvent {
        private final HttpRequest request;

        public StartEvent(HttpRequest request) {
            this.request = request;
        }

        public HttpRequest getRequest() {
            return this.request;
        }
    }

    public static enum CompleteReason {
        SESSION_COMPLETE,
        INACTIVE,
        DISCONNECT,
        DEREGISTER,
        PIPELINE_REJECT,
        EXCEPTION,
        CLOSE;

    }

    protected static enum State {
        STARTED,
        COMPLETED;

    }
}

