/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common;

import com.netflix.netty.common.HttpLifecycleChannelHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;

public class HttpClientLifecycleChannelHandler
extends HttpLifecycleChannelHandler {
    public static final ChannelHandler INBOUND_CHANNEL_HANDLER = new HttpClientLifecycleInboundChannelHandler();
    public static final ChannelHandler OUTBOUND_CHANNEL_HANDLER = new HttpClientLifecycleOutboundChannelHandler();

    @ChannelHandler.Sharable
    private static class HttpClientLifecycleOutboundChannelHandler
    extends ChannelOutboundHandlerAdapter {
        private HttpClientLifecycleOutboundChannelHandler() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (msg instanceof HttpRequest) {
                HttpLifecycleChannelHandler.fireStartEvent(ctx, (HttpRequest)msg);
            }
            super.write(ctx, msg, promise);
        }

        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            HttpLifecycleChannelHandler.fireCompleteEventIfNotAlready(ctx, HttpLifecycleChannelHandler.CompleteReason.DISCONNECT);
            super.disconnect(ctx, promise);
        }

        public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            HttpLifecycleChannelHandler.fireCompleteEventIfNotAlready(ctx, HttpLifecycleChannelHandler.CompleteReason.DEREGISTER);
            super.deregister(ctx, promise);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            super.exceptionCaught(ctx, cause);
            HttpLifecycleChannelHandler.fireCompleteEventIfNotAlready(ctx, HttpLifecycleChannelHandler.CompleteReason.EXCEPTION);
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            HttpLifecycleChannelHandler.fireCompleteEventIfNotAlready(ctx, HttpLifecycleChannelHandler.CompleteReason.CLOSE);
            super.close(ctx, promise);
        }
    }

    @ChannelHandler.Sharable
    private static class HttpClientLifecycleInboundChannelHandler
    extends ChannelInboundHandlerAdapter {
        private HttpClientLifecycleInboundChannelHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof HttpResponse) {
                ctx.channel().attr(HttpLifecycleChannelHandler.ATTR_HTTP_RESP).set((Object)((HttpResponse)msg));
            }
            try {
                super.channelRead(ctx, msg);
            }
            finally {
                if (msg instanceof LastHttpContent) {
                    HttpLifecycleChannelHandler.fireCompleteEventIfNotAlready(ctx, HttpLifecycleChannelHandler.CompleteReason.SESSION_COMPLETE);
                }
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            try {
                super.channelInactive(ctx);
            }
            finally {
                HttpLifecycleChannelHandler.fireCompleteEventIfNotAlready(ctx, HttpLifecycleChannelHandler.CompleteReason.INACTIVE);
            }
        }
    }
}

