/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;

public class HttpChannelFlags {
    public static final Flag IN_BROWNOUT = new Flag("_brownout");
    public static final Flag CLOSING = new Flag("_connection_closing");

    public static class Flag {
        private final AttributeKey<Boolean> attributeKey;

        public Flag(String name) {
            this.attributeKey = AttributeKey.newInstance((String)name);
        }

        public void set(Channel ch) {
            ch.attr(this.attributeKey).set((Object)Boolean.TRUE);
        }

        public void remove(Channel ch) {
            ch.attr(this.attributeKey).set(null);
        }

        public void set(ChannelHandlerContext ctx) {
            this.set(ctx.channel());
        }

        public boolean get(Channel ch) {
            Attribute attr = ch.attr(this.attributeKey);
            Boolean value = (Boolean)attr.get();
            return value == null ? false : value;
        }

        public boolean get(ChannelHandlerContext ctx) {
            return this.get(ctx.channel());
        }
    }
}

