/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common;

import com.netflix.netty.common.ConnectionCloseChannelAttributes;
import com.netflix.netty.common.ConnectionCloseType;
import com.netflix.netty.common.HttpChannelFlags;
import com.netflix.netty.common.SourceAddressChannelHandler;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.zuul.util.HttpUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DelegatingChannelPromiseNotifier;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class Http2ConnectionCloseHandler
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Http2ConnectionCloseHandler.class);
    private final Registry registry;
    private final Id counterBaseId;

    @Inject
    public Http2ConnectionCloseHandler(Registry registry) {
        this.registry = registry;
        this.counterBaseId = registry.createId("server.connection.close.handled");
    }

    private void incrementCounter(ConnectionCloseType closeType, int port) {
        this.registry.counter(this.counterBaseId.withTag("close_type", closeType.name()).withTag("port", Integer.toString(port)).withTag("protocol", "http2")).increment();
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        Channel parent;
        ChannelPromise closeAfterPromise;
        if (this.isEndOfRequestResponse(msg) && (closeAfterPromise = this.shouldCloseAfter(ctx, parent = HttpUtils.getMainChannel(ctx))) != null) {
            promise.addListener(future -> this.closeChannel(ctx, closeAfterPromise));
        }
        super.write(ctx, msg, promise);
    }

    private ChannelPromise shouldCloseAfter(ChannelHandlerContext ctx, Channel parent) {
        ChannelPromise closeAfterPromise = (ChannelPromise)ctx.channel().attr(ConnectionCloseChannelAttributes.CLOSE_AFTER_RESPONSE).get();
        if (closeAfterPromise == null) {
            closeAfterPromise = (ChannelPromise)parent.attr(ConnectionCloseChannelAttributes.CLOSE_AFTER_RESPONSE).get();
        }
        return closeAfterPromise;
    }

    private boolean isEndOfRequestResponse(Object msg) {
        if (msg instanceof Http2HeadersFrame) {
            return ((Http2HeadersFrame)msg).isEndStream();
        }
        if (msg instanceof Http2DataFrame) {
            return ((Http2DataFrame)msg).isEndStream();
        }
        return false;
    }

    private void closeChannel(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        Channel child = ctx.channel();
        Channel parent = HttpUtils.getMainChannel(ctx);
        if (this.isAlreadyClosing(child)) {
            promise.setSuccess();
            return;
        }
        if (this.isAlreadyClosing(parent)) {
            return;
        }
        ConnectionCloseType closeType = ConnectionCloseType.fromChannel(parent);
        Integer port = (Integer)parent.attr(SourceAddressChannelHandler.ATTR_SERVER_LOCAL_PORT).get();
        port = port == null ? -1 : port;
        this.incrementCounter(closeType, port);
        switch (closeType) {
            case DELAYED_GRACEFUL: {
                this.gracefullyWithDelay(ctx.executor(), parent, promise);
                break;
            }
            case GRACEFUL: 
            case IMMEDIATE: {
                this.immediate(parent, promise);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ConnectionCloseEvent type! - " + (Object)((Object)closeType));
            }
        }
    }

    private void gracefullyWithDelay(EventExecutor executor, Channel parent, ChannelPromise promise) {
        boolean allowGracefulDelayed = ConnectionCloseChannelAttributes.allowGracefulDelayed(parent);
        if (!allowGracefulDelayed) {
            this.immediate(parent, promise);
            return;
        }
        if (!parent.isActive()) {
            promise.setSuccess();
            return;
        }
        DefaultHttp2GoAwayFrame goaway = new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR);
        goaway.setExtraStreamIds(Integer.MAX_VALUE);
        parent.writeAndFlush((Object)goaway);
        LOG.debug("gracefullyWithDelay: flushed initial go_away frame. channel=" + parent.id().asShortText());
        int gracefulCloseDelay = ConnectionCloseChannelAttributes.gracefulCloseDelay(parent);
        executor.schedule(() -> {
            if (parent.isActive()) {
                LOG.debug("gracefullyWithDelay: firing graceful_shutdown event to make netty send a final go_away frame and then close connection. channel=" + parent.id().asShortText());
                Http2Exception h2e = new Http2Exception(Http2Error.NO_ERROR, Http2Exception.ShutdownHint.GRACEFUL_SHUTDOWN);
                parent.pipeline().fireExceptionCaught((Throwable)h2e);
                parent.close().addListener(future -> promise.setSuccess());
            } else {
                promise.setSuccess();
            }
        }, (long)gracefulCloseDelay, TimeUnit.SECONDS);
    }

    private void immediate(Channel parent, ChannelPromise promise) {
        if (parent.isActive()) {
            parent.close().addListener((GenericFutureListener)new DelegatingChannelPromiseNotifier(promise));
        } else {
            promise.setSuccess();
        }
    }

    protected boolean isAlreadyClosing(Channel parentChannel) {
        if (HttpChannelFlags.CLOSING.get(parentChannel)) {
            return true;
        }
        HttpChannelFlags.CLOSING.set(parentChannel);
        return false;
    }
}

