/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;

public class CloseOnIdleStateHandler
extends ChannelInboundHandlerAdapter {
    private final Counter counter;

    public CloseOnIdleStateHandler(Registry registry, String metricId) {
        this.counter = registry.counter("server.connections.idle.timeout", new String[]{"id", metricId});
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        super.userEventTriggered(ctx, evt);
        if (evt instanceof IdleStateEvent) {
            this.counter.increment();
            ctx.close();
        }
    }
}

