/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common;

import com.netflix.config.CachedDynamicLongProperty;
import com.netflix.netty.common.ConnectionCloseChannelAttributes;
import com.netflix.netty.common.ConnectionCloseType;
import com.netflix.netty.common.HttpChannelFlags;
import com.netflix.zuul.netty.ChannelUtils;
import com.netflix.zuul.util.HttpUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstrHttpConnectionExpiryHandler
extends ChannelOutboundHandlerAdapter {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstrHttpConnectionExpiryHandler.class);
    protected static final CachedDynamicLongProperty MAX_EXPIRY_DELTA = new CachedDynamicLongProperty("server.connection.expiry.delta", 20000L);
    protected final ConnectionCloseType connectionCloseType;
    protected final int maxRequests;
    protected final int maxExpiry;
    protected final long connectionStartTime;
    protected final long connectionExpiryTime;
    protected int requestCount = 0;
    protected int maxRequestsUnderBrownout = 0;

    public AbstrHttpConnectionExpiryHandler(ConnectionCloseType connectionCloseType, int maxRequestsUnderBrownout, int maxRequests, int maxExpiry) {
        this.connectionCloseType = connectionCloseType;
        this.maxRequestsUnderBrownout = maxRequestsUnderBrownout;
        this.maxRequests = maxRequests;
        this.maxExpiry = maxExpiry;
        this.connectionStartTime = System.currentTimeMillis();
        long randomDelta = ThreadLocalRandom.current().nextLong(MAX_EXPIRY_DELTA.get());
        this.connectionExpiryTime = this.connectionStartTime + (long)maxExpiry + randomDelta;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (this.isResponseHeaders(msg)) {
            ++this.requestCount;
            if (this.isConnectionExpired(ctx.channel())) {
                Channel channel = HttpUtils.getMainChannel(ctx);
                ctx.channel().attr(ConnectionCloseChannelAttributes.CLOSE_AFTER_RESPONSE).set((Object)ctx.newPromise());
                ConnectionCloseType.setForChannel(channel, this.connectionCloseType);
            }
        }
        super.write(ctx, msg, promise);
    }

    protected boolean isConnectionExpired(Channel channel) {
        boolean expired;
        boolean bl = expired = this.requestCount >= this.maxRequests(channel) || System.currentTimeMillis() > this.connectionExpiryTime;
        if (expired) {
            long lifetime = System.currentTimeMillis() - this.connectionStartTime;
            LOG.info("Connection is expired. requestCount={}, lifetime={}, {}", new Object[]{this.requestCount, lifetime, ChannelUtils.channelInfoForLogging(channel)});
        }
        return expired;
    }

    protected abstract boolean isResponseHeaders(Object var1);

    protected int maxRequests(Channel ch) {
        if (HttpChannelFlags.IN_BROWNOUT.get(ch)) {
            return this.maxRequestsUnderBrownout;
        }
        return this.maxRequests;
    }
}

