/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtility {
    private static final Logger logger = LoggerFactory.getLogger(JsonUtility.class);

    public static String jsonFromMap(Map<String, Object> jsonData) {
        try {
            JsonDocument json = new JsonDocument();
            json.startGroup();
            for (String key : jsonData.keySet()) {
                Object data = jsonData.get(key);
                if (data instanceof Map) {
                    json.addValue(key, JsonUtility.jsonFromMap((Map)data));
                    continue;
                }
                if (data instanceof Object[]) {
                    json.addValue(key, "[" + JsonUtility.stringArrayFromObjectArray((Object[])data) + "]");
                    continue;
                }
                if (data instanceof Collection) {
                    json.addValue(key, "[" + JsonUtility.stringArrayFromObjectArray(((Collection)data).toArray()) + "]");
                    continue;
                }
                if (data instanceof int[]) {
                    String intArray = Arrays.toString((int[])data);
                    intArray = intArray.replaceAll(" ", "");
                    json.addValue(key, intArray);
                    continue;
                }
                if (data instanceof JsonCapableObject) {
                    json.addValue(key, JsonUtility.jsonFromMap(((JsonCapableObject)data).jsonMap()));
                    continue;
                }
                json.addValue(key, String.valueOf(data));
            }
            json.endGroup();
            logger.debug("created json from map => " + json.toString());
            return json.toString();
        }
        catch (Exception e) {
            logger.error("Could not create JSON from Map. ", (Throwable)e);
            return "{}";
        }
    }

    private static String stringArrayFromObjectArray(Object[] data) {
        StringBuilder arrayAsString = new StringBuilder();
        for (Object o : data) {
            if (arrayAsString.length() > 0) {
                arrayAsString.append(",");
            }
            if (o instanceof Map) {
                arrayAsString.append(JsonUtility.jsonFromMap((Map)o));
                continue;
            }
            if (o instanceof JsonCapableObject) {
                arrayAsString.append(JsonUtility.jsonFromMap(((JsonCapableObject)o).jsonMap()));
                continue;
            }
            arrayAsString.append("\"").append(String.valueOf(o)).append("\"");
        }
        return arrayAsString.toString();
    }

    public static class UnitTest {
        @Test
        public void testSimpleOne() {
            LinkedHashMap<String, Object> jsonData = new LinkedHashMap<String, Object>();
            jsonData.put("myKey", "myValue");
            String json = JsonUtility.jsonFromMap(jsonData);
            String expected = "{\"myKey\":\"myValue\"}";
            Assert.assertEquals((Object)expected, (Object)json);
        }

        @Test
        public void testSimpleTwo() {
            LinkedHashMap<String, Object> jsonData = new LinkedHashMap<String, Object>();
            jsonData.put("myKey", "myValue");
            jsonData.put("myKey2", "myValue2");
            String json = JsonUtility.jsonFromMap(jsonData);
            String expected = "{\"myKey\":\"myValue\",\"myKey2\":\"myValue2\"}";
            Assert.assertEquals((Object)expected, (Object)json);
        }

        @Test
        public void testNestedMapOne() {
            LinkedHashMap<String, Object> jsonData = new LinkedHashMap<String, Object>();
            jsonData.put("myKey", "myValue");
            LinkedHashMap<String, String> jsonData2 = new LinkedHashMap<String, String>();
            jsonData2.put("myNestedKey", "myNestedValue");
            jsonData.put("myNestedData", jsonData2);
            String json = JsonUtility.jsonFromMap(jsonData);
            String expected = "{\"myKey\":\"myValue\",\"myNestedData\":{\"myNestedKey\":\"myNestedValue\"}}";
            Assert.assertEquals((Object)expected, (Object)json);
        }

        @Test
        public void testNestedMapTwo() {
            LinkedHashMap<String, Object> jsonData = new LinkedHashMap<String, Object>();
            jsonData.put("myKey", "myValue");
            LinkedHashMap<String, String> jsonData2 = new LinkedHashMap<String, String>();
            jsonData2.put("myNestedKey", "myNestedValue");
            jsonData2.put("myNestedKey2", "myNestedValue2");
            jsonData.put("myNestedData", jsonData2);
            String json = JsonUtility.jsonFromMap(jsonData);
            String expected = "{\"myKey\":\"myValue\",\"myNestedData\":{\"myNestedKey\":\"myNestedValue\",\"myNestedKey2\":\"myNestedValue2\"}}";
            Assert.assertEquals((Object)expected, (Object)json);
        }

        @Test
        public void testArrayOne() {
            LinkedHashMap<String, Object> jsonData = new LinkedHashMap<String, Object>();
            int[] numbers = new int[]{1, 2, 3, 4};
            jsonData.put("myKey", numbers);
            String json = JsonUtility.jsonFromMap(jsonData);
            String expected = "{\"myKey\":[1,2,3,4]}";
            Assert.assertEquals((Object)expected, (Object)json);
        }

        @Test
        public void testArrayTwo() {
            LinkedHashMap<String, Object> jsonData = new LinkedHashMap<String, Object>();
            String[] values = new String[]{"one", "two", "three", "four"};
            jsonData.put("myKey", values);
            String json = JsonUtility.jsonFromMap(jsonData);
            String expected = "{\"myKey\":[\"one\",\"two\",\"three\",\"four\"]}";
            Assert.assertEquals((Object)expected, (Object)json);
        }

        @Test
        public void testCollectionOne() {
            LinkedHashMap<String, Object> jsonData = new LinkedHashMap<String, Object>();
            ArrayList<String> values = new ArrayList<String>();
            values.add("one");
            values.add("two");
            values.add("three");
            values.add("four");
            jsonData.put("myKey", values);
            String json = JsonUtility.jsonFromMap(jsonData);
            String expected = "{\"myKey\":[\"one\",\"two\",\"three\",\"four\"]}";
            Assert.assertEquals((Object)expected, (Object)json);
        }

        @Test
        public void testMapAndList() {
            LinkedHashMap<String, Object> jsonData = new LinkedHashMap<String, Object>();
            jsonData.put("myKey", "myValue");
            int[] numbers = new int[]{1, 2, 3, 4};
            jsonData.put("myNumbers", numbers);
            LinkedHashMap<String, Object> jsonData2 = new LinkedHashMap<String, Object>();
            jsonData2.put("myNestedKey", "myNestedValue");
            jsonData2.put("myNestedKey2", "myNestedValue2");
            String[] values = new String[]{"one", "two", "three", "four"};
            jsonData2.put("myStringNumbers", values);
            jsonData.put("myNestedData", jsonData2);
            String json = JsonUtility.jsonFromMap(jsonData);
            String expected = "{\"myKey\":\"myValue\",\"myNumbers\":[1,2,3,4],\"myNestedData\":{\"myNestedKey\":\"myNestedValue\",\"myNestedKey2\":\"myNestedValue2\",\"myStringNumbers\":[\"one\",\"two\",\"three\",\"four\"]}}";
            Assert.assertEquals((Object)expected, (Object)json);
        }

        @Test
        public void testArrayOfMaps() {
            LinkedHashMap<String, Object> jsonData = new LinkedHashMap<String, Object>();
            ArrayList messages = new ArrayList();
            LinkedHashMap<String, String> message1 = new LinkedHashMap<String, String>();
            message1.put("a", "valueA1");
            message1.put("b", "valueB1");
            messages.add(message1);
            LinkedHashMap<String, String> message2 = new LinkedHashMap<String, String>();
            message2.put("a", "valueA2");
            message2.put("b", "valueB2");
            messages.add(message2);
            jsonData.put("messages", messages);
            String json = JsonUtility.jsonFromMap(jsonData);
            String expected = "{\"messages\":[{\"a\":\"valueA1\",\"b\":\"valueB1\"},{\"a\":\"valueA2\",\"b\":\"valueB2\"}]}";
            Assert.assertEquals((Object)expected, (Object)json);
        }
    }

    public static interface JsonCapableObject {
        public Map<String, Object> jsonMap();
    }

    private static class JsonDocument {
        StringBuilder json = new StringBuilder();
        private boolean newGroup = false;

        private JsonDocument() {
        }

        public JsonDocument startGroup() {
            this.newGroup = true;
            this.json.append("{");
            return this;
        }

        public JsonDocument endGroup() {
            this.json.append("}");
            return this;
        }

        public JsonDocument addValue(String key, String value) {
            if (!this.newGroup) {
                this.json.append(",");
            }
            this.newGroup = false;
            this.json.append("\"").append(key).append("\"");
            this.json.append(":");
            if (value.trim().startsWith("{") || value.trim().startsWith("[")) {
                this.json.append(value);
            } else {
                this.json.append("\"").append(value).append("\"");
            }
            return this;
        }

        public String toString() {
            return this.json.toString();
        }
    }
}

