/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.stats;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timing {
    private static final Logger LOG = LoggerFactory.getLogger(Timing.class);
    private String name;
    private long startTime = 0L;
    private long endTime = 0L;
    private long duration = 0L;

    public Timing(String name) {
        this.name = name;
    }

    public void start() {
        this.startTime = System.nanoTime();
    }

    public void end() {
        this.endTime = System.nanoTime();
        this.duration = this.endTime - this.startTime;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Timing: name=%s, duration=%s", this.name, this.duration));
        }
    }

    public String getName() {
        return this.name;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public String toString() {
        return Long.toString(this.duration);
    }
}

