/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.stats;

import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.annotations.MonitorTags;
import com.netflix.servo.tag.BasicTag;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import com.netflix.zuul.stats.monitoring.NamedCount;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

public class ErrorStatsData
implements NamedCount {
    String id;
    @MonitorTags
    TagList tagList;
    String error_cause;
    @Monitor(name="count", type=DataSourceType.COUNTER)
    AtomicLong count = new AtomicLong();

    public ErrorStatsData(String route, String cause) {
        if (null == route || "".equals(route)) {
            route = "UNKNOWN";
        }
        this.id = route + "_" + cause;
        this.error_cause = cause;
        this.tagList = BasicTagList.of((Tag[])new Tag[]{new BasicTag("ID", this.id)});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorStatsData that = (ErrorStatsData)o;
        return !(this.error_cause == null ? that.error_cause != null : !this.error_cause.equals(that.error_cause));
    }

    public int hashCode() {
        return this.error_cause != null ? this.error_cause.hashCode() : 0;
    }

    public void update() {
        this.count.incrementAndGet();
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public long getCount() {
        return this.count.get();
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        @Test
        public void testUpdateStats() {
            ErrorStatsData sd = new ErrorStatsData("route", "test");
            Assert.assertEquals((Object)sd.error_cause, (Object)"test");
            sd.update();
            Assert.assertEquals((long)sd.count.get(), (long)1L);
            sd.update();
            Assert.assertEquals((long)sd.count.get(), (long)2L);
        }

        @Test
        public void testEquals() {
            ErrorStatsData sd = new ErrorStatsData("route", "test");
            ErrorStatsData sd1 = new ErrorStatsData("route", "test");
            ErrorStatsData sd2 = new ErrorStatsData("route", "test1");
            ErrorStatsData sd3 = new ErrorStatsData("route", "test");
            Assert.assertTrue((boolean)sd.equals(sd1));
            Assert.assertTrue((boolean)sd1.equals(sd));
            Assert.assertTrue((boolean)sd.equals(sd));
            Assert.assertFalse((boolean)sd.equals(sd2));
            Assert.assertFalse((boolean)sd2.equals(sd3));
        }
    }
}

